/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;

public class NearestEdgeResult {
    final IQuadEdge edge;
    final double edgeD;
    final double x;
    final double y;
    final boolean interior;
    Vertex vertex;
    double vertexD;

    public NearestEdgeResult(IQuadEdge edge, double edgeD, double queryX, double queryY, boolean interior) {
        this.edge = edge;
        this.edgeD = edgeD;
        this.x = queryX;
        this.y = queryY;
        this.interior = interior;
    }

    private void prepareNearestVertex() {
        if (this.vertex == null) {
            Vertex vMin = this.edge.getA();
            double dX = vMin.getX() - this.x;
            double dY = vMin.getY() - this.y;
            double d2Min = dX * dX + dY * dY;
            for (IQuadEdge e : this.edge.pinwheel()) {
                double d2;
                Vertex v = e.getB();
                if (v == null || !((d2 = (dX = v.getX() - this.x) * dX + (dY = v.getY() - this.y) * dY) < d2Min)) continue;
                d2Min = d2;
                vMin = v;
            }
            this.vertex = vMin;
            this.vertexD = Math.sqrt(d2Min);
        }
    }

    public IQuadEdge getEdge() {
        return this.edge;
    }

    public double getDistanceToEdge() {
        return this.edgeD;
    }

    public Vertex getNearestVertex() {
        this.prepareNearestVertex();
        return this.vertex;
    }

    public double getDistanceToNearestVertex() {
        this.prepareNearestVertex();
        return this.vertexD;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean isInterior() {
        return this.interior;
    }
}

