/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

public class Thresholds {
    public static final double PRECISION_THRESHOLD_FACTOR = 256.0;
    public static final double HALF_PLANE_THRESHOLD_FACTOR = 256.0;
    public static final double DELAUNAY_THRESHOLD_FACTOR = 256.0;
    public static final double IN_CIRCLE_THRESHOLD_FACTOR = 1048576.0;
    public static final double VERTEX_TOLERANCE_FACTOR_DEFAULT = 100000.0;
    private final double nominalPointSpacing;
    private final double precisionThreshold;
    private final double halfPlaneThreshold;
    private final double inCircleThreshold;
    private final double delaunayThreshold;
    private final double vertexTolerance;
    private final double vertexTolerance2;
    private final double circumcircleDeterminantThreshold;

    public Thresholds() {
        this.nominalPointSpacing = 1.0;
        double ulp = Math.ulp(this.nominalPointSpacing);
        this.precisionThreshold = 256.0 * ulp;
        this.halfPlaneThreshold = 256.0 * this.precisionThreshold;
        this.inCircleThreshold = 1048576.0 * this.precisionThreshold;
        this.delaunayThreshold = 256.0 * this.precisionThreshold;
        this.vertexTolerance = this.nominalPointSpacing / 100000.0;
        this.vertexTolerance2 = this.vertexTolerance * this.vertexTolerance;
        this.circumcircleDeterminantThreshold = 256.0 * this.inCircleThreshold;
    }

    public Thresholds(double nominalPointSpacing) {
        if (nominalPointSpacing <= 0.0) {
            throw new IllegalArgumentException("Nominal point spacing specification " + nominalPointSpacing + " is not greater than zero");
        }
        this.nominalPointSpacing = nominalPointSpacing;
        double ulp = Math.ulp(nominalPointSpacing);
        this.precisionThreshold = 256.0 * ulp;
        this.halfPlaneThreshold = 256.0 * this.precisionThreshold;
        this.inCircleThreshold = 1048576.0 * this.precisionThreshold;
        this.delaunayThreshold = 256.0 * this.precisionThreshold;
        this.vertexTolerance = nominalPointSpacing / 100000.0;
        this.vertexTolerance2 = this.vertexTolerance * this.vertexTolerance;
        this.circumcircleDeterminantThreshold = 32.0 * this.inCircleThreshold;
    }

    public double getInCircleThreshold() {
        return this.inCircleThreshold;
    }

    public double getVertexTolerance() {
        return this.vertexTolerance;
    }

    public double getVertexTolerance2() {
        return this.vertexTolerance2;
    }

    public double getPrecisionThreshold() {
        return this.precisionThreshold;
    }

    public double getNominalPointSpacing() {
        return this.nominalPointSpacing;
    }

    public double getDelaunayThreshold() {
        return this.delaunayThreshold;
    }

    public double getHalfPlaneThreshold() {
        return this.halfPlaneThreshold;
    }

    public double getCircumcircleDeterminantThreshold() {
        return this.circumcircleDeterminantThreshold;
    }
}

