/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;

public class VertexIterator
implements Iterator<Vertex> {
    IIncrementalTin tin;
    final Iterator<IQuadEdge> edgeIterator;
    final BitSet visited;
    Vertex nextVertex;
    IQuadEdge nextEdge;

    public VertexIterator(IIncrementalTin tin) {
        this.tin = tin;
        this.edgeIterator = tin.getEdgeIterator();
        this.visited = new BitSet(tin.getMaximumEdgeAllocationIndex() + 2);
    }

    @Override
    public boolean hasNext() {
        if (!this.tin.isBootstrapped()) {
            return false;
        }
        while (this.nextVertex == null) {
            if (this.nextEdge == null) {
                if (!this.edgeIterator.hasNext()) {
                    return false;
                }
                this.nextEdge = this.edgeIterator.next();
            }
            IQuadEdge e = this.nextEdge;
            int eIndex = this.nextEdge.getIndex();
            this.nextEdge = (eIndex & 1) == 0 ? this.nextEdge.getDual() : null;
            if (this.visited.get(eIndex)) continue;
            for (IQuadEdge edge : e.pinwheel()) {
                this.visited.set(edge.getIndex());
            }
            this.nextVertex = e.getA();
        }
        return true;
    }

    @Override
    public Vertex next() {
        if (this.nextVertex == null && !this.hasNext()) {
            throw new NoSuchElementException("No more vertices in TIN");
        }
        Vertex result = this.nextVertex;
        this.nextVertex = null;
        return result;
    }
}

