/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.contour;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.contour.TipLink;

public class Contour {
    static final AtomicInteger serialIdSource = new AtomicInteger();
    private static final int GROWTH_FACTOR = 256;
    int n;
    double[] xy = new double[256];
    final int contourId = serialIdSource.incrementAndGet();
    final int leftIndex;
    final int rightIndex;
    final double z;
    final boolean closedLoop;
    boolean traversedForward;
    boolean traversedBackward;
    TipLink startTip;
    TipLink terminalTip;

    public Contour(int leftIndex, int rightIndex, double z, boolean closedLoop) {
        this.leftIndex = leftIndex;
        this.rightIndex = rightIndex;
        this.z = z;
        this.closedLoop = closedLoop;
    }

    void add(IQuadEdge e, double zA, double zB) {
        if (this.n == this.xy.length) {
            this.xy = Arrays.copyOf(this.xy, this.xy.length + 256);
        }
        Vertex A = e.getA();
        Vertex B = e.getB();
        double zDelta = zB - zA;
        this.xy[this.n++] = ((this.z - zA) * B.getX() + (zB - this.z) * A.getX()) / zDelta;
        this.xy[this.n++] = ((this.z - zA) * B.getY() + (zB - this.z) * A.getY()) / zDelta;
    }

    void add(Vertex v) {
        if (this.n == this.xy.length) {
            this.xy = Arrays.copyOf(this.xy, this.xy.length + 256);
        }
        this.xy[this.n++] = v.getX();
        this.xy[this.n++] = v.getY();
    }

    public void add(double x, double y) {
        if (this.n == this.xy.length) {
            this.xy = Arrays.copyOf(this.xy, this.xy.length + 256);
        }
        this.xy[this.n++] = x;
        this.xy[this.n++] = y;
    }

    public double[] getCoordinates() {
        return Arrays.copyOf(this.xy, this.n);
    }

    public double[] getXY() {
        return Arrays.copyOf(this.xy, this.n);
    }

    public double getZ() {
        return this.z;
    }

    public boolean isEmpty() {
        return this.n < 4;
    }

    public int size() {
        return this.n / 2;
    }

    public void complete() {
        if (this.closedLoop && this.n >= 6) {
            double x0 = this.xy[0];
            double y0 = this.xy[1];
            double x1 = this.xy[this.n - 2];
            double y1 = this.xy[this.n - 1];
            if (x0 != x1 || y0 != y1) {
                this.add(x0, y0);
            }
        }
        if (this.xy.length > this.n) {
            this.xy = Arrays.copyOf(this.xy, this.n);
        }
    }

    public int getContourId() {
        return this.contourId;
    }

    public Path2D getPath2D(AffineTransform transform) {
        Path2D.Double path = new Path2D.Double();
        if (this.n >= 4) {
            double[] c = new double[this.n];
            transform.transform(this.xy, 0, c, 0, this.n / 2);
            ((Path2D)path).moveTo(c[0], c[1]);
            for (int i = 1; i < this.n / 2; ++i) {
                ((Path2D)path).lineTo(c[i * 2], c[i * 2 + 1]);
            }
            if (this.closedLoop) {
                path.closePath();
            }
        }
        return path;
    }

    public ContourType getContourType() {
        if (this.rightIndex == -1) {
            return ContourType.Boundary;
        }
        return ContourType.Interior;
    }

    public boolean isBoundary() {
        return this.rightIndex == -1;
    }

    public boolean isClosed() {
        return this.closedLoop;
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Double r2d = new Rectangle2D.Double(this.xy[0], this.xy[1], 0.0, 0.0);
        for (int i = 1; i < this.n / 2; ++i) {
            r2d.add(this.xy[i * 2], this.xy[i * 2 + 1]);
        }
        return r2d;
    }

    public String toString() {
        String cString = "";
        if (this.n >= 4) {
            double x0 = this.xy[0];
            double y0 = this.xy[1];
            double x1 = this.xy[this.n - 2];
            double y1 = this.xy[this.n - 1];
            cString = String.format("(x0,y0)=(%f,%f)  (x1,y1)=(%f,%f)", x0, y0, x1, y1);
        }
        return "Contour " + this.contourId + ": L=" + this.leftIndex + ", R=" + this.rightIndex + ", z=" + this.z + ", closed=" + this.closedLoop + "  " + cString;
    }

    public int getContourIndex() {
        if (this.rightIndex < 0) {
            return this.leftIndex;
        }
        return this.leftIndex - 1;
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public int getRightIndex() {
        return this.rightIndex;
    }

    void cleanUp() {
        this.startTip = null;
        this.terminalTip = null;
    }

    public static enum ContourType {
        Interior,
        Boundary;

    }
}

