/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.development.cdt;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.SimpleTriangle;
import org.tinfour.common.Vertex;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.utils.TriangleCollector;
import org.tinfour.utils.rendering.RenderingSurfaceAid;

public class ConstraintStarDemo
extends JPanel {
    static final long serialVersionUID = 1L;
    IIncrementalTin tin;
    int iVertex;
    BufferedImage backingImage;
    int backingWidth;
    int backingHeight;
    static final double A6 = Math.toRadians(6.0);
    static final double A18 = Math.toRadians(18.0);
    static final double A36 = Math.toRadians(36.0);
    static final double A72 = Math.toRadians(72.0);
    static final double rNotch = 1.0;
    static final double rPoint = 1.0 * (Math.cos(A36) + Math.sin(A36) * Math.tan(A72));

    ConstraintStarDemo() {
        super(new BorderLayout());
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<IConstraint> constraints = new ArrayList<IConstraint>();
        this.addGrid(vertices);
        this.addConstraintStar(constraints);
        this.addConstraintWedges(constraints);
        this.addEnclosingRing(constraints);
        this.tin = new IncrementalTin(1.0);
        this.tin.add(vertices, null);
        this.tin.addConstraints(constraints, true);
        int nInside = 0;
        int nBorder = 0;
        int nOutside = 0;
        for (IQuadEdge edge : this.tin.edges()) {
            if (edge.isConstrainedRegionBorder()) {
                ++nBorder;
                continue;
            }
            if (edge.isConstrainedRegionInterior()) {
                ++nInside;
                continue;
            }
            ++nOutside;
        }
        System.out.format("Edge Inside Constrained Regions:    %4d%n", nInside);
        System.out.format("Edge Bordering Constrained Regions: %4d%n", nBorder);
        System.out.format("Edge Outside Constrained Regions:   %4d%n", nOutside);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.backingWidth != this.getWidth() || this.backingHeight != this.getHeight()) {
            this.backingImage = this.renderImage(this.getWidth(), this.getHeight());
            this.backingWidth = this.getWidth();
            this.backingHeight = this.getHeight();
        }
        if (this.backingImage != null) {
            g2d.drawImage((Image)this.backingImage, 0, 0, null);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            ex.printStackTrace(System.err);
            System.exit(-1);
        }
        final ConstraintStarDemo testPanel = new ConstraintStarDemo();
        testPanel.setPreferredSize(new Dimension(600, 600));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.getB()oldMetal", Boolean.FALSE);
                JFrame frame = new JFrame("Constraint Star Demonstration");
                frame.setDefaultCloseOperation(3);
                frame.add(testPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private void addGrid(List<Vertex> vertices) {
        for (int i = 0; i <= 32; ++i) {
            for (int j = 0; j <= 32; ++j) {
                double y = (double)i / 4.0 - 4.0;
                double x = (double)j / 4.0 - 4.0;
                vertices.add(new Vertex(x, y, 0.0, this.iVertex++));
                if (i >= 32 || j >= 32) continue;
                vertices.add(new Vertex(x + 0.125, y + 0.125, this.iVertex++));
            }
        }
    }

    private void addConstraintStar(List<IConstraint> constraints) {
        PolygonConstraint p = new PolygonConstraint();
        p.setApplicationData(new Color(128, 255, 128));
        for (int i = 0; i < 5; ++i) {
            double a = A18 + (double)i * A72;
            double x = rPoint * Math.cos(a);
            double y = rPoint * Math.sin(a);
            Vertex v = new Vertex(x, y, 0.0, this.iVertex++);
            p.add(v);
            a = A36 + A18 + (double)i * A72;
            x = 1.0 * Math.cos(a);
            y = 1.0 * Math.sin(a);
            v = new Vertex(x, y, 0.0, this.iVertex++);
            p.add(v);
        }
        p.complete();
        constraints.add(p);
    }

    private void addConstraintWedges(List<IConstraint> constraints) {
        for (int iWedge = 0; iWedge < 5; ++iWedge) {
            PolygonConstraint wedge = new PolygonConstraint();
            wedge.setApplicationData(new Color(64, 128, 255));
            double a = A36 + A18 + (double)iWedge * A72;
            double x = 1.0 * Math.cos(a);
            double y = 1.0 * Math.sin(a);
            wedge.add(new Vertex(x, y, 0.0, this.iVertex++));
            double a0 = A18 + (double)iWedge * A72;
            for (int j = 0; j <= 12; ++j) {
                a = a0 + (double)j * A6;
                x = rPoint * Math.cos(a);
                y = rPoint * Math.sin(a);
                wedge.add(new Vertex(x, y, 0.0, this.iVertex++));
            }
            wedge.complete();
            constraints.add(wedge);
        }
    }

    private void addEnclosingRing(List<IConstraint> constraints) {
        PolygonConstraint c1 = new PolygonConstraint();
        for (int i = 0; i < 360; i += 6) {
            double a = Math.toRadians(i);
            double x = 3.5 * Math.cos(a);
            double y = 3.5 * Math.sin(a);
            c1.add(new Vertex(x, y, 0.0, this.iVertex++));
        }
        c1.complete();
        constraints.add(c1);
        PolygonConstraint c2 = new PolygonConstraint();
        for (int i = 0; i < 360; i += 6) {
            double a = -Math.toRadians(i);
            double x = 3.0 * Math.cos(a);
            double y = 3.0 * Math.sin(a);
            c2.add(new Vertex(x, y, 0.0, this.iVertex++));
        }
        c2.complete();
        constraints.add(c2);
        c1.setApplicationData(new Color(128, 255, 128));
        c2.setApplicationData(new Color(128, 255, 128));
    }

    private BufferedImage renderImage(int w, int h) {
        if (w == 0 || h == 0) {
            return null;
        }
        Rectangle2D bounds = this.tin.getBounds();
        double x0 = bounds.getMinX();
        double y0 = bounds.getMinY();
        double x1 = bounds.getMaxX();
        double y1 = bounds.getMaxY();
        RenderingSurfaceAid rsa = new RenderingSurfaceAid(w, h, 10, x0, y0, x1, y1);
        rsa.fillBackground(Color.white);
        AffineTransform af = rsa.getCartesianToPixelTransform();
        BufferedImage bImage = rsa.getBufferedImage();
        Graphics2D g2d = rsa.getGraphics2D();
        g2d.setStroke(new BasicStroke(1.0f));
        TriangleRenderer triangleRenderer = new TriangleRenderer(g2d, af);
        TriangleCollector.visitSimpleTriangles(this.tin, triangleRenderer);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(new Color(160, 160, 160));
        Line2D.Double l2d = new Line2D.Double();
        for (IQuadEdge e : this.tin.edges()) {
            if (e.isConstrainedRegionBorder()) continue;
            e.setLine2D(af, l2d);
            g2d.draw(l2d);
        }
        g2d.setColor(Color.black);
        for (IQuadEdge e : this.tin.edges()) {
            if (!e.isConstrainedRegionBorder()) continue;
            e.setLine2D(af, l2d);
            g2d.draw(l2d);
        }
        return bImage;
    }

    private static class TriangleRenderer
    implements Consumer<SimpleTriangle> {
        final Graphics2D g2d;
        final AffineTransform af;

        TriangleRenderer(Graphics2D g2d, AffineTransform af) {
            this.g2d = g2d;
            this.af = af;
        }

        @Override
        public void accept(SimpleTriangle t) {
            Object obj;
            IConstraint constraint = t.getContainingRegion();
            if (constraint != null && constraint.definesConstrainedRegion() && (obj = constraint.getApplicationData()) instanceof Color) {
                this.g2d.setColor((Color)obj);
                Path2D path = t.getPath2D(this.af);
                this.g2d.fill(path);
                this.g2d.draw(path);
            }
        }
    }
}

