/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.examples;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import javax.imageio.ImageIO;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.InterpolationMethod;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.demo.utils.TestPalette;
import org.tinfour.demo.utils.VertexLoader;
import org.tinfour.demo.utils.cdt.ConstraintLoader;
import org.tinfour.interpolation.IInterpolatorOverTin;
import org.tinfour.utils.GridSpecification;
import org.tinfour.utils.TinInstantiationUtility;
import org.tinfour.utils.Tincalc;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;

public class ExampleGridAndHillshade
implements IDevelopmentTest {
    static String[] mandatoryOptions = new String[]{"-in"};

    @Override
    public void runTest(PrintStream ps, String[] args) throws IOException {
        Class<?> tinClass;
        double sSpace;
        Date date = new Date();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.getDefault());
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        ps.format("ExampleGridAndHillshade%n", new Object[0]);
        ps.format("Date/time of test: %s (UTC)%n", sdFormat.format(date));
        TestOptions options = new TestOptions();
        options.setLidarClass(2);
        boolean[] optionsMatched = options.argumentScan(args);
        options.checkForMandatoryOptions(args, mandatoryOptions);
        Double cellsizeArg = options.scanDoubleOption(args, "-cellSize", optionsMatched);
        double cellSize = Double.NaN;
        if (cellsizeArg != null && (cellSize = cellsizeArg.doubleValue()) <= 0.0) {
            throw new IllegalArgumentException("Invalid cell size: " + cellSize);
        }
        InterpolationMethod method = options.getInterpolationMethod();
        double[] frame = options.getFrame();
        boolean isFrameSet = options.isFrameSet();
        options.checkForUnrecognizedArgument(args, optionsMatched);
        File inputFile = options.getInputFile();
        File outputFile = options.getOutputFile();
        File constraintsFile = options.getConstraintsFile();
        ps.format("Input file:       %s%n", this.fmtFileName(inputFile));
        ps.format("Output file:      %s%n", this.fmtFileName(outputFile));
        ps.format("Constraints file: %s%n", this.fmtFileName(constraintsFile));
        VertexLoader loader = new VertexLoader();
        List<Vertex> vertexList = loader.readInputFile(options);
        int nVertices = vertexList.size();
        ps.format("Number of vertices: %8d%n", nVertices);
        double xmin = loader.getXMin();
        double xmax = loader.getXMax();
        double ymin = loader.getYMin();
        double ymax = loader.getYMax();
        double zmin = loader.getZMin();
        double zmax = loader.getZMax();
        double area = (xmax - xmin) * (ymax - ymin);
        double nominalPointSpacing = sSpace = Tincalc.sampleSpacing(area, nVertices);
        ICoordinateTransform cTrans = loader.getCoordinateTransform();
        if (cTrans != null) {
            CoordinatePair g0 = new CoordinatePair();
            CoordinatePair g1 = new CoordinatePair();
            cTrans.inverse(xmin, ymin, g0);
            cTrans.inverse(xmax, ymax, g1);
            double gx = g1.x - g0.x;
            double gy = g1.y - g0.y;
            double gArea = gx * gy;
            double gsSpace = Tincalc.sampleSpacing(gArea, nVertices);
            ps.format("Source data horizontal coordinates were transformed%n", new Object[0]);
            if (loader.isSourceInGeographicCoordinates()) {
                ps.format("Geographic coordinates are mapped to projected coordinates%n", new Object[0]);
            }
            ps.format("Range x values:     %11.6f, %11.6f, (%f)%n", g0.x, g1.x, gx);
            ps.format("Range y values:     %11.6f, %11.6f, (%f)%n", g0.y, g1.y, gy);
            ps.format("Est. sample spacing:   %e degrees of arc%n", gsSpace);
        }
        if (Double.isNaN(cellSize)) {
            cellSize = nominalPointSpacing;
        }
        ps.format("Range x values:     %12.3f, %12.3f, (%f)%n", xmin, xmax, xmax - xmin);
        ps.format("Range y values:     %12.3f, %12.3f, (%f)%n", ymin, ymax, ymax - ymin);
        ps.format("Range z values:     %12.3f, %12.3f, (%f)%n", zmin, zmax, zmax - zmin);
        ps.format("Est. sample spacing:%12.3f%n", sSpace);
        ps.format("Grid cell size:     %12.3f%n", cellSize);
        ps.flush();
        double x0 = xmin;
        double y0 = ymin;
        double x1 = xmax;
        double y1 = ymax;
        if (isFrameSet) {
            x0 = frame[0];
            x1 = frame[1];
            y0 = frame[2];
            y1 = frame[3];
            ps.format("Frame x values:     %12.3f, %12.3f, (%f)%n", x0, x1, x1 - x0);
            ps.format("Frame y values:     %12.3f, %12.3f, (%f)%n", y0, y1, y1 - y0);
        }
        GridSpecification grid = new GridSpecification(GridSpecification.CellPosition.CenterOfCell, cellSize, x0, x1, y0, y1);
        ps.format("Output grid%n", new Object[0]);
        ps.format("   Rows:              %8d%n", grid.getRowCount());
        ps.format("   Columns:           %8d%n", grid.getColumnCount());
        ps.format("   Cells:             %8d%n", grid.getCellCount());
        ps.format("   Interpolation method: %s%n%n", new Object[]{method});
        TinInstantiationUtility tiu = new TinInstantiationUtility(0.5, nVertices);
        if (options.isTinClassSet()) {
            tinClass = options.getTinClass();
        } else {
            ps.println("Performing automatic selection of TIN class based on memory and number of vertices");
            tiu.printSummary(ps);
            tinClass = tiu.getTinClass();
        }
        IIncrementalTin tin = tiu.constructInstance(tinClass, nominalPointSpacing);
        ps.format("%nBuilding TIN using: %s%n", tin.getClass().getName());
        long time0 = System.nanoTime();
        tin.add(vertexList, null);
        long time1 = System.nanoTime();
        ps.format("Time to process vertices (milliseconds):    %12.3f%n", (double)(time1 - time0) / 1000000.0);
        if (constraintsFile != null) {
            ConstraintLoader conLoader = new ConstraintLoader();
            conLoader.setCoordinateTransform(cTrans);
            List<IConstraint> conList = conLoader.readConstraintsFile(constraintsFile);
            ps.format("Adding %d constraints, %d vertices to TIN%n", conList.size(), conLoader.getTotalPointCount());
            time0 = System.nanoTime();
            tin.addConstraints(conList, true);
            time1 = System.nanoTime();
            ps.format("Time to process constraints (milliseconds):%12.3f%n", (double)(time1 - time0) / 1000000.0);
            ps.format("Added %d synthetic vertices to restore Delaunay%n", tin.getSyntheticVertexCount());
        }
        if (outputFile == null) {
            ps.println("No output file specified");
            return;
        }
        int kVisible = 0;
        for (Vertex v : vertexList) {
            if (!(x0 <= v.getX()) || !(v.getX() <= x1) || !(y0 <= v.getY()) || !(v.getY() <= y1)) continue;
            ++kVisible;
        }
        ps.format("Estimated visible vertices: %11d%n", kVisible);
        ps.println("");
        ps.println("Interpolating elevation data to build grid using method: " + (Object)((Object)method));
        time0 = System.nanoTime();
        float[][] results = this.buildElevationGrid(tin, method, grid);
        time1 = System.nanoTime();
        ps.format("Elevation grid processing completed in %3.2f ms%n", (double)(time1 - time0) / 1000000.0);
        File file = this.prepFileNamedForSubject(outputFile, "_z", "asc");
        ps.println("Writing grid to file " + file.getAbsolutePath());
        ps.flush();
        File parent = file.getParentFile();
        if (!parent.exists()) {
            throw new IOException("Containing directory/folder for output does not exist " + parent.getPath());
        }
        grid.writeAsciiFile(file, results, "%4.3f", "-999");
        float eMin = Float.POSITIVE_INFINITY;
        float eMax = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < results.length; ++i) {
            for (int j = 0; j < results[i].length; ++j) {
                float eZ = results[i][j];
                if (eZ < eMin) {
                    eMin = eZ;
                }
                if (!(eZ > eMax)) continue;
                eMax = eZ;
            }
        }
        int nRows = grid.getRowCount();
        int nCols = grid.getColumnCount();
        int nCells = nRows * nCols;
        int[] argb = new int[nCells];
        if (options.isPaletteSet()) {
            TestPalette palette = options.getPalette();
            ps.println("Color-coding elevation data using palette: " + palette.getName());
            int k = 0;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                for (int iCol = 0; iCol < nCols; ++iCol) {
                    float z = results[iRow][iCol];
                    argb[k++] = Float.isNaN(z) ? -8355712 : palette.getARGB(results[iRow][iCol], eMin, eMax);
                }
            }
        } else {
            ps.println("No palette specified, filling background image with white");
            Arrays.fill(argb, -1);
        }
        ps.println("Building grid of hillshade data");
        time0 = System.nanoTime();
        float[][] hillshade = this.buildHillshadeGrid(ps, tin, method, grid);
        time1 = System.nanoTime();
        ps.format("Hillshade grid processing completed in %3.2f ms%n", (double)(time1 - time0) / 1000000.0);
        int k = 0;
        for (int iRow = 0; iRow < nRows; ++iRow) {
            for (int iCol = 0; iCol < nCols; ++iCol) {
                int p = argb[k];
                if (Float.isNaN(results[iRow][iCol])) {
                    argb[k++] = -8355712;
                    continue;
                }
                double s = hillshade[iRow][iCol];
                int red = (int)((double)(p >> 16 & 0xFF) * s);
                int grn = (int)((double)(p >> 8 & 0xFF) * s);
                int blu = (int)((double)(p & 0xFF) * s);
                argb[k++] = ((0xFF00 | red) << 8 | grn) << 8 | blu;
            }
        }
        BufferedImage bImage = new BufferedImage(nCols, nRows, 2);
        File imageFile = this.prepFileNamedForSubject(outputFile, "_hillshade", "png");
        ps.println("Writing hillshade image to " + imageFile.getAbsolutePath());
        bImage.setRGB(0, 0, nCols, nRows, argb, 0, nCols);
        ImageIO.write((RenderedImage)bImage, "PNG", imageFile);
        ps.println("Example application processing complete.");
    }

    float[][] buildElevationGrid(IIncrementalTin tin, InterpolationMethod method, GridSpecification grid) {
        int nRows = grid.getRowCount();
        int nCols = grid.getColumnCount();
        double xLL = grid.getLowerLeftX();
        double yUL = grid.getUpperRightY();
        double cellSize = grid.getCellSize();
        IInterpolatorOverTin interpolator = method.getInterpolator(tin);
        float[][] results = new float[nRows][nCols];
        for (int iRow = 0; iRow < nRows; ++iRow) {
            float[] row = results[iRow];
            double yRow = yUL - (double)iRow * cellSize;
            for (int iCol = 0; iCol < nCols; ++iCol) {
                double xCol = (double)iCol * cellSize + xLL;
                double z = interpolator.interpolate(xCol, yRow, null);
                row[iCol] = Double.isNaN(z) ? Float.NaN : (float)z;
            }
        }
        return results;
    }

    float[][] buildHillshadeGrid(PrintStream ps, IIncrementalTin tin, InterpolationMethod method, GridSpecification grid) {
        IInterpolatorOverTin interpolator = method.getInterpolator(tin);
        int nRows = grid.getRowCount();
        int nCols = grid.getColumnCount();
        double xLL = grid.getLowerLeftX();
        double yUL = grid.getUpperRightY();
        double cellSize = grid.getCellSize();
        double ambient = 0.25;
        double directLight = 1.0 - ambient;
        double sunAzimuth = Math.toRadians(135.0);
        double sunElevation = Math.toRadians(45.0);
        double cosA = Math.cos(sunAzimuth);
        double sinA = Math.sin(sunAzimuth);
        double cosE = Math.cos(sunElevation);
        double sinE = Math.sin(sunElevation);
        double xSun = cosA * cosE;
        double ySun = sinA * cosE;
        double zSun = sinE;
        float[][] results = new float[nRows][nCols];
        if (method == InterpolationMethod.NaturalNeighbor) {
            for (int iRow = 0; iRow < nRows; ++iRow) {
                float[] row = results[iRow];
                double yRow = yUL - (double)iRow * cellSize;
                double dx = xLL - cellSize / 2.0;
                double dy = yRow + cellSize / 2.0;
                double dz = interpolator.interpolate(dx, dy, null);
                double cx = xLL - cellSize / 2.0;
                double cy = yRow - cellSize / 2.0;
                double cz = interpolator.interpolate(cx, cy, null);
                for (int iCol = 0; iCol < nCols; ++iCol) {
                    double intensity;
                    double n;
                    double cosTheta;
                    double xCol = (double)iCol * cellSize + xLL;
                    double ax = dx;
                    double ay = dy;
                    double az = dz;
                    double bx = cx;
                    double by = cy;
                    double bz = cz;
                    dx = xCol + cellSize / 2.0;
                    dy = yRow + cellSize / 2.0;
                    dz = Double.NaN;
                    cx = xCol - cellSize / 2.0;
                    cy = yRow - cellSize / 2.0;
                    cz = Double.NaN;
                    double z = interpolator.interpolate(xCol, yRow, null);
                    dz = interpolator.interpolate(dx, dy, null);
                    cz = interpolator.interpolate(cx, cy, null);
                    if (Double.isNaN(z) || Double.isNaN(az) || Double.isNaN(bz) || Double.isNaN(cz) || Double.isNaN(dz)) {
                        row[iCol] = 0.0f;
                        continue;
                    }
                    double xA = ax - bx;
                    double yA = ay - by;
                    double zA = az - bz;
                    double xC = cx - bx;
                    double yC = cy - by;
                    double zC = cz - bz;
                    double xN = yC * zA - zC * yA;
                    double yN = zC * xA - xC * zA;
                    double zN = xC * yA - yC * xA;
                    yA = ay - dy;
                    zC = cz - dz;
                    zA = az - dz;
                    yC = cy - dy;
                    xC = cx - dx;
                    xA = ax - dx;
                    if ((cosTheta = ((xN += yA * zC - zA * yC) * xSun + (yN += zA * xC - xA * zC) * ySun + (zN += xA * yC - yA * xC) * zSun) / (n = Math.sqrt(xN * xN + yN * yN + zN * zN))) < 0.0) {
                        cosTheta = 0.0;
                    }
                    if (Double.isNaN(intensity = cosTheta * directLight + ambient)) {
                        row[iCol] = 0.0f;
                        continue;
                    }
                    if (intensity > 1.0) {
                        intensity = 1.0;
                    } else if (intensity <= 0.0) {
                        intensity = 0.0;
                    }
                    row[iCol] = (float)intensity;
                }
            }
        } else {
            for (int iRow = 0; iRow < nRows; ++iRow) {
                float[] row = results[iRow];
                double yRow = yUL - (double)iRow * cellSize;
                for (int iCol = 0; iCol < nCols; ++iCol) {
                    double intensity;
                    double xCol = (double)iCol * cellSize + xLL;
                    double z = interpolator.interpolate(xCol, yRow, null);
                    if (Double.isNaN(z)) {
                        row[iCol] = 0.0f;
                        continue;
                    }
                    double[] n = interpolator.getSurfaceNormal();
                    double cosTheta = n[0] * xSun + n[1] * ySun + n[2] * zSun;
                    if (cosTheta < 0.0) {
                        cosTheta = 0.0;
                    }
                    if ((intensity = cosTheta * directLight + ambient) > 1.0) {
                        intensity = 1.0;
                    } else if (intensity <= 0.0) {
                        intensity = 0.0;
                    }
                    row[iCol] = (float)intensity;
                }
            }
        }
        return results;
    }

    File prepFileNamedForSubject(File file, String subject, String extension) {
        String test;
        String rootName = file.getAbsolutePath();
        int period = rootName.lastIndexOf(46);
        if (period > 0 && period < rootName.length() - 1 && (".asc".equalsIgnoreCase(test = rootName.substring(period, rootName.length())) || ".txt".equalsIgnoreCase(test))) {
            rootName = rootName.substring(0, period);
        }
        return new File(rootName + subject + "." + extension);
    }

    public static void main(String[] args) {
        ExampleGridAndHillshade example = new ExampleGridAndHillshade();
        try {
            example.runTest(System.out, args);
        }
        catch (IOException | IllegalArgumentException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private String fmtFileName(File file) {
        if (file == null) {
            return "Not Supplied";
        }
        return file.getAbsolutePath();
    }
}

