/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.examples.contour;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.tinfour.common.Vertex;
import org.tinfour.contour.Contour;
import org.tinfour.contour.ContourBuilderForTin;
import org.tinfour.contour.ContourRegion;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.utils.rendering.RenderingSurfaceAid;

public class ExampleContour {
    private static final Color[] defaultColors = new Color[]{Color.YELLOW, Color.MAGENTA, Color.ORANGE, Color.LIGHT_GRAY, Color.PINK, Color.GREEN.brighter(), Color.RED, Color.BLUE};
    static final String[] input = new String[]{"4 4 4 4 4 4 3 3 3", "4 4 4 4 4 4 3 3 3", "4 4 4 0 4 4 4 4 4", "4 4 0 0 4 4 4 4 4", "4 4 4 4 4 4 4 4 4", "2 2 2 2 2 2 2 2 2", "2 2 2 2 2 2 2 2 2", "2 2 2 2 2 2 2 2 2", "2 2 2 2 2 2 2 2 2", "0 0 0 0 0 0 0 0 0", "2 2 0 0 0 2 0 0 0", "2 2 0 0 0 0 0 0 0"};
    static final double[] zContour = new double[]{1.0, 3.0};

    public static void main(String[] args) {
        int nRows = input.length;
        int nCols = input[0].length() / 2;
        ArrayList<Vertex> vList = new ArrayList<Vertex>(nRows * nCols);
        for (int iRow = 0; iRow < nRows; ++iRow) {
            double y = nRows - 1 - iRow;
            for (int iCol = 0; iCol < nCols; ++iCol) {
                double x = iCol;
                int iZ = input[iRow].charAt(iCol * 2) - 48;
                Vertex v = new Vertex(x, y, iZ, vList.size());
                vList.add(v);
            }
        }
        IncrementalTin tin = new IncrementalTin(1.0);
        tin.add(vList, null);
        ContourBuilderForTin builder = new ContourBuilderForTin(tin, null, zContour, true);
        List<Contour> contours = builder.getContours();
        List<ContourRegion> regions = builder.getRegions();
        double gridArea = (nRows - 1) * (nCols - 1);
        double sumArea = 0.0;
        for (ContourRegion region : regions) {
            sumArea += region.getAdjustedArea();
        }
        System.out.format("Total area of contour regions: %12.3f%n", sumArea);
        System.out.format("Overall area of input grid:    %12.3f%n", gridArea);
        double deltaArea = sumArea - gridArea;
        System.out.format("Difference in computed areas:  %f%n", Math.abs(deltaArea));
        System.out.format("%n", new Object[0]);
        System.out.format("Reg     Intvl   Area   Encl   N-Enclosed%n", new Object[0]);
        for (int i = 0; i < regions.size(); ++i) {
            System.out.format("%3d: %s%n", i, regions.get(i).toString());
        }
        System.out.format("%nContours%n", new Object[0]);
        for (Contour contour : contours) {
            System.out.println("  " + contour.toString());
        }
        double x0 = 0.0;
        double y0 = 0.0;
        double x1 = nCols - 1;
        double y1 = nRows - 1;
        int width = 650;
        int height = 650;
        int padding = 5;
        RenderingSurfaceAid rsa = new RenderingSurfaceAid(width, height, padding, x0, y0, x1, y1);
        rsa.fillBackground(Color.white);
        BufferedImage bImage = rsa.getBufferedImage();
        Graphics2D g2d = rsa.getGraphics2D();
        AffineTransform af = rsa.getCartesianToPixelTransform();
        for (ContourRegion region : regions) {
            Color color = defaultColors[region.getRegionIndex()];
            g2d.setColor(color);
            Path2D path = region.getPath2D(af);
            g2d.fill(path);
            g2d.draw(path);
        }
        g2d.setColor(Color.gray);
        for (Contour contour : contours) {
            Path2D path = contour.getPath2D(af);
            g2d.draw(path);
        }
        File output = new File("ExampleContour.png");
        System.out.println("\nWriting output image file to " + output.getAbsolutePath());
        try {
            ImageIO.write((RenderedImage)bImage, "PNG", output);
        }
        catch (IOException ioex) {
            System.out.println("Demonstration failed, I/O exception writeing image: " + ioex.getMessage());
        }
    }
}

