/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.tinfour.demo.viewer.DataViewingPanel;

class DataDropTargetListener
implements DropTargetListener {
    static final long serialVersionUID = 1L;
    private final DataViewingPanel testPanel;

    DataDropTargetListener(DataViewingPanel testPanel) {
        this.testPanel = testPanel;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            dtde.acceptDrag(1);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            dtde.acceptDrag(1);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable trans = dtde.getTransferable();
        if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrop(1);
            try {
                Object transferObject = trans.getTransferData(DataFlavor.javaFileListFlavor);
                if (transferObject instanceof List) {
                    List list = (List)transferObject;
                    for (Object object : list) {
                        if (!(object instanceof File)) continue;
                        File file = (File)object;
                        this.testPanel.loadModel(file);
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                ex.printStackTrace(System.out);
            }
        }
        dtde.getDropTargetContext().dropComplete(true);
    }

    private boolean isDragAcceptable(DropTargetDragEvent dtde) {
        Transferable trans = dtde.getTransferable();
        if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                Object transferObject = trans.getTransferData(DataFlavor.javaFileListFlavor);
                if (transferObject instanceof List) {
                    List list = (List)transferObject;
                    for (Object object : list) {
                        File file;
                        if (!(object instanceof File) || !(file = (File)object).isFile()) continue;
                        String name = file.getName();
                        int i = name.lastIndexOf(46);
                        if (i >= name.length() - 1) {
                            return false;
                        }
                        String ext = name.substring(i, name.length());
                        if (".LAS".equalsIgnoreCase(ext)) {
                            return true;
                        }
                        if (".LAZ".equalsIgnoreCase(ext)) {
                            return true;
                        }
                        if (".TXT".equalsIgnoreCase(ext)) {
                            return true;
                        }
                        if (".CSV".equalsIgnoreCase(ext)) {
                            return true;
                        }
                        return ".SHP".equalsIgnoreCase(ext);
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                ex.printStackTrace(System.out);
            }
        }
        return false;
    }
}

