/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.tinfour.common.Vertex;
import org.tinfour.demo.viewer.DataDropTargetListener;
import org.tinfour.demo.viewer.ExportImage;
import org.tinfour.demo.viewer.ScaleIntervals;
import org.tinfour.demo.viewer.ShapefileOptionsPanel;
import org.tinfour.demo.viewer.StatusPanel;
import org.tinfour.demo.viewer.backplane.BackplaneManager;
import org.tinfour.demo.viewer.backplane.CompositeImageScale;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.IModelChangeListener;
import org.tinfour.demo.viewer.backplane.LidarPointSelection;
import org.tinfour.demo.viewer.backplane.ModelFromLas;
import org.tinfour.demo.viewer.backplane.MvComposite;
import org.tinfour.demo.viewer.backplane.MvQueryResult;
import org.tinfour.demo.viewer.backplane.RenderProduct;
import org.tinfour.demo.viewer.backplane.RenderProductType;
import org.tinfour.demo.viewer.backplane.ViewOptions;
import org.tinfour.gis.shapefile.ShapefileReader;

public class DataViewingPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel readoutLabel;
    private StatusPanel statusPanel;
    private JEditorPane reportPane;
    private JEditorPane queryPane;
    private int priorWidth;
    private int priorHeight;
    private double resizeAnchorX = Double.NaN;
    private double resizeAnchorY = Double.NaN;
    BackplaneManager backplaneManager;
    private boolean redrawInProgress;
    boolean firstDraw = true;
    Point2D imagePressPoint;
    private ViewOptions viewOptions;
    private MvComposite mvComposite;
    private BufferedImage compositeImage;
    private BufferedImage legendImage;
    private AffineTransform c2p;
    private AffineTransform p2c;
    private AffineTransform p2m;
    private RenderProduct[] renderProducts = new RenderProduct[3];
    private MvQueryResult mvQueryResult;
    private boolean showScale;
    private boolean showLegend;
    Timer redrawTimer;
    private final List<IModelChangeListener> modelChangeListeners = new ArrayList<IModelChangeListener>();

    DataViewingPanel() {
        this.viewOptions = new ViewOptions();
    }

    void clear() {
        if (this.mvComposite != null && this.mvComposite.getModel().isLoaded()) {
            for (IModelChangeListener listener : this.modelChangeListeners) {
                listener.modelRemoved();
            }
        }
        this.backplaneManager.clear();
        this.mvComposite = null;
        this.compositeImage = null;
        this.legendImage = null;
        this.renderProducts[0] = null;
        this.renderProducts[1] = null;
        this.renderProducts[2] = null;
        this.reportPane.setText(null);
        this.queryPane.setText(null);
        this.repaint();
    }

    void setViewOptions(ViewOptions view) {
        LidarPointSelection newPointSelection;
        IModel model;
        ModelFromLas lasModel;
        LidarPointSelection oldPointSelection;
        this.viewOptions = view;
        this.setBackground(this.viewOptions.getBackground());
        this.backplaneManager.setViewOptions(view);
        if (!view.isWireframeSelected()) {
            this.renderProducts[RenderProductType.Wireframe.getStackingOrder()] = null;
        }
        if (!view.isConstraintRenderingSelected()) {
            this.renderProducts[RenderProductType.Constraints.getStackingOrder()] = null;
        }
        if (!view.isGridBasedRenderingSelected()) {
            this.renderProducts[RenderProductType.Raster.getStackingOrder()] = null;
        }
        this.assembleComposite();
        this.repaint();
        if (this.mvComposite != null && this.mvComposite.getModel() instanceof ModelFromLas && !(oldPointSelection = (lasModel = (ModelFromLas)(model = this.mvComposite.getModel())).getLidarPointSelection()).equals((Object)(newPointSelection = view.getLidarPointSelection()))) {
            model = new ModelFromLas(lasModel.getFile(), newPointSelection);
            CompositeImageScale ccs = this.getImageScaleForContinuity();
            this.mvComposite = this.backplaneManager.queueReloadTask(model, view, ccs);
            return;
        }
        this.checkForRedrawWithView(view);
    }

    void setQueryPane(JEditorPane queryPane) {
        this.queryPane = queryPane;
    }

    void setReadoutLabel(JLabel readoutLabel) {
        this.readoutLabel = readoutLabel;
    }

    void setReportPane(JEditorPane reportPane) {
        this.reportPane = reportPane;
    }

    void setStatusPanel(StatusPanel statusPanel) {
        this.statusPanel = statusPanel;
    }

    private void performAppInitialization() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (w == 0 || h == 0) {
            return;
        }
        this.backplaneManager = new BackplaneManager(this, this.statusPanel);
        DataDropTargetListener dropTargetListener = new DataDropTargetListener(this);
        DropTarget dropTarget = new DropTarget(this, 1, dropTargetListener, true);
        dropTarget.setDefaultActions(1);
        this.installStandardMouseListeners();
    }

    private void installStandardMouseListeners() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DataViewingPanel.this.mvComposite == null || !DataViewingPanel.this.mvComposite.isReady()) {
                    DataViewingPanel.this.readoutLabel.setText("");
                } else if (e.getButton() == 1) {
                    double[] c = new double[4];
                    c[0] = e.getX();
                    c[1] = e.getY();
                    DataViewingPanel.this.p2c.transform(c, 0, c, 2, 1);
                    DataViewingPanel.this.mvQueryResult = DataViewingPanel.this.mvComposite.performQuery(c[2], c[3]);
                    DataViewingPanel.this.queryPane.setText(DataViewingPanel.this.mvQueryResult.getText());
                    DataViewingPanel.this.repaint();
                    Vertex v = DataViewingPanel.this.mvQueryResult.getNearestVertex();
                    System.out.format("%13.4f,%13.4f,%13.4f,%8d%n", v.getX(), v.getY(), v.getZ(), v.getIndex());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (DataViewingPanel.this.mvComposite == null || !DataViewingPanel.this.mvComposite.isReady()) {
                    return;
                }
                DataViewingPanel.this.imagePressPoint = new Point2D.Double(e.getX(), e.getY());
                DataViewingPanel.this.p2c.transform(DataViewingPanel.this.imagePressPoint, DataViewingPanel.this.imagePressPoint);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DataViewingPanel.this.imagePressPoint = null;
                DataViewingPanel.this.checkForRedraw();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DataViewingPanel.this.resizeAnchorX = Double.NaN;
                DataViewingPanel.this.resizeAnchorY = Double.NaN;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DataViewingPanel.this.resizeAnchorX = Double.NaN;
                DataViewingPanel.this.resizeAnchorY = Double.NaN;
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (DataViewingPanel.this.imagePressPoint == null) {
                    return;
                }
                double s = Math.sqrt(Math.abs(DataViewingPanel.this.c2p.getDeterminant()));
                DataViewingPanel.this.c2p = DataViewingPanel.this.buildTransform(e.getX(), e.getY(), DataViewingPanel.this.imagePressPoint.getX(), DataViewingPanel.this.imagePressPoint.getY(), s);
                DataViewingPanel.this.repaint();
                try {
                    DataViewingPanel.this.p2c = DataViewingPanel.this.c2p.createInverse();
                }
                catch (NoninvertibleTransformException nex) {
                    return;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (DataViewingPanel.this.mvComposite != null && DataViewingPanel.this.mvComposite.isReady()) {
                    double[] c = new double[4];
                    c[0] = e.getX();
                    c[1] = e.getY();
                    DataViewingPanel.this.p2c.transform(c, 0, c, 2, 1);
                    String s = DataViewingPanel.this.mvComposite.getModelDataStringAtCoordinates(c[2], c[3]);
                    DataViewingPanel.this.readoutLabel.setText(s);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (DataViewingPanel.this.mvComposite == null || !DataViewingPanel.this.mvComposite.isReady()) {
                    return;
                }
                int clicks = e.getWheelRotation();
                int x = e.getX();
                int y = e.getY();
                Point2D.Double anchor = new Point2D.Double(x, y);
                DataViewingPanel.this.p2c.transform(anchor, anchor);
                double zf = Math.pow(2.0, (double)(-clicks) / 16.0);
                double s = Math.sqrt(Math.abs(DataViewingPanel.this.c2p.getDeterminant()));
                DataViewingPanel.this.c2p = DataViewingPanel.this.buildTransform(x, y, ((Point2D)anchor).getX(), ((Point2D)anchor).getY(), s * zf);
                try {
                    DataViewingPanel.this.p2c = DataViewingPanel.this.c2p.createInverse();
                }
                catch (NoninvertibleTransformException nex) {
                    return;
                }
                DataViewingPanel.this.repaint();
                DataViewingPanel.this.checkForRedraw();
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (DataViewingPanel.this.mvComposite == null || !DataViewingPanel.this.mvComposite.isReady()) {
                    return;
                }
                if (Double.isNaN(DataViewingPanel.this.resizeAnchorX)) {
                    double[] c = new double[4];
                    c[0] = (double)DataViewingPanel.this.priorWidth / 2.0;
                    c[1] = (double)DataViewingPanel.this.priorHeight / 2.0;
                    DataViewingPanel.this.p2c.transform(c, 0, c, 2, 1);
                    DataViewingPanel.this.resizeAnchorX = c[2];
                    DataViewingPanel.this.resizeAnchorY = c[3];
                }
                double xPixel = (double)DataViewingPanel.this.getWidth() / 2.0;
                double yPixel = (double)DataViewingPanel.this.getHeight() / 2.0;
                double s = Math.sqrt(Math.abs(DataViewingPanel.this.c2p.getDeterminant()));
                DataViewingPanel.this.c2p = DataViewingPanel.this.buildTransform(xPixel, yPixel, DataViewingPanel.this.resizeAnchorX, DataViewingPanel.this.resizeAnchorY, s);
                try {
                    DataViewingPanel.this.p2c = DataViewingPanel.this.c2p.createInverse();
                }
                catch (NoninvertibleTransformException nex) {
                    return;
                }
                DataViewingPanel.this.checkForRedraw();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.priorWidth = this.getWidth();
        this.priorHeight = this.getHeight();
        if (this.backplaneManager == null) {
            this.performAppInitialization();
        }
        if (this.compositeImage != null) {
            g2d.drawImage(this.compositeImage, this.c2p, this);
            if (this.mvComposite != null && this.mvComposite.isReady()) {
                double p2cScale;
                if (this.showScale && Math.abs((p2cScale = Math.abs(this.p2c.getDeterminant())) - 1.0) < 1.0E-6) {
                    double s = Math.sqrt(Math.abs(this.p2m.getDeterminant()));
                    int x0 = this.getWidth() - 240;
                    int y0 = this.getHeight() - 25;
                    ScaleIntervals si = ScaleIntervals.computeIntervals(200, 10, s);
                    Font f = this.getFont();
                    String family = f.getFamily();
                    f = new Font(family, 1, 14);
                    si.render(g, x0, y0, f, Color.white, Color.black);
                }
                if (this.showLegend && this.legendImage != null) {
                    int h = this.legendImage.getHeight();
                    int y0 = this.getHeight() - h - 5;
                    if (y0 < 5) {
                        y0 = 5;
                    }
                    g.drawImage(this.legendImage, 5, y0, this);
                }
            }
            if (this.mvQueryResult != null) {
                Point2D.Double p = new Point2D.Double();
                this.c2p.transform(this.mvQueryResult.getCompositePoint(), p);
                int px = (int)((Point2D)p).getX();
                int py = (int)((Point2D)p).getY();
                g2d.setStroke(new BasicStroke(3.0f));
                g2d.setColor(Color.black);
                g2d.drawLine(px - 10, py, px + 10, py);
                g2d.drawLine(px, py - 10, px, py + 10);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.setColor(Color.white);
                g2d.drawLine(px - 10, py, px + 10, py);
                g2d.drawLine(px, py - 10, px, py + 10);
            }
        }
    }

    ExportImage getRenderedImage(boolean transparentBackground, boolean addFrame) {
        int iW = this.getWidth();
        int iH = this.getHeight();
        BufferedImage bImage = new BufferedImage(iW, iH, 2);
        Graphics2D g2d = bImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!transparentBackground) {
            Color c = this.viewOptions.getBackground();
            g2d.setColor(c);
            g2d.fillRect(0, 0, iW + 1, iH + 1);
        }
        if (this.compositeImage == null) {
            return null;
        }
        g2d.drawImage(this.compositeImage, this.c2p, null);
        if (this.mvComposite != null && this.mvComposite.isReady()) {
            double p2cScale;
            if (this.showScale && Math.abs((p2cScale = Math.abs(this.p2c.getDeterminant())) - 1.0) < 1.0E-6) {
                double s = Math.sqrt(Math.abs(this.p2m.getDeterminant()));
                int x0 = this.getWidth() - 240;
                int y0 = this.getHeight() - 25;
                ScaleIntervals si = ScaleIntervals.computeIntervals(200, 10, s);
                Font f = this.getFont();
                String family = f.getFamily();
                f = new Font(family, 1, 14);
                si.render(g2d, x0, y0, f, Color.white, Color.black);
            }
            if (this.showLegend && this.legendImage != null) {
                int h = this.legendImage.getHeight();
                int y0 = this.getHeight() - h - 5;
                if (y0 < 5) {
                    y0 = 5;
                }
                g2d.drawImage((Image)this.legendImage, 5, y0, this);
            }
        }
        if (addFrame) {
            g2d.setColor(Color.darkGray);
            g2d.drawRect(0, 0, iW - 1, iH - 1);
        }
        return new ExportImage(bImage, this.p2m);
    }

    private void triggerModelRemoved() {
        if (this.mvComposite != null) {
            for (IModelChangeListener listener : this.modelChangeListeners) {
                listener.modelRemoved();
            }
        }
    }

    private void triggerModelAdded(IModel model) {
        for (IModelChangeListener listener : this.modelChangeListeners) {
            listener.modelAdded(model);
        }
    }

    void loadModel(File file) {
        this.clearState();
        String ext = this.getFileExtension(file);
        if ("shp".equalsIgnoreCase(ext)) {
            this.raiseShapefileOptions(file);
        } else {
            IModel model = this.backplaneManager.loadModel(file, null);
            this.postModelName(model);
            this.repaint();
        }
    }

    void loadModel(IModel model) {
        this.clearState();
        this.postModelName(model);
        this.backplaneManager.loadModel(model);
        this.repaint();
    }

    private void postModelName(IModel model) {
        String name;
        String title = "Tinfour viewer";
        if (model != null && (name = model.getName()) != null && !(name = name.trim()).isEmpty()) {
            title = title + ": " + name;
        }
        for (Container component = this.getParent(); component != null; component = component.getParent()) {
            if (!(component instanceof JFrame)) continue;
            ((JFrame)component).setTitle(title);
            break;
        }
    }

    void clearState() {
        this.triggerModelRemoved();
        this.backplaneManager.clear();
        this.mvComposite = null;
        this.mvQueryResult = null;
        this.renderProducts[0] = null;
        this.renderProducts[1] = null;
        this.renderProducts[2] = null;
        this.compositeImage = null;
        this.legendImage = null;
        this.resizeAnchorX = Double.NaN;
        this.resizeAnchorY = Double.NaN;
        this.reportPane.setText(null);
        this.queryPane.setText(null);
        this.readoutLabel.setText("");
        int pad = this.viewOptions.getPadding();
        this.c2p = AffineTransform.getTranslateInstance(-pad, -pad);
        this.p2c = AffineTransform.getTranslateInstance(pad, pad);
    }

    void loadConstraintsAndAddToModel(File file) {
        if (this.mvComposite == null) {
            JOptionPane.showMessageDialog(this, "Cannot add constraints when no model is loaded", "Error adding constraints", 0);
            return;
        }
        String ext = this.getFileExtension(file);
        IModel model = this.mvComposite.getModel();
        CompositeImageScale ccs = this.getImageScaleForContinuity();
        if ("shp".equalsIgnoreCase(ext)) {
            this.raiseShapefileOptionsForConstraint(model, file, ccs);
            return;
        }
        MvComposite mvc = this.backplaneManager.queueConstraintLoadingTask(model, file, ccs, null);
        if (mvc != null) {
            this.mvComposite = mvc;
            model = mvc.getModel();
        }
    }

    void zoomToSource() {
        if (this.mvComposite != null && this.mvComposite.isReady()) {
            IModel model = this.mvComposite.getModel();
            CompositeImageScale ccs = this.getImageScaleToCenterModelInPanel(model);
            MvComposite newComposite = this.backplaneManager.queueHeavyweightRenderTask(model, this.viewOptions, ccs);
            this.setMvComposite(newComposite);
        }
    }

    private void setMvComposite(MvComposite mvComposite) {
        int pad = this.viewOptions.getPadding();
        this.c2p = AffineTransform.getTranslateInstance(-pad, -pad);
        this.p2c = AffineTransform.getTranslateInstance(pad, pad);
        this.mvComposite = mvComposite;
        this.assembleLegend();
        this.mvQueryResult = null;
        AffineTransform c2m = mvComposite.getComposite2ModelTransform();
        this.p2m = new AffineTransform(c2m);
        this.p2m.concatenate(this.p2c);
        this.resizeAnchorX = Double.NaN;
        this.resizeAnchorY = Double.NaN;
        this.repaint();
    }

    public void postImageUpdate(RenderProduct product) {
        if (this.mvComposite == null) {
            this.setMvComposite(product.composite);
        } else if (!product.composite.equals(this.mvComposite)) {
            return;
        }
        String reportText = this.mvComposite.getModelAndRenderingReport();
        this.reportPane.setText(reportText);
        int index = product.layerType.getStackingOrder();
        this.renderProducts[index] = product;
        this.assembleComposite();
        this.repaint();
    }

    public void postModelLoadFailed(IModel model) {
        this.clear();
    }

    public void postMvComposite(MvComposite composite) {
        this.setMvComposite(composite);
        this.triggerModelAdded(composite.getModel());
    }

    void assembleComposite() {
        if (this.mvComposite == null) {
            this.compositeImage = null;
            return;
        }
        this.compositeImage = new BufferedImage(this.mvComposite.getWidth(), this.mvComposite.getHeight(), 2);
        Graphics2D g = this.compositeImage.createGraphics();
        for (int i = this.renderProducts.length - 1; i >= 0; --i) {
            if (this.renderProducts[i] == null) continue;
            if (this.renderProducts[i].compatibilityTransform == null) {
                g.drawImage((Image)this.renderProducts[i].image, 0, 0, null);
                continue;
            }
            g.drawImage(this.renderProducts[i].image, this.renderProducts[i].compatibilityTransform, null);
        }
    }

    private AffineTransform buildTransform(double pX, double pY, double mX, double mY, double s) {
        double xOffset = pX - s * mX;
        double yOffset = pY - s * mY;
        return new AffineTransform(s, 0.0, 0.0, s, xOffset, yOffset);
    }

    private boolean isRedrawRequired() {
        AffineTransform m2p;
        if (this.mvComposite == null || this.compositeImage == null) {
            return false;
        }
        double s = Math.sqrt(Math.abs(this.c2p.getDeterminant()));
        if (Math.abs(1.0 - s) > 0.001) {
            return true;
        }
        Rectangle2D.Double rectP = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        double[] c = new double[8];
        c[0] = 0.0;
        c[1] = 0.0;
        c[2] = this.compositeImage.getWidth();
        c[3] = this.compositeImage.getHeight();
        this.c2p.transform(c, 0, c, 4, 2);
        Rectangle2D.Double rectC = new Rectangle2D.Double(c[4], c[5], c[6] - c[4], c[7] - c[5]);
        Area areaP = new Area(rectP);
        Area areaC = new Area(rectC);
        this.p2m = this.mvComposite.getComposite2ModelTransform();
        this.p2m.concatenate(this.p2c);
        try {
            m2p = this.p2m.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            return true;
        }
        IModel model = this.mvComposite.getModel();
        double mx0 = model.getMinX();
        double mx1 = model.getMaxX();
        double my0 = model.getMinY();
        double my1 = model.getMaxY();
        c[0] = mx0;
        c[1] = my1;
        c[2] = mx1;
        c[3] = my0;
        m2p.transform(c, 0, c, 4, 2);
        Rectangle2D.Double rectM = new Rectangle2D.Double(c[4], c[5], c[6] - c[4], c[7] - c[5]);
        if (!areaP.intersects(rectM)) {
            return false;
        }
        areaP.subtract(areaC);
        if (areaP.isEmpty()) {
            return false;
        }
        return areaP.intersects(rectM);
    }

    private void checkForRedraw() {
        if (this.redrawTimer != null) {
            this.redrawTimer.stop();
            this.redrawTimer = null;
        }
        if (this.redrawInProgress) {
            return;
        }
        this.redrawTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataViewingPanel.this.redrawTimer = null;
                boolean status = DataViewingPanel.this.isRedrawRequired();
                if (!status) {
                    return;
                }
                int pad = DataViewingPanel.this.viewOptions.getPadding();
                AffineTransform a = AffineTransform.getTranslateInstance(pad, pad);
                AffineTransform m2c = DataViewingPanel.this.mvComposite.getModel2CompositeTransform();
                a.concatenate(DataViewingPanel.this.c2p);
                a.concatenate(m2c);
                for (int i = 0; i < DataViewingPanel.this.renderProducts.length; ++i) {
                    if (DataViewingPanel.this.renderProducts[i] == null) continue;
                    AffineTransform compatibility = AffineTransform.getTranslateInstance(pad, pad);
                    compatibility.concatenate(DataViewingPanel.this.c2p);
                    if (((DataViewingPanel)DataViewingPanel.this).renderProducts[i].compatibilityTransform == null) {
                        ((DataViewingPanel)DataViewingPanel.this).renderProducts[i].compatibilityTransform = compatibility;
                        continue;
                    }
                    ((DataViewingPanel)DataViewingPanel.this).renderProducts[i].compatibilityTransform.preConcatenate(compatibility);
                }
                CompositeImageScale ccs = DataViewingPanel.this.getImageScaleForContinuity();
                DataViewingPanel.this.mvComposite = DataViewingPanel.this.backplaneManager.queueHeavyweightRenderTask(DataViewingPanel.this.mvComposite.getModel(), DataViewingPanel.this.mvComposite.getView(), ccs);
                DataViewingPanel.this.assembleLegend();
                DataViewingPanel.this.setMvComposite(DataViewingPanel.this.mvComposite);
                for (int i = 0; i < DataViewingPanel.this.renderProducts.length; ++i) {
                    if (DataViewingPanel.this.renderProducts[i] == null) continue;
                    ((DataViewingPanel)DataViewingPanel.this).renderProducts[i].composite = DataViewingPanel.this.mvComposite;
                }
                DataViewingPanel.this.assembleComposite();
            }
        });
        this.redrawTimer.setRepeats(false);
        this.redrawTimer.start();
    }

    private void checkForRedrawWithView(ViewOptions view) {
        if (this.mvComposite == null || !this.mvComposite.isReady()) {
            return;
        }
        if (this.redrawTimer != null) {
            this.redrawTimer.stop();
            this.redrawTimer = null;
        }
        CompositeImageScale ccs = this.getImageScaleForContinuity();
        IModel model = this.mvComposite.getModel();
        ViewOptions oldView = this.mvComposite.getView();
        this.viewOptions = view;
        boolean heavyweightRedrawRequired = false;
        if (view.isWireframeSelected() && oldView.getWireframeSampleThinning() != view.getWireframeSampleThinning()) {
            heavyweightRedrawRequired = true;
        }
        if (view.isWireframeSelected() && !oldView.isWireframeSelected()) {
            heavyweightRedrawRequired = true;
        }
        if (view.isRasterSelected()) {
            if (!oldView.isRasterSelected()) {
                heavyweightRedrawRequired = true;
            }
            if (view.isHillshadeSelected()) {
                boolean hillshadeBuilt;
                boolean bl = hillshadeBuilt = oldView.isHillshadeSelected() || oldView.getRasterInterpolationMethod() == ViewOptions.RasterInterpolationMethod.GeographicallyWeightedRegression;
                if (!hillshadeBuilt) {
                    heavyweightRedrawRequired = true;
                }
            }
            if (view.isFullResolutionGridSelected() != oldView.isFullResolutionGridSelected()) {
                heavyweightRedrawRequired = true;
            }
            if (view.getRasterInterpolationMethod() != oldView.getRasterInterpolationMethod()) {
                heavyweightRedrawRequired = true;
            }
        }
        if (heavyweightRedrawRequired) {
            MvComposite newComposite;
            this.mvComposite = newComposite = this.backplaneManager.queueHeavyweightRenderTask(model, view, ccs);
            this.assembleLegend();
            this.mvQueryResult = null;
        } else {
            MvComposite newComposite;
            this.mvComposite = newComposite = this.backplaneManager.queueLightweightRenderTask(this.mvComposite, view);
            this.assembleLegend();
            this.mvQueryResult = null;
        }
    }

    void zoomToModelPosition(double x, double y, double targetModelWidth) {
        AffineTransform c2m;
        if (this.mvComposite == null || !this.mvComposite.isReady()) {
            return;
        }
        if (this.redrawTimer != null) {
            this.redrawTimer.stop();
            this.redrawTimer = null;
        }
        int pad = this.viewOptions.getPadding();
        IModel model = this.mvComposite.getModel();
        int w = this.getWidth();
        int h = this.getHeight();
        double currentUnitPerPixel = Math.sqrt(Math.abs(this.p2m.getDeterminant()));
        double currentModelWidth = (double)w * currentUnitPerPixel;
        double scaleFactor = targetModelWidth / currentModelWidth;
        double unitPerPixel = currentUnitPerPixel * scaleFactor;
        double pixelPerUnit = 1.0 / unitPerPixel;
        AffineTransform m2c = new AffineTransform(pixelPerUnit, 0.0, 0.0, -pixelPerUnit, (double)(w / 2 + pad) - pixelPerUnit * x, (double)(h / 2 + pad) + pixelPerUnit * y);
        try {
            c2m = m2c.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace(System.out);
            return;
        }
        CompositeImageScale ccs = new CompositeImageScale(this.getWidth() + 2 * pad, this.getHeight() + 2 * pad, m2c, c2m);
        this.renderProducts[0] = null;
        this.renderProducts[1] = null;
        this.renderProducts[2] = null;
        this.mvComposite = null;
        this.mvQueryResult = null;
        this.compositeImage = null;
        this.legendImage = null;
        this.resizeAnchorX = Double.NaN;
        this.resizeAnchorY = Double.NaN;
        this.reportPane.setText(null);
        this.queryPane.setText(null);
        this.readoutLabel.setText("");
        this.c2p = AffineTransform.getTranslateInstance(-pad, -pad);
        this.p2c = AffineTransform.getTranslateInstance(pad, pad);
        MvComposite newComposite = this.backplaneManager.queueHeavyweightRenderTask(model, this.viewOptions, ccs);
        this.setMvComposite(newComposite);
        this.assembleLegend();
    }

    void setShowScale(boolean showScale) {
        this.showScale = showScale;
        this.repaint();
    }

    void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
        this.assembleLegend();
        this.repaint();
    }

    void assembleLegend() {
        if (this.showLegend && this.mvComposite != null) {
            Font font = new Font("Arial", 1, 10);
            this.legendImage = this.mvComposite.renderLegend(this.mvComposite.getView(), this.mvComposite.getModel(), 50, 100, 10, font, true);
        } else {
            this.legendImage = null;
        }
    }

    MvComposite getMvComposite() {
        return this.mvComposite;
    }

    AffineTransform getPanelToModelTransform() {
        return this.p2m;
    }

    public void addModelChangeListener(IModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void removeModelChangeListener(IModelChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }

    public IModel getModel() {
        if (this.mvComposite != null) {
            return this.mvComposite.getModel();
        }
        return null;
    }

    public CompositeImageScale getImageScaleToCenterModelInPanel(IModel model) {
        AffineTransform c2m;
        double uPerPixel;
        int width = this.getWidth();
        int height = this.getHeight();
        double mx0 = model.getMinX();
        double my0 = model.getMinY();
        double mx1 = model.getMaxX();
        double my1 = model.getMaxY();
        double cAspect = (double)width / (double)height;
        double mAspect = (mx1 - mx0) / (my1 - my0);
        double aspect = cAspect / mAspect;
        double xOffset = 0.0;
        double yOffset = 0.0;
        if (aspect >= 1.0) {
            uPerPixel = (double)height / (my1 - my0);
            double w = uPerPixel * (mx1 - mx0);
            xOffset = ((double)width - w) / 2.0;
        } else {
            uPerPixel = (double)width / (mx1 - mx0);
            double h = uPerPixel * (my1 - my0);
            yOffset = ((double)height - h) / 2.0;
        }
        int pad = this.viewOptions.getPadding();
        AffineTransform m2c = new AffineTransform(uPerPixel, 0.0, 0.0, -uPerPixel, xOffset + (double)pad - uPerPixel * mx0, yOffset + (double)pad + uPerPixel * my1);
        try {
            c2m = m2c.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            return null;
        }
        CompositeImageScale ccs = new CompositeImageScale(width + 2 * pad, height + 2 * pad, m2c, c2m);
        return ccs;
    }

    CompositeImageScale getImageScaleForContinuity() {
        AffineTransform aInv;
        int pad = this.viewOptions.getPadding();
        AffineTransform a = AffineTransform.getTranslateInstance(pad, pad);
        AffineTransform m2c = this.mvComposite.getModel2CompositeTransform();
        a.concatenate(this.c2p);
        a.concatenate(m2c);
        try {
            aInv = a.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            return null;
        }
        return new CompositeImageScale(this.getWidth() + 2 * pad, this.getHeight() + 2 * pad, a, aInv);
    }

    String getFileExtension(File file) {
        String name;
        int i;
        if (file != null && (i = (name = file.getName()).lastIndexOf(46)) > 0 && i < name.length() - 1) {
            return name.substring(i + 1, name.length());
        }
        return null;
    }

    private void raiseShapefileOptions(final File file) {
        ShapefileReader reader;
        JFrame frame = null;
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JFrame)) continue;
            frame = (JFrame)c;
            break;
        }
        if (frame == null) {
            return;
        }
        try {
            reader = new ShapefileReader(file);
        }
        catch (IOException ioex) {
            return;
        }
        final ShapefileOptionsPanel shapefilePanel = new ShapefileOptionsPanel();
        shapefilePanel.applyShapefile(reader);
        try {
            reader.close();
        }
        catch (IOException ioex) {
            return;
        }
        ActionListener okActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String s = shapefilePanel.getMetadataSelection();
                IModel model = DataViewingPanel.this.backplaneManager.loadModel(file, s);
                DataViewingPanel.this.postModelName(model);
                DataViewingPanel.this.repaint();
            }
        };
        shapefilePanel.setOkActionListener(okActionListener);
        JDialog shapefileDialog = new JDialog(frame, "Shapefile Options", false);
        shapefileDialog.setContentPane(shapefilePanel);
        shapefileDialog.setDefaultCloseOperation(1);
        shapefileDialog.pack();
        shapefileDialog.setLocationRelativeTo(frame);
        shapefileDialog.setVisible(true);
    }

    void raiseShapefileOptionsForConstraint(final IModel model, final File file, final CompositeImageScale ccs) {
        ShapefileReader reader;
        JFrame frame = null;
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JFrame)) continue;
            frame = (JFrame)c;
            break;
        }
        if (frame == null) {
            return;
        }
        try {
            reader = new ShapefileReader(file);
        }
        catch (IOException ioex) {
            return;
        }
        final ShapefileOptionsPanel shapefilePanel = new ShapefileOptionsPanel();
        shapefilePanel.applyShapefile(reader);
        try {
            reader.close();
        }
        catch (IOException ioex) {
            return;
        }
        final DataViewingPanel self = this;
        ActionListener okActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String s = shapefilePanel.getMetadataSelection();
                MvComposite mvc = DataViewingPanel.this.backplaneManager.queueConstraintLoadingTask(model, file, ccs, s);
                if (mvc != null) {
                    DataViewingPanel.this.mvComposite = mvc;
                }
                self.repaint();
            }
        };
        shapefilePanel.setOkActionListener(okActionListener);
        JDialog shapefileDialog = new JDialog(frame, "Shapefile Options", false);
        shapefileDialog.setContentPane(shapefilePanel);
        shapefileDialog.setDefaultCloseOperation(1);
        shapefileDialog.pack();
        shapefileDialog.setLocationRelativeTo(frame);
        shapefileDialog.setVisible(true);
    }
}

