/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.tinfour.demo.viewer.DataViewerUI;

public final class TinfourViewerMain {
    private static DataViewerUI dataViewerUI;

    public static void main(String[] args) {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long maxVertices = (long)(0.75 * (double)maxMemory / 124.0);
        System.out.format("Tinfour Viewer launched with max memory %3.1f megabytes.%n", (double)maxMemory / 1048576.0);
        System.out.format("Estimated maximum number of vertices is %d%n", maxVertices);
        System.out.format("depending on whether full-resolution options are used.%n", new Object[0]);
        System.out.flush();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            System.err.println("exception: " + ex);
        }
        catch (InstantiationException ex) {
            System.err.println("exception: " + ex);
        }
        catch (IllegalAccessException ex) {
            System.err.println("exception: " + ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            System.err.println("exception: " + ex);
        }
        dataViewerUI = new DataViewerUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                dataViewerUI.createAndShowGUI();
            }
        });
    }

    private TinfourViewerMain() {
    }
}

