/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.demo.viewer.DataViewingPanel;
import org.tinfour.demo.viewer.StatusPanel;
import org.tinfour.demo.viewer.backplane.BackplaneExecutor;
import org.tinfour.demo.viewer.backplane.CompositeImageScale;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.IModelViewTask;
import org.tinfour.demo.viewer.backplane.LidarPointSelection;
import org.tinfour.demo.viewer.backplane.ModelAdapter;
import org.tinfour.demo.viewer.backplane.ModelFromLas;
import org.tinfour.demo.viewer.backplane.ModelFromShapefile;
import org.tinfour.demo.viewer.backplane.ModelFromText;
import org.tinfour.demo.viewer.backplane.MvComposite;
import org.tinfour.demo.viewer.backplane.MvTaskBuildTinAndRender;
import org.tinfour.demo.viewer.backplane.MvTaskLoad;
import org.tinfour.demo.viewer.backplane.MvTaskLoadConstraints;
import org.tinfour.demo.viewer.backplane.MvTaskQueueRender;
import org.tinfour.demo.viewer.backplane.MvTaskReload;
import org.tinfour.demo.viewer.backplane.RenderProduct;
import org.tinfour.demo.viewer.backplane.ViewOptions;

public class BackplaneManager {
    final BackplaneExecutor renderPool;
    final BackplaneExecutor loaderQueue;
    final DataViewingPanel viewingPanel;
    final StatusPanel statusPanel;
    final AtomicInteger taskIndexSource = new AtomicInteger();
    ViewOptions viewOptions = new ViewOptions();

    public BackplaneManager(DataViewingPanel viewingPanel, StatusPanel statusPanel) {
        this.viewingPanel = viewingPanel;
        this.statusPanel = statusPanel;
        this.renderPool = new BackplaneExecutor(0);
        this.loaderQueue = new BackplaneExecutor(1);
    }

    public void postStatusMessage(int index, String message) {
        this.statusPanel.postMessage(index, message);
    }

    public void postImageUpdate(IModelViewTask task, final RenderProduct product) {
        final int taskIndex = product.composite.getTaskIndex();
        if (task.isCancelled()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BackplaneManager.this.viewingPanel.postImageUpdate(product);
                BackplaneManager.this.statusPanel.clear(taskIndex);
            }
        });
    }

    void cancelAllTasks() {
        this.loaderQueue.cancelAllTasks();
        this.renderPool.cancelAllTasks();
    }

    void cancelRenderingTasks() {
        this.loaderQueue.cancelRenderingTasks();
        this.renderPool.cancelRenderingTasks();
    }

    public void clear() {
        this.cancelAllTasks();
        int taskIndex = this.taskIndexSource.incrementAndGet();
        this.statusPanel.clear(taskIndex);
    }

    public void loadModel(IModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Null model not allowed");
        }
        this.cancelAllTasks();
        int taskIndex = this.taskIndexSource.incrementAndGet();
        String name = model.getName();
        if (model.isLoaded()) {
            this.centerModelInPanelAndRunRender(model, this.getViewOptions(), taskIndex);
        } else {
            this.postStatusMessage(taskIndex, "Loading " + name);
            MvTaskLoad task = new MvTaskLoad(this, model, taskIndex);
            this.loaderQueue.queueTask(task);
        }
    }

    public IModel loadModel(File file, String option) {
        ModelAdapter model;
        this.cancelAllTasks();
        int taskIndex = this.taskIndexSource.incrementAndGet();
        String name = file.getName();
        if (!file.exists() || !file.canRead()) {
            this.postStatusMessage(taskIndex, "File " + name + " does not exist or cannot be read");
            return null;
        }
        String ext = this.extractFileExtension(file);
        ViewOptions view = this.getViewOptions();
        if ("LAZ".equalsIgnoreCase(ext) || "LAS".equalsIgnoreCase(ext)) {
            LidarPointSelection selections = view.getLidarPointSelection();
            model = new ModelFromLas(file, selections);
        } else if ("TXT".equalsIgnoreCase(ext)) {
            model = new ModelFromText(file);
        } else if ("CSV".equalsIgnoreCase(ext)) {
            model = new ModelFromText(file);
        } else if ("SHP".equalsIgnoreCase(ext)) {
            model = new ModelFromShapefile(file, option);
        } else {
            this.postStatusMessage(taskIndex, "Unrecognized file extension " + ext);
            return null;
        }
        this.postStatusMessage(taskIndex, "Loading " + name);
        MvTaskLoad task = new MvTaskLoad(this, model, taskIndex);
        this.loaderQueue.queueTask(task);
        return model;
    }

    public MvComposite queueConstraintLoadingTask(IModel model, File file, CompositeImageScale ccs, String optionString) {
        this.cancelRenderingTasks();
        int width = ccs.getWidth();
        int height = ccs.getHeight();
        AffineTransform m2c = ccs.getModelToCompositeTransform();
        AffineTransform c2m = ccs.getCompositeToModelTransform();
        int taskIndex = this.taskIndexSource.incrementAndGet();
        ViewOptions vOpt = this.getViewOptions();
        MvComposite mvComposite = new MvComposite(model, vOpt, width, height, m2c, c2m, taskIndex);
        String name = file.getName();
        if (!file.exists() || !file.canRead()) {
            this.postStatusMessage(taskIndex, "File " + name + " does not exist or cannot be read");
            return null;
        }
        MvTaskLoadConstraints task = new MvTaskLoadConstraints(this, file, mvComposite, taskIndex, optionString);
        this.loaderQueue.queueTask(task);
        return mvComposite;
    }

    public MvComposite queueReloadTask(IModel model, ViewOptions vOpt, CompositeImageScale ccs) {
        this.cancelRenderingTasks();
        int width = ccs.getWidth();
        int height = ccs.getHeight();
        AffineTransform m2c = ccs.getModelToCompositeTransform();
        AffineTransform c2m = ccs.getCompositeToModelTransform();
        int taskIndex = this.taskIndexSource.incrementAndGet();
        MvComposite mvComposite = new MvComposite(model, vOpt, width, height, m2c, c2m, taskIndex);
        MvTaskReload task = new MvTaskReload(this, mvComposite, taskIndex);
        this.loaderQueue.queueTask(task);
        return mvComposite;
    }

    void postModelLoadCompleted(IModelViewTask task, IModel model, int taskIndex) {
        if (task.isCancelled()) {
            return;
        }
        ViewOptions vOpt = this.getViewOptions();
        this.centerModelInPanelAndRunRender(model, vOpt, taskIndex);
    }

    private void centerModelInPanelAndRunRender(final IModel model, final ViewOptions view, final int taskIndex) {
        final BackplaneManager self = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompositeImageScale imgScale = BackplaneManager.this.viewingPanel.getImageScaleToCenterModelInPanel(model);
                MvComposite mvComposite = new MvComposite(model, view, imgScale.getWidth(), imgScale.getHeight(), imgScale.getModelToCompositeTransform(), imgScale.getCompositeToModelTransform(), taskIndex);
                BackplaneManager.this.viewingPanel.postMvComposite(mvComposite);
                MvTaskBuildTinAndRender renderTask = new MvTaskBuildTinAndRender(self, mvComposite, taskIndex);
                BackplaneManager.this.renderPool.queueTask(renderTask);
            }
        });
    }

    public MvComposite queueHeavyweightRenderTask(IModel model, ViewOptions view, CompositeImageScale ccs) {
        this.cancelRenderingTasks();
        int width = ccs.getWidth();
        int height = ccs.getHeight();
        AffineTransform m2c = ccs.getModelToCompositeTransform();
        AffineTransform c2m = ccs.getCompositeToModelTransform();
        int taskIndex = this.taskIndexSource.incrementAndGet();
        MvComposite mvComposite = new MvComposite(model, view, width, height, m2c, c2m, taskIndex);
        MvTaskQueueRender renderTask = new MvTaskQueueRender(this, mvComposite, taskIndex);
        this.loaderQueue.queueTask(renderTask);
        return mvComposite;
    }

    public MvComposite queueLightweightRenderTask(MvComposite oldComposite, ViewOptions view) {
        this.cancelRenderingTasks();
        int taskIndex = this.taskIndexSource.incrementAndGet();
        MvComposite newComposite = new MvComposite(oldComposite, view, true, taskIndex);
        MvTaskQueueRender renderTask = new MvTaskQueueRender(this, newComposite, taskIndex);
        this.loaderQueue.queueTask(renderTask);
        return newComposite;
    }

    private String extractFileExtension(File file) {
        String path = file.getPath();
        int i = path.lastIndexOf(46);
        if (i <= 0 || i >= path.length() - 1) {
            return null;
        }
        return path.substring(i + 1, path.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewOptions(ViewOptions view) {
        BackplaneManager backplaneManager = this;
        synchronized (backplaneManager) {
            this.viewOptions = view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ViewOptions getViewOptions() {
        BackplaneManager backplaneManager = this;
        synchronized (backplaneManager) {
            return this.viewOptions;
        }
    }

    IMonitorWithCancellation getProgressMonitor(int taskIndex) {
        return this.statusPanel.getProgressMonitor(taskIndex);
    }

    void postModelRefreshCompleted(IModelViewTask task, MvComposite pmvComposite) {
        if (task.isCancelled()) {
            return;
        }
        MvComposite mvComposite = pmvComposite;
        IModel model = mvComposite.getModel();
        if (!model.isLoaded()) {
            System.err.println("load failed");
            return;
        }
        int taskIndex = task.getTaskIndex();
        ViewOptions vOpt = this.getViewOptions();
        if (vOpt != mvComposite.getView()) {
            mvComposite = new MvComposite(mvComposite, vOpt, false, taskIndex);
        }
        MvTaskBuildTinAndRender renderTask = new MvTaskBuildTinAndRender(this, mvComposite, taskIndex);
        this.renderPool.queueTask(renderTask);
    }
}

