/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.common.IPolyline;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.demo.viewer.backplane.BackplaneManager;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.IModelViewTask;
import org.tinfour.demo.viewer.backplane.MvComposite;
import org.tinfour.demo.viewer.backplane.MvTaskBuildRasterBlock;
import org.tinfour.demo.viewer.backplane.RenderProduct;
import org.tinfour.demo.viewer.backplane.RenderProductType;
import org.tinfour.demo.viewer.backplane.ViewOptions;
import org.tinfour.utils.PolylineThinner;
import org.tinfour.utils.TinInstantiationUtility;
import org.tinfour.utils.Tincalc;

class MvTaskBuildTinAndRender
implements IModelViewTask {
    private static final int spaceInPixelsRaster = 2;
    private static final int MAX_VERTICES_FOR_TIN = 50000;
    private final BackplaneManager backplaneManager;
    private final MvComposite composite;
    private final int taskIndex;
    private final IModel model;
    private final ViewOptions view;
    private final int width;
    private final int height;
    private boolean isCancelled;

    MvTaskBuildTinAndRender(BackplaneManager backplaneManager, MvComposite composite, int taskIndex) {
        this.backplaneManager = backplaneManager;
        this.composite = composite;
        this.model = this.composite.getModel();
        this.view = this.composite.getView();
        this.width = this.composite.getWidth();
        this.height = this.composite.getHeight();
        this.taskIndex = taskIndex;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        if (!this.model.isLoaded()) {
            System.err.println("Internal error, rendering when model not loaded");
            return;
        }
        int nVertices = this.model.getVertexCount();
        double mx0 = this.model.getMinX();
        double my0 = this.model.getMinY();
        double mx1 = this.model.getMaxX();
        double my1 = this.model.getMaxY();
        double area = (mx1 - mx0) * (my1 - my0);
        double nominalPointSpacing = Tincalc.sampleSpacing(area, nVertices);
        IIncrementalTin wireframeTin = this.composite.getWireframeTin();
        int reductionForWireframeTin = this.composite.getReductionForWireframe();
        List<IConstraint> constraintsForRender = null;
        if (this.view.isClipOnConstraintsSelected()) {
            this.backplaneManager.postStatusMessage(this.taskIndex, "Preparing clip mask from constraints");
            double pixelSpacing = 50.0;
            double uPerPixel = Math.sqrt(Math.abs(this.composite.c2m.getDeterminant()));
            double uSpacing = pixelSpacing / uPerPixel;
            double areaThreshold = 0.4 * uSpacing * uSpacing;
            List<IConstraint> rawList = this.model.getConstraints();
            ArrayList<PolygonConstraint> polyList = new ArrayList<PolygonConstraint>();
            ArrayList<IPolyline> testList = new ArrayList<IPolyline>(rawList.size());
            for (IConstraint c : rawList) {
                double h;
                Rectangle2D r2dCon;
                double w;
                double diag;
                if (!(c instanceof PolygonConstraint) || !c.isValid() || !((diag = Math.sqrt((w = (r2dCon = c.getBounds()).getWidth() / uPerPixel) * w + (h = r2dCon.getHeight() / uPerPixel) * h)) > pixelSpacing)) continue;
                polyList.add((PolygonConstraint)c);
                testList.add(c);
            }
            ArrayList<IConstraint> clipList = new ArrayList<IConstraint>(rawList.size());
            PolylineThinner thinner = new PolylineThinner();
            for (int iC = 0; iC < testList.size(); ++iC) {
                IPolyline p = (IPolyline)testList.get(iC);
                IPolyline test = thinner.thinPoints(p, testList, areaThreshold);
                if (test == null) {
                    clipList.add((IConstraint)polyList.get(iC));
                    continue;
                }
                testList.set(iC, test);
                if (!test.isValid()) continue;
                clipList.add((PolygonConstraint)test);
            }
            if (!clipList.isEmpty()) {
                this.composite.setConstraintsForRender(clipList);
                this.composite.prepareClipMask();
            }
            this.backplaneManager.postStatusMessage(this.taskIndex, "");
        }
        SelectionResult result = null;
        if (this.view.isWireframeSelected()) {
            if (wireframeTin == null) {
                boolean thinning = this.view.getWireframeSampleThinning() != ViewOptions.SampleThinning.AllSamples;
                result = this.selectVerticesForProcessing(thinning, this.view.getWireframeSampleSpacing(), 50000, true);
                constraintsForRender = result.constraintList;
                this.composite.setConstraintsForRender(constraintsForRender);
                List<Vertex> vList = result.list;
                if (this.isCancelled) {
                    return;
                }
                reductionForWireframeTin = result.reduction;
                int n = vList.size();
                this.backplaneManager.postStatusMessage(this.taskIndex, "Building wireframe TIN from " + n + " vertices");
                TinInstantiationUtility tinOven = new TinInstantiationUtility(0.1, n);
                wireframeTin = tinOven.constructInstance(nominalPointSpacing);
                boolean isBootstrapped = wireframeTin.add(vList, null);
                if (result.constraintList != null) {
                    wireframeTin.addConstraints(result.constraintList, true);
                }
                if (!isBootstrapped) {
                    this.backplaneManager.postStatusMessage(this.taskIndex, "Failed to bootstrap TIN");
                    return;
                }
                if (this.isCancelled) {
                    return;
                }
                this.backplaneManager.postStatusMessage(this.taskIndex, "TIN complete");
                this.composite.submitCandidateTinForInterpolation(wireframeTin, result.reduction);
                this.composite.setWireframeTin(wireframeTin, result.reduction);
            }
            if (this.isCancelled) {
                return;
            }
            this.backplaneManager.postStatusMessage(this.taskIndex, "Rendering wireframe image");
            BufferedImage bImage = this.composite.renderWireframe();
            RenderProduct product = new RenderProduct(RenderProductType.Wireframe, this.composite, bImage);
            this.backplaneManager.postImageUpdate(this, product);
        }
        if (this.isCancelled) {
            return;
        }
        if (this.view.isConstraintRenderingSelected()) {
            this.backplaneManager.postStatusMessage(this.taskIndex, "Rendering constraint image");
            if (constraintsForRender == null) {
                if (result == null) {
                    boolean thinning = this.view.getWireframeSampleThinning() != ViewOptions.SampleThinning.AllSamples;
                    result = this.selectVerticesForProcessing(thinning, this.view.getWireframeSampleSpacing(), 50000, true);
                }
                constraintsForRender = result.constraintList;
                this.composite.setConstraintsForRender(constraintsForRender);
            }
            if (constraintsForRender != null) {
                BufferedImage bImage = this.composite.renderConstraints();
                RenderProduct product = new RenderProduct(RenderProductType.Constraints, this.composite, bImage);
                this.backplaneManager.postImageUpdate(this, product);
                this.backplaneManager.postStatusMessage(this.taskIndex, "");
            }
        }
        if (this.isCancelled) {
            return;
        }
        if (!this.isCancelled && (this.view.isRasterSelected() || this.view.isHillshadeSelected())) {
            this.launchRasterProcessing(nominalPointSpacing, wireframeTin, reductionForWireframeTin);
        }
    }

    void launchRasterProcessing(double nominalPointSpacing, IIncrementalTin wireframeTin, int reductionForWireframeTin) {
        int k;
        int poolSize;
        IIncrementalTin rasterTin;
        int reductionForRasterTin;
        this.composite.startGridBuildTimer();
        IMonitorWithCancellation monitor = this.backplaneManager.getProgressMonitor(this.taskIndex);
        if (reductionForWireframeTin <= 1 && wireframeTin != null) {
            reductionForRasterTin = reductionForWireframeTin;
            rasterTin = wireframeTin;
        } else {
            boolean thinning = !this.view.isFullResolutionGridSelected();
            SelectionResult result = this.selectVerticesForProcessing(thinning, 2.0, 100000, false);
            reductionForRasterTin = result.reduction;
            List<Vertex> vList = result.list;
            int n = vList.size();
            this.backplaneManager.postStatusMessage(this.taskIndex, "Building TIN for raster processing from " + n + " vertices");
            TinInstantiationUtility tinOven = new TinInstantiationUtility(0.1, n);
            rasterTin = tinOven.constructInstance(nominalPointSpacing);
            boolean isBootstrapped = rasterTin.add(vList, monitor);
            if (!isBootstrapped) {
                monitor.reportDone();
                this.backplaneManager.postStatusMessage(this.taskIndex, "Failed build TIN, insufficient data");
                return;
            }
            if (this.isCancelled) {
                return;
            }
            if (result.constraintList != null) {
                rasterTin.addConstraints(result.constraintList, true);
            }
        }
        this.composite.setRasterTin(rasterTin, reductionForRasterTin);
        if (this.isCancelled) {
            return;
        }
        monitor.postMessage("Interpolating surface for raster image");
        monitor.reportProgress(0);
        int nTasks = poolSize = this.backplaneManager.renderPool.getCorePoolSize();
        if (nTasks < 4) {
            nTasks = 4;
        }
        if ((k = this.height / nTasks) == 0) {
            k = this.height;
        }
        int nBlock = (this.height + k - 1) / k;
        AtomicInteger blockCounter = new AtomicInteger(nBlock);
        for (int i = 0; i < nBlock; ++i) {
            int row0 = i * k;
            int row1 = row0 + k;
            if (row1 > this.height) {
                row1 = this.height;
            }
            int nRow = row1 - row0;
            MvTaskBuildRasterBlock blockBuilder = new MvTaskBuildRasterBlock(this.backplaneManager, this.composite, blockCounter, nBlock, row0, nRow, this.taskIndex, monitor);
            this.backplaneManager.renderPool.queueTask(blockBuilder);
        }
    }

    private Vertex getNearbyVertex(double x, double y) {
        IIncrementalTin referenceTin = this.model.getReferenceTin();
        IIncrementalTinNavigator navigator = referenceTin.getNavigator();
        return navigator.getNearestVertex(x, y);
    }

    private SelectionResult selectVerticesForProcessing(boolean thinningSelected, double pixelSpacing, int nVertexLimit, boolean factorOfTwoSteps) {
        Rectangle2D r2dCon;
        AffineTransform c2m = this.composite.c2m;
        int nVertices = this.model.getVertexCount();
        double mx0 = this.model.getMinX();
        double my0 = this.model.getMinY();
        double mx1 = this.model.getMaxX();
        double my1 = this.model.getMaxY();
        double area = (mx1 - mx0) * (my1 - my0);
        double nominalPointSpacing = Tincalc.sampleSpacing(area, nVertices);
        List<IConstraint> constraintList = null;
        if (this.model.hasConstraints()) {
            constraintList = this.model.getConstraints();
        }
        double uPerPixel = Math.sqrt(Math.abs(c2m.getDeterminant()));
        List<Vertex> vList = this.model.getVertexList();
        int reduction = 1;
        if (thinningSelected) {
            double areaInPixels = area / uPerPixel / uPerPixel;
            double s = pixelSpacing;
            double uSpacing = pixelSpacing / uPerPixel;
            double k = areaInPixels / (s * s * 0.866);
            if (k < (double)nVertices * 0.9) {
                double kSkip = (double)nVertices / k;
                int iSkip = (int)kSkip;
                if (factorOfTwoSteps) {
                    int iPow2 = (int)Math.floor(Math.log(kSkip) / Math.log(2.0) + 0.5);
                    iSkip = 1 << iPow2;
                }
                ArrayList<Vertex> thinList = new ArrayList<Vertex>();
                for (int i = 0; i < nVertices; i += iSkip) {
                    thinList.add(vList.get(i));
                }
                thinList.add(vList.get(vList.size() - 1));
                vList = thinList;
                reduction = iSkip;
                if (constraintList != null) {
                    double areaThreshold = 0.4 * uSpacing * uSpacing;
                    ArrayList<IPolyline> thinConList = new ArrayList<IPolyline>(constraintList.size());
                    for (IConstraint con : constraintList) {
                        double h;
                        r2dCon = con.getBounds();
                        double w = r2dCon.getWidth() / uPerPixel;
                        double diag = Math.sqrt(w * w + (h = r2dCon.getHeight() / uPerPixel) * h);
                        if (!(diag > pixelSpacing)) continue;
                        thinConList.add(con);
                    }
                    PolylineThinner pThinner = new PolylineThinner();
                    constraintList = new ArrayList<IConstraint>(thinConList.size());
                    for (int iP = 0; iP < thinConList.size(); ++iP) {
                        IPolyline p = (IPolyline)thinConList.get(iP);
                        IPolyline test = pThinner.thinPoints(p, thinConList, areaThreshold);
                        if (test == null) {
                            constraintList.add((IConstraint)p);
                            continue;
                        }
                        p = test;
                        if (!p.isValid()) continue;
                        thinConList.set(iP, p);
                        constraintList.add((IConstraint)p);
                    }
                }
            }
        }
        if (vList.size() > nVertexLimit) {
            double[] c = new double[8];
            c[0] = -0.25 * (double)this.width;
            c[1] = 1.5 * (double)this.height;
            c[2] = 1.5 * (double)this.width;
            c[3] = -0.25 * (double)this.height;
            c2m.transform(c, 0, c, 4, 2);
            Rectangle2D.Double r2d = new Rectangle2D.Double(c[4], c[5], c[6] - c[4], c[7] - c[5]);
            c[0] = (double)this.width / 2.0;
            c[1] = (double)this.height / 2.0;
            c2m.transform(c, 0, c, 2, 1);
            Vertex nV = this.getNearbyVertex(c[2], c[3]);
            double s = Math.sqrt(nVertexLimit) * nominalPointSpacing;
            r2d.add(nV.getX() - s / 2.0, nV.getY() - s / 2.0);
            r2d.add(nV.getX() + s / 2.0, nV.getY() + s / 2.0);
            double x0 = r2d.getMinX();
            double x1 = r2d.getMaxX();
            double y0 = r2d.getMinY();
            double y1 = r2d.getMaxY();
            ArrayList<Vertex> clipList = new ArrayList<Vertex>();
            for (Vertex v : vList) {
                double x = v.getX();
                double y = v.getY();
                if (!(x0 < x) || !(x < x1) || !(y0 < y) || !(y < y1)) continue;
                clipList.add(v);
            }
            vList = clipList;
            if (constraintList != null) {
                ArrayList<IConstraint> clipCon = new ArrayList<IConstraint>(constraintList.size());
                for (IConstraint con : constraintList) {
                    r2dCon = con.getBounds();
                    if (!r2dCon.intersects(r2d)) continue;
                    clipCon.add(con);
                }
                constraintList = clipCon;
            }
        }
        if (vList.size() < this.model.getVertexCount()) {
            List<Vertex> pList = this.model.getPerimeterVertices();
            vList.addAll(pList);
        }
        return new SelectionResult(reduction, vList, constraintList);
    }

    @Override
    public int getTaskIndex() {
        return this.taskIndex;
    }

    @Override
    public boolean isRenderingTask() {
        return true;
    }

    private class SelectionResult {
        final int reduction;
        final List<Vertex> list;
        final List<IConstraint> constraintList;

        SelectionResult(int reduction, List<Vertex> list, List<IConstraint> constraintList) {
            this.reduction = reduction;
            this.list = list;
            this.constraintList = constraintList;
        }

        public String toString() {
            return "SelectionResult " + this.list.size() + " vertices, " + this.reduction + ":1 reduction";
        }
    }
}

