/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.demo.utils.cdt.ConstraintLoader;
import org.tinfour.demo.viewer.backplane.BackplaneManager;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.IModelViewTask;
import org.tinfour.demo.viewer.backplane.MvComposite;
import org.tinfour.gis.utils.ConstraintReaderShapefile;

class MvTaskLoadConstraints
implements IModelViewTask {
    private final BackplaneManager backplaneManager;
    private final MvComposite mvComposite;
    private final File constraintsFile;
    private final int taskIndex;
    private boolean isCancelled;
    private final String optionString;

    MvTaskLoadConstraints(BackplaneManager backplaneManager, File file, MvComposite mvComposite, int taskIndex, String optionString) {
        this.mvComposite = mvComposite;
        this.constraintsFile = file;
        this.taskIndex = taskIndex;
        this.backplaneManager = backplaneManager;
        this.optionString = optionString;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        IModel model = this.mvComposite.getModel();
        try {
            IMonitorWithCancellation monitor = this.backplaneManager.getProgressMonitor(this.taskIndex);
            monitor.postMessage("Loading constraints from " + this.constraintsFile.getName());
            List<IConstraint> constraints = null;
            if ("shp".equalsIgnoreCase(this.getFileExtension(this.constraintsFile))) {
                ConstraintReaderShapefile reader = new ConstraintReaderShapefile(this.constraintsFile);
                if (this.optionString != null) {
                    reader.setDbfFieldForZ(this.optionString);
                }
                reader.setCoordinateTransform(model.getCoordinateTransform());
                constraints = reader.read();
            } else {
                ConstraintLoader loader = new ConstraintLoader();
                loader.setCoordinateTransform(model.getCoordinateTransform());
                constraints = loader.readConstraintsFile(this.constraintsFile);
            }
            model.addConstraints(this.constraintsFile, constraints);
            monitor.reportDone();
            this.backplaneManager.postModelRefreshCompleted(this, this.mvComposite);
        }
        catch (IOException ioex) {
            String message = "Error loading " + model.getName() + " " + ioex.getMessage();
            System.err.println(message);
            this.backplaneManager.postStatusMessage(this.taskIndex, message);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    @Override
    public int getTaskIndex() {
        return this.taskIndex;
    }

    @Override
    public boolean isRenderingTask() {
        return false;
    }

    String getFileExtension(File file) {
        String name;
        int i;
        if (file != null && (i = (name = file.getName()).lastIndexOf(46)) > 0 && i < name.length() - 1) {
            return name.substring(i + 1, name.length());
        }
        return null;
    }
}

