/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.ModelSerialSource;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.utils.LinearUnits;
import org.tinfour.utils.Tincalc;
import org.tinfour.utils.loaders.ICoordinateTransform;

public class UnitSquareModel
implements IModel {
    List<Vertex> vList;
    IIncrementalTin referenceTin;
    List<Vertex> perimeterList;
    final int serialIndex = ModelSerialSource.getSerialIndex();

    public UnitSquareModel(int count) {
        this.vList = new ArrayList<Vertex>();
        this.vList.add(new Vertex(0.0, 0.0, 0.0, 1));
        this.vList.add(new Vertex(1.0, 0.0, 1.0, 2));
        this.vList.add(new Vertex(1.0, 1.0, 1.0, 3));
        this.vList.add(new Vertex(0.0, 1.0, 1.0, 4));
        Random random = new Random(0L);
        for (int i = 5; i <= count; ++i) {
            double x = random.nextDouble();
            double y = random.nextDouble();
            double z = x * x + y * y;
            this.vList.add(new Vertex(x, y, z, i));
        }
        this.referenceTin = new IncrementalTin(1.0);
        this.referenceTin.add(this.vList, null);
        List<IQuadEdge> pList = this.referenceTin.getPerimeter();
        this.perimeterList = new ArrayList<Vertex>();
        for (IQuadEdge e : pList) {
            Vertex a = e.getA();
            double x = a.getX();
            double y = a.getY();
            double z = a.getZ();
            this.perimeterList.add(new Vertex(x, y, z, -1));
        }
    }

    @Override
    public int getVertexCount() {
        return this.vList.size();
    }

    @Override
    public double getMaxX() {
        return 1.0;
    }

    @Override
    public double getMinX() {
        return 0.0;
    }

    @Override
    public double getMaxY() {
        return 1.0;
    }

    @Override
    public double getMinY() {
        return 0.0;
    }

    @Override
    public double getMaxZ() {
        return 1.0;
    }

    @Override
    public double getMinZ() {
        return 0.0;
    }

    @Override
    public double getArea() {
        return 1.0;
    }

    @Override
    public double getNominalPointSpacing() {
        return Tincalc.sampleSpacing(1.0, this.vList.size());
    }

    @Override
    public void load(IMonitorWithCancellation monitor) throws IOException {
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return "Unit Square";
    }

    @Override
    public String getDescription() {
        return "Randomly created vertices";
    }

    @Override
    public List<Vertex> getVertexList() {
        return this.vList;
    }

    @Override
    public String getFormattedCoordinates(double x, double y) {
        return String.format("%6.3f, %6.3f", x, y);
    }

    @Override
    public String getFormattedX(double x) {
        return String.format("%11.2f", x);
    }

    @Override
    public String getFormattedY(double y) {
        return String.format("%11.2f", y);
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public IIncrementalTin getReferenceTin() {
        return this.referenceTin;
    }

    @Override
    public double getReferenceReductionFactor() {
        return 1.0;
    }

    @Override
    public long getTimeToLoadInMillis() {
        return 0L;
    }

    @Override
    public long getTimeToSortInMillis() {
        return 0L;
    }

    @Override
    public List<Vertex> getPerimeterVertices() {
        return this.perimeterList;
    }

    @Override
    public LinearUnits getLinearUnits() {
        return LinearUnits.UNKNOWN;
    }

    @Override
    public boolean isCoordinateSystemGeographic() {
        return false;
    }

    @Override
    public Vertex getVertexForIndex(int index) {
        Vertex key = new Vertex(0.0, 0.0, 0.0, index);
        int i = Collections.binarySearch(this.vList, key, new Comparator<Vertex>(){

            @Override
            public int compare(Vertex t, Vertex t1) {
                return t.getIndex() - t1.getIndex();
            }
        });
        if (i >= 0) {
            return this.vList.get(i);
        }
        return null;
    }

    @Override
    public void xy2geo(double x, double y, double[] geo) {
    }

    @Override
    public void geo2xy(double latitude, double longitude, double[] xy) {
    }

    @Override
    public boolean hasConstraints() {
        return false;
    }

    @Override
    public List<IConstraint> getConstraints() {
        return new ArrayList<IConstraint>();
    }

    @Override
    public boolean hasVertexSource() {
        return true;
    }

    @Override
    public boolean areVerticesLoaded() {
        return true;
    }

    @Override
    public boolean hasConstraintsSource() {
        return false;
    }

    @Override
    public boolean areConstraintsLoaded() {
        return false;
    }

    @Override
    public void addConstraints(File constraintsFile, List<IConstraint> constraints) {
    }

    @Override
    public ICoordinateTransform getCoordinateTransform() {
        return null;
    }
}

