/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.las;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.ShortBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.tinfour.gis.las.GeoTiffData;
import org.tinfour.gis.las.GeoTiffKey;
import org.tinfour.gis.las.LasGpsTimeType;
import org.tinfour.gis.las.LasPoint;
import org.tinfour.gis.las.LasScaleAndOffset;
import org.tinfour.gis.las.LasVariableLengthRecord;
import org.tinfour.io.BufferedRandomAccessReader;
import org.tinfour.utils.LinearUnits;

public class LasFileReader {
    private static final int BIT4 = 16;
    private static final int BIT1 = 1;
    private String fileSignature;
    int fileSourceID;
    int globalEncoding;
    int versionMajor;
    int versionMinor;
    String systemIdentifier;
    String generatingSoftware;
    int fileCreationDayOfYear;
    int fileCreationYear;
    Date fileCreationDate;
    int headerSize;
    long offsetToPointData;
    long numberVariableLengthRecords;
    int pointDataRecordFormat;
    int pointDataRecordLength;
    long legacyNumberOfPointRecords;
    long[] legacyNumberOfPointsByReturn;
    double xScaleFactor;
    double yScaleFactor;
    double zScaleFactor;
    double xOffset;
    double yOffset;
    double zOffset;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minZ;
    private double maxZ;
    private long startOfWaveformDataPacket;
    private long startOfWaveformDataPacketRec;
    private long startOfExtendedVarLenRec;
    private long numberExtendedVarLenRec;
    private long numberOfPointRecords;
    private long[] numberOfPointsByReturn;
    private CoordinateReferenceSystemOption crsOption;
    private LasGpsTimeType lasGpsTimeType;
    private LinearUnits lasLinearUnits = LinearUnits.UNKNOWN;
    private boolean isGeographicModelTypeKnown;
    private boolean usesGeographicModel;
    private GeoTiffData gtData;
    private final BufferedRandomAccessReader braf;
    private boolean isClosed;
    private final List<LasVariableLengthRecord> vlrList;
    private final File path;

    public LasFileReader(File path) throws IOException {
        this.path = path;
        this.braf = new BufferedRandomAccessReader(path);
        this.vlrList = new ArrayList<LasVariableLengthRecord>();
        this.readHeader();
    }

    public File getFile() {
        return this.path;
    }

    private void readHeader() throws IOException {
        int i;
        this.fileSignature = this.braf.readAscii(4);
        if (!"LASF".equals(this.fileSignature)) {
            throw new IOException("File is not in recognizable LAS format");
        }
        this.fileSourceID = this.braf.readUnsignedShort();
        this.globalEncoding = this.braf.readUnsignedShort();
        this.braf.skipBytes(16);
        this.versionMajor = this.braf.readUnsignedByte();
        this.versionMinor = this.braf.readUnsignedByte();
        this.systemIdentifier = this.braf.readAscii(32);
        this.generatingSoftware = this.braf.readAscii(32);
        this.fileCreationDayOfYear = this.braf.readUnsignedShort();
        this.fileCreationYear = this.braf.readUnsignedShort();
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, this.fileCreationYear);
        cal.set(6, this.fileCreationDayOfYear);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        this.fileCreationDate = cal.getTime();
        this.headerSize = this.braf.readUnsignedShort();
        this.offsetToPointData = this.braf.readUnsignedInt();
        this.numberVariableLengthRecords = this.braf.readUnsignedInt();
        this.pointDataRecordFormat = this.braf.readUnsignedByte();
        this.pointDataRecordLength = this.braf.readUnsignedShort();
        this.legacyNumberOfPointRecords = this.braf.readUnsignedInt();
        this.legacyNumberOfPointsByReturn = new long[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            this.legacyNumberOfPointsByReturn[i2] = this.braf.readUnsignedInt();
        }
        this.xScaleFactor = this.braf.readDouble();
        this.yScaleFactor = this.braf.readDouble();
        this.zScaleFactor = this.braf.readDouble();
        this.xOffset = this.braf.readDouble();
        this.yOffset = this.braf.readDouble();
        this.zOffset = this.braf.readDouble();
        this.maxX = this.braf.readDouble();
        this.minX = this.braf.readDouble();
        this.maxY = this.braf.readDouble();
        this.minY = this.braf.readDouble();
        this.maxZ = this.braf.readDouble();
        this.minZ = this.braf.readDouble();
        long pos = this.braf.getFilePosition();
        if ((long)this.headerSize <= pos) {
            this.numberOfPointRecords = this.legacyNumberOfPointRecords;
            this.numberOfPointsByReturn = new long[15];
            System.arraycopy(this.numberOfPointsByReturn, 0, this.legacyNumberOfPointsByReturn, 0, 5);
        } else {
            this.startOfWaveformDataPacketRec = this.braf.readLong();
            this.startOfExtendedVarLenRec = this.braf.readLong();
            this.numberExtendedVarLenRec = this.braf.readUnsignedInt();
            this.numberOfPointRecords = this.braf.readLong();
            this.numberOfPointsByReturn = new long[15];
            for (i = 0; i < 15; ++i) {
                this.numberOfPointsByReturn[i] = this.braf.readLong();
            }
        }
        this.crsOption = (this.globalEncoding & 0x10) == 0 ? CoordinateReferenceSystemOption.GeoTIFF : CoordinateReferenceSystemOption.WKT;
        this.lasGpsTimeType = (this.globalEncoding & 1) == 0 ? LasGpsTimeType.WeekTime : LasGpsTimeType.SatelliteTime;
        i = 0;
        while ((long)i < this.numberVariableLengthRecords) {
            LasVariableLengthRecord vlrHeader = this.readVlrHeader();
            this.braf.skipBytes(vlrHeader.recordLength);
            this.vlrList.add(vlrHeader);
            ++i;
        }
        if (this.crsOption == CoordinateReferenceSystemOption.GeoTIFF) {
            this.loadGeoTiffSpecification();
        }
    }

    private LasVariableLengthRecord readVlrHeader() throws IOException {
        this.braf.skipBytes(2);
        String userID = this.braf.readAscii(16);
        int recordID = this.braf.readUnsignedShort();
        int recordLength = this.braf.readUnsignedShort();
        String description = this.braf.readAscii(32);
        long offset = this.braf.getFilePosition();
        return new LasVariableLengthRecord(offset, userID, recordID, recordLength, description);
    }

    public void readRecord(long recordIndex, LasPoint p) throws IOException {
        if (recordIndex < 0L || recordIndex >= this.numberOfPointRecords) {
            throw new IOException("Record index " + recordIndex + " out of bounds [" + 0 + ".." + this.numberOfPointRecords + "]");
        }
        if (this.isClosed) {
            throw new IOException("File is closed");
        }
        long filePos = this.offsetToPointData + recordIndex * (long)this.pointDataRecordLength;
        this.braf.seek(filePos);
        int lx = this.braf.readInt();
        int ly = this.braf.readInt();
        int lz = this.braf.readInt();
        p.x = (double)lx * this.xScaleFactor + this.xOffset;
        p.y = (double)ly * this.yScaleFactor + this.yOffset;
        p.z = (double)lz * this.zScaleFactor + this.zOffset;
        p.intensity = this.braf.readUnsignedShort();
        int mask = this.braf.readUnsignedByte();
        p.returnNumber = mask & 7;
        p.numberOfReturns = mask >> 3 & 7;
        p.scanDirectionFlag = mask >> 5 & 1;
        p.edgeOfFlightLine = (mask & 0x80) != 0;
        mask = this.braf.readUnsignedByte();
        p.classification = mask & 0x1F;
        p.synthetic = (mask & 0x20) != 0;
        p.keypoint = (mask & 0x40) != 0;
        p.withheld = (mask & 0x80) != 0;
        this.braf.skipBytes(4);
        if (this.pointDataRecordFormat == 1 || this.pointDataRecordFormat == 3) {
            p.gpsTime = this.braf.readDouble();
        }
    }

    public int getPointDataRecordFormat() {
        return this.pointDataRecordFormat;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy", Locale.US);
        String yearString = sdf.format(this.fileCreationDate);
        return String.format("LAS vers %d.%d, created %s, nrecs %d", this.versionMajor, this.versionMinor, yearString, this.legacyNumberOfPointRecords);
    }

    public long getNumberOfPointRecords() {
        return this.numberOfPointRecords;
    }

    public void close() throws IOException {
        this.braf.close();
    }

    public String getFileSignature() {
        return this.fileSignature;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public CoordinateReferenceSystemOption getCoordinateReferenceSystemOption() {
        return this.crsOption;
    }

    public List<LasVariableLengthRecord> getVariableLengthRecordList() {
        ArrayList<LasVariableLengthRecord> list = new ArrayList<LasVariableLengthRecord>();
        list.addAll(this.vlrList);
        return list;
    }

    public LasVariableLengthRecord getVariableLengthRecordByRecordId(int recordId) {
        for (LasVariableLengthRecord vlr : this.vlrList) {
            if (vlr.getRecordId() != recordId) continue;
            return vlr;
        }
        return null;
    }

    public byte[] readVariableLengthRecordBytes(LasVariableLengthRecord vlr) throws IOException {
        long filePos = vlr.getFilePosition();
        this.braf.seek(filePos);
        byte[] b = new byte[vlr.getRecordLength()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.braf.readByte();
        }
        return b;
    }

    public int[] readVariableLengthRecordUnsignedShorts(LasVariableLengthRecord vlr) throws IOException {
        byte[] b = this.readVariableLengthRecordBytes(vlr);
        ByteBuffer bBuff = ByteBuffer.wrap(b);
        bBuff.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer sBuff = bBuff.asShortBuffer();
        int n = b.length / 2;
        int[] output = new int[n];
        for (int i = 0; i < n; ++i) {
            output[i] = sBuff.get() & 0xFFFF;
        }
        return output;
    }

    public double[] readVariableLengthRecordDoubles(LasVariableLengthRecord vlr) throws IOException {
        byte[] b = this.readVariableLengthRecordBytes(vlr);
        ByteBuffer bBuff = ByteBuffer.wrap(b);
        bBuff.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer fBuff = bBuff.asDoubleBuffer();
        int n = b.length / 8;
        double[] output = new double[n];
        for (int i = 0; i < n; ++i) {
            output[i] = fBuff.get();
        }
        return output;
    }

    private boolean inLonRange(double x) {
        return -180.0 <= x && x <= 360.0;
    }

    private boolean inLatRange(double y) {
        return -90.0 <= y && y <= 90.0;
    }

    public boolean usesGeographicCoordinates() {
        if (this.isGeographicModelTypeKnown) {
            return this.usesGeographicModel;
        }
        if (this.inLonRange(this.minX) && this.inLonRange(this.maxX)) {
            if (this.maxX - this.minX > 10.0) {
                return false;
            }
            if (this.inLatRange(this.minY) && this.inLatRange(this.maxY)) {
                return this.maxY - this.minY <= 10.0;
            }
        }
        return false;
    }

    public LasGpsTimeType getLasGpsTimeType() {
        return this.lasGpsTimeType;
    }

    private void loadGeoTiffSpecification() throws IOException {
        int i;
        LasVariableLengthRecord vlr = this.getVariableLengthRecordByRecordId(34735);
        if (vlr == null) {
            return;
        }
        this.braf.seek(vlr.getFilePosition() + 6L);
        int nR = this.braf.readUnsignedShort();
        ArrayList<GeoTiffKey> keyList = new ArrayList<GeoTiffKey>();
        for (int i2 = 0; i2 < nR; ++i2) {
            int keyCode = this.braf.readUnsignedShort();
            int location = this.braf.readUnsignedShort();
            int count = this.braf.readUnsignedShort();
            int valueOrOffset = this.braf.readUnsignedShort();
            GeoTiffKey key = new GeoTiffKey(keyCode, location, count, valueOrOffset);
            keyList.add(key);
        }
        vlr = this.getVariableLengthRecordByRecordId(34736);
        double[] doubleData = null;
        if (vlr != null) {
            this.braf.seek(vlr.getFilePosition());
            int nD = vlr.recordLength / 8;
            doubleData = new double[nD];
            for (i = 0; i < nD; ++i) {
                doubleData[i] = this.braf.readDouble();
            }
        }
        vlr = this.getVariableLengthRecordByRecordId(34737);
        char[] asciiData = null;
        if (vlr != null) {
            this.braf.seek(vlr.getFilePosition());
            asciiData = new char[vlr.recordLength];
            for (i = 0; i < vlr.recordLength; ++i) {
                asciiData[i] = (char)this.braf.readUnsignedByte();
            }
        }
        this.gtData = new GeoTiffData(keyList, doubleData, asciiData);
        int gtModelType = this.gtData.getInteger(1024);
        if (gtModelType == 1) {
            this.isGeographicModelTypeKnown = true;
            this.usesGeographicModel = false;
        } else if (gtModelType == 2) {
            this.isGeographicModelTypeKnown = true;
            this.usesGeographicModel = true;
        }
        int unitsCode = -1;
        if (this.gtData.containsKey(4099)) {
            unitsCode = this.gtData.getInteger(4099);
        } else if (this.gtData.containsKey(3076)) {
            unitsCode = this.gtData.getInteger(3076);
        }
        if (unitsCode == 9001) {
            this.lasLinearUnits = LinearUnits.METERS;
        } else if (9002 <= unitsCode && unitsCode <= 9006) {
            this.lasLinearUnits = LinearUnits.FEET;
        } else if (unitsCode == 9014) {
            this.lasLinearUnits = LinearUnits.FATHOMS;
        }
    }

    public GeoTiffData getGeoTiffData() {
        return this.gtData;
    }

    public LinearUnits getLinearUnits() {
        return this.lasLinearUnits;
    }

    public LasScaleAndOffset getScaleAndOffset() {
        return new LasScaleAndOffset(this.xScaleFactor, this.yScaleFactor, this.zScaleFactor, this.xOffset, this.yOffset, this.zOffset);
    }

    public static enum CoordinateReferenceSystemOption {
        GeoTIFF,
        WKT;

    }
}

