/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.gis.shapefile.DbfFileReader;
import org.tinfour.io.BufferedRandomAccessFile;
import org.tinfour.io.BufferedRandomAccessReader;

public class DbfFieldDate
extends DbfField {
    private ZonedDateTime value;
    private ZoneOffset zoneOffset = ZoneOffset.UTC;

    DbfFieldDate(String name, char fieldType, int dataAddress, int fieldLength, int fieldDecimalCount, int offset) {
        super(name, fieldType, dataAddress, fieldLength, fieldDecimalCount, offset);
    }

    private int scan1(int b, StringBuilder sb) throws IOException {
        sb.append((char)b);
        if (b < 48 || b > 57) {
            if (Character.isWhitespace((char)b)) {
                return 0;
            }
            throw new IOException("Invalid character (" + b + ") where numeric expected in date field");
        }
        return b - 48;
    }

    @Override
    void read(BufferedRandomAccessReader brad, long recordFilePos) throws IOException {
        brad.seek(recordFilePos + (long)this.offset);
        this.builder.setLength(0);
        int y0 = this.scan1(brad.readUnsignedByte(), this.builder);
        int y1 = this.scan1(brad.readUnsignedByte(), this.builder);
        int y2 = this.scan1(brad.readUnsignedByte(), this.builder);
        int y3 = this.scan1(brad.readUnsignedByte(), this.builder);
        int year = ((y0 * 10 + y1) * 10 + y2) * 10 + y3;
        int m1 = this.scan1(brad.readUnsignedByte(), this.builder);
        int m2 = this.scan1(brad.readUnsignedByte(), this.builder);
        int month = m1 * 10 + m2;
        int d1 = this.scan1(brad.readUnsignedByte(), this.builder);
        int d2 = this.scan1(brad.readUnsignedByte(), this.builder);
        int day = d1 * 10 + d2;
        this.value = year == 0 || month == 0 || day == 0 ? null : ZonedDateTime.of(year, month, day, 0, 0, 0, 0, this.zoneOffset);
    }

    @Override
    void write(BufferedRandomAccessFile braf) throws IOException {
        int year = this.value.getYear();
        int month = this.value.getMonthValue();
        int day = this.value.getDayOfMonth();
        String s = String.format("%4d%02d%02d", year, month, day);
        byte[] b = s.getBytes();
        braf.write(b, 0, 8);
    }

    @Override
    public double getDouble() {
        if (this.value == null) {
            return Double.NaN;
        }
        return (double)this.value.toEpochSecond() * 1000.0;
    }

    @Override
    public int getInteger() {
        if (this.value == null) {
            return 0;
        }
        return (int)this.value.toEpochSecond();
    }

    public long getLong() {
        if (this.value == null) {
            return 0L;
        }
        return this.value.toEpochSecond() * 1000L;
    }

    @Override
    public Object getApplicationData() {
        return this.value;
    }

    public ZonedDateTime getValue() {
        return this.value;
    }

    public void setValue(ZonedDateTime dateTime) {
        this.value = dateTime;
    }

    public ZonedDateTime[] getUniqueValueArray(DbfFileReader dbf) throws IOException {
        long vMin = Long.MAX_VALUE;
        long vMax = Long.MIN_VALUE;
        int nRecords = dbf.getRecordCount();
        if (nRecords == 0) {
            return new ZonedDateTime[0];
        }
        long[] vArray = new long[nRecords];
        int k = 0;
        for (int i = 1; i <= nRecords; ++i) {
            dbf.readField(i, this);
            if (this.isNull()) continue;
            long v = this.getLong();
            if (v < vMin) {
                vMin = v;
            }
            if (v > vMax) {
                vMax = v;
            }
            vArray[k++] = v;
        }
        Arrays.sort(vArray, 0, k);
        int nUniqueValues = 1;
        long prior = vArray[0];
        for (int i = 1; i < k; ++i) {
            if (vArray[i] == prior) continue;
            prior = vArray[i];
            vArray[nUniqueValues] = vArray[i];
            ++nUniqueValues;
        }
        ZonedDateTime[] ldtArray = new ZonedDateTime[nUniqueValues];
        for (int i = 0; i < nUniqueValues; ++i) {
            Instant instant = Instant.ofEpochMilli(vArray[i]);
            ldtArray[i] = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        return ldtArray;
    }

    public void setZoneOffset(ZoneOffset zoneOffset) {
        if (zoneOffset == null) {
            throw new NullPointerException("Null zone-offset value not supported");
        }
        this.zoneOffset = zoneOffset;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }
}

