/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

import java.io.IOException;
import java.util.Arrays;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.gis.shapefile.DbfFileReader;
import org.tinfour.io.BufferedRandomAccessFile;
import org.tinfour.io.BufferedRandomAccessReader;

public class DbfFieldInt
extends DbfField {
    private int value;
    private String writingFormat;

    DbfFieldInt(String name, char fieldType, int dataAddress, int fieldLength, int fieldDecimalCount, int offset) {
        super(name, fieldType, dataAddress, fieldLength, fieldDecimalCount, offset);
        this.writingFormat = String.format("%%%dd", fieldLength);
    }

    @Override
    void read(BufferedRandomAccessReader brad, long recordFilePos) throws IOException {
        int b;
        int i;
        brad.seek(recordFilePos + (long)this.offset);
        this.builder.setLength(0);
        int sign = 1;
        long s = 0L;
        boolean foundDigit = false;
        for (i = 0; i < this.fieldLength; ++i) {
            b = brad.readUnsignedByte();
            this.builder.append((char)b);
            if (b == 32) {
                continue;
            }
            if (b == 45) {
                sign = -1;
                ++i;
                break;
            }
            if (b == 43) {
                ++i;
                break;
            }
            if (48 <= b && b <= 57) {
                s = b - 48;
                ++i;
                foundDigit = true;
                break;
            }
            this.value = 0;
            throw new IOException("Invalid integer value, unknown character " + (char)b);
        }
        if (!foundDigit) {
            throw new IOException("Invalid integer value, blank field");
        }
        while (i < this.fieldLength) {
            b = brad.readUnsignedByte();
            this.builder.append((char)b);
            if (48 > b || b > 57) {
                if (s == 32L) break;
                this.value = 0;
                throw new IOException("Invalid integer value, unknown character " + (char)b);
            }
            s = s * 10L + (long)(b - 48);
            ++i;
        }
        if ((s *= (long)sign) > Integer.MAX_VALUE) {
            this.value = Integer.MAX_VALUE;
            throw new IOException("Invalid integer value out of range " + s);
        }
        if (s < Integer.MIN_VALUE) {
            this.value = Integer.MIN_VALUE;
            throw new IOException("Invalid integer value out of range " + s);
        }
        this.value = (int)s;
    }

    @Override
    void write(BufferedRandomAccessFile braf) throws IOException {
        String s = String.format(this.writingFormat, this.value);
        byte[] b = s.getBytes();
        braf.write(b, 0, this.fieldLength);
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int getInteger() {
        return this.value;
    }

    public void setDouble(double value) {
        this.value = (int)value;
    }

    public void setInteger(int value) {
        this.value = value;
    }

    @Override
    public Object getApplicationData() {
        return this.value;
    }

    public int[] getUniqueValueArray(DbfFileReader dbf) throws IOException {
        int vMin = Integer.MAX_VALUE;
        int vMax = Integer.MIN_VALUE;
        int nRecords = dbf.getRecordCount();
        int[] vArray = new int[nRecords];
        if (nRecords == 0) {
            return new int[0];
        }
        int k = 0;
        for (int i = 1; i <= nRecords; ++i) {
            dbf.readField(i, this);
            int v = this.getInteger();
            if (v < vMin) {
                vMin = v;
            }
            if (v > vMax) {
                vMax = v;
            }
            vArray[k++] = v;
        }
        Arrays.sort(vArray);
        int nUniqueValues = 1;
        int prior = vArray[0];
        for (int i = 1; i < nRecords; ++i) {
            if (vArray[i] == prior) continue;
            prior = vArray[i];
            vArray[nUniqueValues] = vArray[i];
            ++nUniqueValues;
        }
        return Arrays.copyOf(vArray, nUniqueValues);
    }
}

