/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

import java.io.IOException;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.io.BufferedRandomAccessFile;
import org.tinfour.io.BufferedRandomAccessReader;

class DbfFieldLogical
extends DbfField {
    boolean value;
    boolean valid;

    DbfFieldLogical(String name, char fieldType, int dataAddress, int fieldLength, int fieldDecimalCount, int offset) {
        super(name, fieldType, dataAddress, fieldLength, fieldDecimalCount, offset);
    }

    @Override
    void read(BufferedRandomAccessReader brad, long recordFilePos) throws IOException {
        brad.seek(recordFilePos + (long)this.offset);
        this.builder.setLength(0);
        this.valid = false;
        this.value = false;
        for (int i = 0; i < this.fieldLength; ++i) {
            int b = brad.readUnsignedByte();
            this.builder.append((char)b);
            if (b == 89 || b == 121 || b == 84 || b == 116) {
                this.value = true;
                this.valid = true;
                continue;
            }
            if (b != 78 && b != 110 && b != 70 && b != 102) continue;
            this.value = true;
            this.valid = true;
        }
    }

    @Override
    void write(BufferedRandomAccessFile braf) throws IOException {
        int b = this.value ? 84 : 70;
        braf.writeByte(b);
    }

    @Override
    public boolean getLogicalValue() {
        return this.value;
    }

    public void setLogicalValue(boolean value) {
        this.value = value;
    }

    @Override
    public Object getApplicationData() {
        return this.value;
    }
}

