/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.gis.shapefile.DbfFieldDouble;
import org.tinfour.gis.shapefile.DbfFieldInt;
import org.tinfour.io.BufferedRandomAccessFile;

public class DbfFileWriter
implements Closeable {
    private static final int N_BYTES_IN_FIELD_DEF = 32;
    final File outputFile;
    final BufferedRandomAccessFile braf;
    private int nRecords;
    private final List<DbfField> fields;

    public DbfFileWriter(File outputFile, List<DbfField> fields) throws IOException {
        int fPos;
        if (fields.isEmpty()) {
            throw new IllegalArgumentException("Empty fields specification not allowed");
        }
        this.fields = fields;
        this.outputFile = outputFile;
        this.braf = new BufferedRandomAccessFile(outputFile, "rw");
        this.braf.writeByte(3);
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1) - 1900;
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        this.braf.writeByte(year);
        this.braf.writeByte(month);
        this.braf.writeByte(day);
        this.braf.leWriteInt(0);
        int nBytesInHeader = fields.size() * 32 + 32 + 1;
        this.braf.leWriteShort((short)nBytesInHeader);
        int nBytesInRecord = 1;
        for (DbfField f : fields) {
            nBytesInRecord += f.getFieldLength();
        }
        this.braf.leWriteShort((short)nBytesInRecord);
        for (int i = fPos = (int)this.braf.getFilePosition(); i < 32; ++i) {
            this.braf.writeByte(0);
        }
        for (DbfField field : fields) {
            this.braf.writeASCII(field.getName(), 11);
            this.braf.writeByte(field.fieldType);
            this.braf.leWriteInt(0);
            this.braf.writeByte(field.getFieldLength());
            this.braf.writeByte(field.getFieldDecimalCount());
            for (int i = 18; i < 32; ++i) {
                this.braf.writeByte(0);
            }
        }
        this.braf.write(13);
    }

    public void setDbfFieldValue(String name, int value) {
        DbfField f = this.matchNameToField(name);
        if (f instanceof DbfFieldInt) {
            ((DbfFieldInt)f).setInteger(value);
        } else if (f instanceof DbfFieldDouble) {
            ((DbfFieldDouble)f).setInteger(value);
        } else {
            throw new IllegalArgumentException("Field " + f.getName() + " is not a numeric type");
        }
    }

    public void setDbfFieldValue(String name, double value) {
        DbfField f = this.matchNameToField(name);
        if (f instanceof DbfFieldInt) {
            ((DbfFieldInt)f).setDouble(value);
        } else if (f instanceof DbfFieldDouble) {
            ((DbfFieldDouble)f).setDouble(value);
        } else {
            throw new IllegalArgumentException("Field " + f.getName() + " is not a numeric type");
        }
    }

    public void setDbfFieldValue(String name, String value) {
        DbfField f = this.matchNameToField(name);
        f.setString(value);
    }

    private DbfField matchNameToField(String name) {
        for (DbfField f : this.fields) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return f;
        }
        throw new IllegalArgumentException("No field matches specified name " + name);
    }

    public void flush() throws IOException {
        this.braf.seek(4L);
        this.braf.leWriteInt(this.nRecords);
        this.braf.flush();
        this.braf.seek(this.braf.getFileSize());
    }

    @Override
    public void close() throws IOException {
        if (!this.braf.isClosed()) {
            this.flush();
            long fileSize = this.braf.getFileSize();
            this.braf.seek(fileSize);
            this.braf.write(26);
            this.braf.close();
        }
    }

    public void writeRecord() throws IOException {
        long fileSize = this.braf.getFileSize();
        this.braf.seek(fileSize);
        this.braf.write(32);
        for (DbfField f : this.fields) {
            f.write(this.braf);
        }
        ++this.nRecords;
    }
}

