/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

import java.util.Arrays;
import org.tinfour.gis.shapefile.ShapefileType;

public class ShapefileRecord {
    public ShapefileType shapefileType;
    public long offset;
    public int recordNumber;
    public int nPoints;
    public int nParts;
    public int[] partStart;
    public double[] xyz;
    public double x0;
    public double x1;
    public double y0;
    public double y1;
    public double z0;
    public double z1;

    ShapefileRecord(ShapefileType shapefileType) {
        this.shapefileType = shapefileType;
    }

    void setSizes(int nPoints, int nParts) {
        this.nPoints = nPoints;
        this.nParts = nParts;
        if (this.partStart == null) {
            this.partStart = new int[nParts + 1];
            this.xyz = new double[nPoints * 3];
        } else {
            if (this.partStart.length < nParts + 1) {
                this.partStart = Arrays.copyOf(this.partStart, nParts + 1);
            } else if (this.partStart.length > nParts + 1) {
                this.partStart[nParts + 1] = 0;
            }
            if (this.xyz.length < nPoints * 3) {
                this.xyz = Arrays.copyOf(this.xyz, nPoints * 3);
            }
        }
    }

    void setBounds(double x0, double x1, double y0, double y1, double z0, double z1) {
        this.x0 = x0;
        this.x1 = x1;
        this.y0 = y0;
        this.y1 = y1;
        this.z0 = z0;
        this.z1 = z1;
    }

    public void addPolygon(int nPointsInput, double[] xyzInput, boolean nested) {
        int i;
        switch (this.shapefileType) {
            case PolyLineZ: 
            case PolyLine: {
                if (!nested) break;
                throw new IllegalArgumentException("The shapefile type " + this.shapefileType.name() + " does not support nested polygons");
            }
            case PolygonZ: 
            case Polygon: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Method not supported for shapefile type " + this.shapefileType.name());
            }
        }
        if (nPointsInput < 3) {
            throw new IllegalArgumentException("Input polygon must contain at least 3 unique points");
        }
        int nCoordinates = this.shapefileType.hasZ() ? 3 : 2;
        int n = nPointsInput;
        int index = (nPointsInput - 1) * nCoordinates;
        if (xyzInput[index] == xyzInput[0] && xyzInput[index + 1] == xyzInput[1]) {
            --n;
        }
        double area = 0.0;
        double xAnchor = xyzInput[0];
        double yAnchor = xyzInput[1];
        for (i = 1; i < n - 1; ++i) {
            double px0 = xyzInput[i * nCoordinates] - xAnchor;
            double py0 = xyzInput[i * nCoordinates + 1] - yAnchor;
            double px1 = xyzInput[(i + 1) * nCoordinates] - xAnchor;
            double py1 = xyzInput[(i + 1) * nCoordinates + 1] - yAnchor;
            area += px0 * py1 - px1 * py0;
        }
        if (this.nPoints == 0) {
            this.x0 = xyzInput[0];
            this.y0 = xyzInput[1];
            this.x1 = this.x0;
            this.y1 = this.y0;
        }
        for (i = 0; i < n; ++i) {
            double px = xyzInput[i * nCoordinates];
            double py = xyzInput[i * nCoordinates + 1];
            if (px < this.x0) {
                this.x0 = px;
            } else if (px > this.x1) {
                this.x1 = px;
            }
            if (py < this.y0) {
                this.y0 = py;
                continue;
            }
            if (!(py > this.y1)) continue;
            this.y1 = py;
        }
        if (this.shapefileType.hasZ()) {
            if (this.nPoints == 0) {
                this.z1 = this.z0 = xyzInput[2];
            }
            for (i = 0; i < n; ++i) {
                double pz = xyzInput[i * nCoordinates + 2];
                if (pz < this.z0) {
                    this.z0 = pz;
                    continue;
                }
                if (!(pz > this.z1)) continue;
                this.z1 = pz;
            }
        }
        if (!Double.isFinite(area)) {
            throw new IllegalArgumentException("Coordinates of infinity or NaN not allowed");
        }
        if (area == 0.0) {
            throw new IllegalArgumentException("Zero area polygon not allowed");
        }
        boolean reversalRequired = nested ? area < 0.0 : area > 0.0;
        int nP = this.nPoints;
        this.setSizes(this.nPoints + n + 1, this.nParts + 1);
        this.partStart[this.nParts - 1] = nP;
        if (reversalRequired) {
            for (int i2 = 0; i2 < n; ++i2) {
                int iOutput = (i2 + nP) * 3;
                int iInput = (n - 1 - i2) * nCoordinates;
                this.xyz[iOutput++] = xyzInput[iInput++];
                this.xyz[iOutput++] = xyzInput[iInput++];
                if (!this.shapefileType.hasZ()) continue;
                this.xyz[iOutput] = this.xyz[iInput];
            }
            int iOuput = (n + nP) * 3;
            int iInput = (n - 1) * nCoordinates;
            this.xyz[iOuput++] = xyzInput[iInput++];
            this.xyz[iOuput++] = xyzInput[iInput++];
            if (this.shapefileType.hasZ()) {
                this.xyz[iOuput] = this.xyz[iInput];
            }
        } else {
            for (int i3 = 0; i3 < n; ++i3) {
                int iOutput = (i3 + nP) * 3;
                int iInput = i3 * nCoordinates;
                this.xyz[iOutput] = xyzInput[iInput];
                this.xyz[iOutput + 1] = xyzInput[iInput + 1];
                if (!this.shapefileType.hasZ()) continue;
                this.xyz[iOutput + 2] = this.xyz[iInput + 2];
            }
            int iOutput = (n + nP) * 3;
            this.xyz[iOutput] = xyzInput[0];
            this.xyz[iOutput + 1] = xyzInput[1];
            if (this.shapefileType.hasZ()) {
                this.xyz[iOutput + 2] = this.xyz[2];
            }
        }
    }

    public void addPolyLine(int nPointsInput, double[] xyzInput) {
        int i;
        switch (this.shapefileType) {
            case PolyLineZ: 
            case PolyLine: {
                break;
            }
            case PolygonZ: 
            case Polygon: {
                this.addPolygon(nPointsInput, xyzInput, false);
                return;
            }
            default: {
                throw new IllegalArgumentException("Method not supported for shapefile type " + this.shapefileType.name());
            }
        }
        if (nPointsInput < 2) {
            throw new IllegalArgumentException("Input polygon must contain at least 2 unique points");
        }
        int nCoordinates = this.shapefileType.hasZ() ? 3 : 2;
        int n = nPointsInput;
        for (i = 0; i < n; ++i) {
            double px = xyzInput[i * nCoordinates];
            double py = xyzInput[i * nCoordinates + 1];
            if (px < this.x0) {
                this.x0 = px;
            } else if (px > this.x1) {
                this.x1 = px;
            }
            if (py < this.y0) {
                this.y0 = py;
                continue;
            }
            if (!(py > this.y1)) continue;
            this.y1 = py;
        }
        if (this.shapefileType.hasZ()) {
            if (this.nPoints == 0) {
                this.z1 = this.z0 = xyzInput[2];
            }
            for (i = 0; i < n; ++i) {
                double pz = xyzInput[i * nCoordinates + 2];
                if (pz < this.z0) {
                    this.z0 = pz;
                    continue;
                }
                if (!(pz > this.z1)) continue;
                this.z1 = pz;
            }
        }
        int nP = this.nPoints;
        this.setSizes(this.nPoints + n + 1, this.nParts + 1);
        this.partStart[this.nParts - 1] = nP;
        for (int i2 = 0; i2 < n; ++i2) {
            int iOutput = (i2 + nP) * 3;
            int iInput = i2 * nCoordinates;
            this.xyz[iOutput] = xyzInput[iInput];
            this.xyz[iOutput + 1] = xyzInput[iInput + 1];
            if (!this.shapefileType.hasZ()) continue;
            this.xyz[iOutput + 2] = this.xyz[iInput + 2];
        }
        int iOutput = (n + nP) * 3;
        int iInput = nP * nCoordinates;
        this.xyz[iOutput] = xyzInput[iInput];
        this.xyz[iOutput + 1] = xyzInput[iInput + 1];
        if (this.shapefileType.hasZ()) {
            this.xyz[iOutput + 2] = this.xyz[iInput + 2];
        }
    }

    public void clear() {
        this.nParts = 0;
        this.nPoints = 0;
    }

    public double[] getCoordinatesForPart(int iPart) {
        double[] c;
        if (!this.shapefileType.isPolyLine() && !this.shapefileType.isPolygon()) {
            throw new IllegalArgumentException("Shapefile type " + this.shapefileType.name() + " does not use a multi-part structure");
        }
        int i0 = this.partStart[iPart];
        int i1 = this.partStart[iPart + 1];
        int n = i1 - i0;
        if (this.shapefileType.hasZ()) {
            c = new double[n * 3];
            System.arraycopy(this.xyz, i0 * 3, c, 0, n * 3);
        } else {
            c = new double[n * 2];
            for (int i = 0; i < n; ++i) {
                int index = (i + i0) * 3;
                c[i * 2] = this.xyz[index];
                c[i * 2 + 1] = this.xyz[index + 1];
            }
        }
        return c;
    }
}

