/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.gis.shapefile.DbfFileWriter;
import org.tinfour.gis.shapefile.ShapefileRecord;
import org.tinfour.gis.shapefile.ShapefileWriterSpecification;
import org.tinfour.io.BufferedRandomAccessFile;

public class ShapefileWriter
implements Closeable {
    final File folder;
    final String baseName;
    final ShapefileWriterSpecification spec;
    final BufferedRandomAccessFile shapefile;
    final BufferedRandomAccessFile shapeIndex;
    int nRecords;
    double xMin = Double.POSITIVE_INFINITY;
    double yMin = Double.POSITIVE_INFINITY;
    double zMin = Double.POSITIVE_INFINITY;
    double mMin = Double.POSITIVE_INFINITY;
    double xMax = Double.NEGATIVE_INFINITY;
    double yMax = Double.NEGATIVE_INFINITY;
    double zMax = Double.NEGATIVE_INFINITY;
    double mMax = Double.NEGATIVE_INFINITY;
    List<DbfField> dbfFields;
    DbfFileWriter dbfWriter;
    boolean isClosed;

    public ShapefileWriter(File outputFile, ShapefileWriterSpecification spec) throws IOException {
        boolean status;
        if (outputFile.exists()) {
            throw new IOException("Specified file already exists:" + outputFile.getPath());
        }
        this.folder = outputFile.getParentFile();
        String name = outputFile.getName();
        if (name.toLowerCase().endsWith(".shp")) {
            name = name.substring(0, name.length() - 4);
        }
        this.baseName = name;
        File testFile = new File(this.folder, this.baseName + ".shp");
        if (testFile.exists()) {
            throw new IOException("Specified file already exists:" + testFile.getPath());
        }
        if (!this.folder.exists() && !(status = this.folder.mkdirs())) {
            throw new IOException("Unable to create folder for output: " + this.folder.getPath());
        }
        this.spec = spec;
        this.shapefile = this.initShapefile(this.baseName + ".shp");
        this.shapeIndex = this.initShapefile(this.baseName + ".shx");
        File dbfFile = new File(this.folder, this.baseName + ".dbf");
        this.dbfWriter = new DbfFileWriter(dbfFile, spec.fieldList);
        if (spec.prjContent != null) {
            File prjFile = new File(this.folder, this.baseName + ".prj");
            byte[] b = spec.prjContent.getBytes(StandardCharsets.ISO_8859_1);
            try (FileOutputStream fos = new FileOutputStream(prjFile);){
                fos.write(b, 0, b.length);
            }
        }
    }

    public ShapefileRecord createRecord() {
        return new ShapefileRecord(this.spec.shapefileType);
    }

    private BufferedRandomAccessFile initShapefile(String name) throws IOException {
        File file = new File(this.folder, name);
        BufferedRandomAccessFile braf = new BufferedRandomAccessFile(file, "rw");
        braf.writeInt(9994);
        braf.writeInt(0);
        braf.writeInt(0);
        braf.writeInt(0);
        braf.writeInt(0);
        braf.writeInt(0);
        braf.writeInt(0);
        braf.leWriteInt(1000);
        braf.leWriteInt(this.spec.shapefileType.getTypeCode());
        braf.leWriteDouble(0.0);
        braf.leWriteDouble(0.0);
        braf.leWriteDouble(0.0);
        braf.leWriteDouble(0.0);
        braf.leWriteDouble(0.0);
        braf.leWriteDouble(0.0);
        braf.leWriteDouble(0.0);
        braf.leWriteDouble(0.0);
        return braf;
    }

    public void flush() throws IOException {
        this.shapefile.flush();
        int fileLength = (int)(this.shapefile.getFileSize() / 2L);
        this.shapefile.seek(24L);
        this.shapefile.writeInt(fileLength);
        if (this.nRecords > 0) {
            this.shapefile.seek(36L);
            this.shapefile.leWriteDouble(this.xMin);
            this.shapefile.leWriteDouble(this.yMin);
            this.shapefile.leWriteDouble(this.xMax);
            this.shapefile.leWriteDouble(this.yMax);
            if (this.spec.shapefileType.is3D()) {
                this.shapefile.leWriteDouble(this.zMin);
                this.shapefile.leWriteDouble(this.zMax);
            } else {
                this.shapefile.seek(84L);
            }
            if (this.spec.shapefileType.hasM()) {
                this.shapefile.leWriteDouble(this.mMin);
                this.shapefile.leWriteDouble(this.mMax);
            }
        }
        this.shapefile.seek(this.shapefile.getFileSize());
        this.shapeIndex.seek(24L);
        this.shapeIndex.writeInt((int)(this.shapeIndex.getFileSize() / 2L));
        this.shapeIndex.seek(this.shapeIndex.getFileSize());
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.flush();
            this.isClosed = true;
            this.shapefile.close();
            this.dbfWriter.close();
            this.shapeIndex.close();
        }
    }

    public void setDbfFieldValue(String name, int value) {
        this.dbfWriter.setDbfFieldValue(name, value);
    }

    public void setDbfFieldValue(String name, double value) {
        this.dbfWriter.setDbfFieldValue(name, value);
    }

    public void setDbfFieldValue(String name, String value) {
        this.dbfWriter.setDbfFieldValue(name, value);
    }

    public void writeRecord(ShapefileRecord record) throws IOException {
        if (record.nPoints == 0) {
            throw new IOException("Unable to write empty record");
        }
        this.dbfWriter.writeRecord();
        long recordOffset = this.shapefile.getFilePosition();
        ++this.nRecords;
        this.shapefile.writeInt(this.nRecords);
        int contentLength = 0;
        if (record.x0 < this.xMin) {
            this.xMin = record.x0;
        }
        if (record.x1 > this.xMax) {
            this.xMax = record.x1;
        }
        if (record.y0 < this.yMin) {
            this.yMin = record.y0;
        }
        if (record.y1 > this.yMax) {
            this.yMax = record.y1;
        }
        if (this.spec.shapefileType.hasZ()) {
            if (record.z0 > this.zMin) {
                this.zMin = record.z0;
            }
            if (record.z1 > this.zMax) {
                this.zMax = record.z1;
            }
        }
        switch (this.spec.shapefileType) {
            case PolyLine: 
            case Polygon: 
            case PolyLineZ: 
            case PolygonZ: {
                int i;
                contentLength = 44 + record.nParts * 4 + record.nPoints * 16;
                if (this.spec.shapefileType.hasZ()) {
                    contentLength += 16 + 8 * record.nPoints;
                }
                this.shapefile.writeInt(contentLength / 2);
                this.shapefile.leWriteInt(this.spec.shapefileType.getTypeCode());
                this.shapefile.leWriteDouble(record.x0);
                this.shapefile.leWriteDouble(record.y0);
                this.shapefile.leWriteDouble(record.x1);
                this.shapefile.leWriteDouble(record.y1);
                this.shapefile.leWriteInt(record.nParts);
                this.shapefile.leWriteInt(record.nPoints);
                for (int i2 = 0; i2 < record.nParts; ++i2) {
                    this.shapefile.leWriteInt(record.partStart[i2]);
                }
                int k = 0;
                for (i = 0; i < record.nPoints; ++i) {
                    this.shapefile.leWriteDouble(record.xyz[k++]);
                    this.shapefile.leWriteDouble(record.xyz[k++]);
                    ++k;
                }
                if (this.spec.shapefileType.hasZ()) {
                    this.shapefile.leWriteDouble(record.z0);
                    this.shapefile.leWriteDouble(record.z1);
                    for (i = 0; i < record.nPoints; ++i) {
                        this.shapefile.leWriteDouble(i * 3 + 2);
                    }
                }
                this.shapeIndex.writeInt((int)(recordOffset / 2L));
                this.shapeIndex.writeInt(contentLength / 2);
                break;
            }
            default: {
                throw new IOException("Unsupported type " + (Object)((Object)this.spec.shapefileType));
            }
        }
    }
}

