/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gis.shapefile;

import java.util.ArrayList;
import java.util.List;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.gis.shapefile.DbfFieldDouble;
import org.tinfour.gis.shapefile.DbfFieldInt;
import org.tinfour.gis.shapefile.ShapefileType;

public class ShapefileWriterSpecification {
    ShapefileType shapefileType = ShapefileType.PolyLine;
    int fieldOffset = 1;
    List<DbfField> fieldList = new ArrayList<DbfField>();
    String prjContent;

    public void setShapefileType(ShapefileType type) {
        if (!type.isPolygon() && !type.isPolyLine() || type.hasM()) {
            throw new IllegalArgumentException("Shapefile type: " + type.name() + " is not yet supported");
        }
        this.shapefileType = type;
    }

    public void addIntegerField(String name, int fieldLength) {
        String a = this.checkName(name);
        this.fieldList.add(new DbfFieldInt(a, 'N', 0, fieldLength, 0, this.fieldOffset));
        this.fieldOffset += fieldLength;
    }

    public void addFloatingPointField(String name, int fieldLength, int fieldDecimalCount, boolean useEngineeringNotation) {
        String a = this.checkName(name);
        this.fieldList.add(new DbfFieldDouble(a, 'F', 0, fieldLength, fieldDecimalCount, this.fieldOffset, useEngineeringNotation));
        this.fieldOffset += fieldLength;
    }

    public void addTextField(String name, int fieldLength) {
        String a = this.checkName(name);
        this.fieldList.add(new DbfFieldInt(a, 'C', 0, fieldLength, 0, this.fieldOffset));
        this.fieldOffset += fieldLength;
    }

    private String checkName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null value for name not allowed");
        }
        String a = name.trim();
        if (a.isEmpty()) {
            throw new IllegalArgumentException("Empty name specification not allowed");
        }
        if (a.length() > 10) {
            throw new IllegalArgumentException("Name length exceeeds 10 character max: " + name);
        }
        return a;
    }

    public void setShapefilePrjContent(String prjContent) {
        this.prjContent = prjContent;
    }

    public String getShapefilePrjContent() {
        return this.prjContent;
    }
}

