/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gwr;

import java.util.Arrays;
import java.util.Random;
import org.apache.commons.math3.distribution.TDistribution;
import org.tinfour.gwr.BandwidthSelectionMethod;
import org.tinfour.gwr.SurfaceGwr;
import org.tinfour.gwr.SurfaceModel;

public class GwrInterpolator {
    SurfaceModel surfaceModel;
    final SurfaceGwr gwr = new SurfaceGwr();
    int minRequiredSamples;
    BandwidthSelectionMethod bandwidthMethod;
    double bandwidthParameter;
    double bandwidth = 0.0;
    double[] beta;
    long nAutomaticBandwidthTests;
    private static final int nSubdivisionsOfBandwidthTestDomain = 6;
    private static final double bandwidthTestDomainScale0 = 0.3;
    private static final double bandwidthTestDomainScale1 = 1.0;
    private static final double[] automaticTestParameters;

    private void checkInputs(int nSamples, double[][] samples) {
        int minRequired = SurfaceModel.Planar.getIndependentVariableCount();
        if (nSamples < minRequired) {
            throw new IllegalArgumentException("Specified number of samples," + nSamples + ", is smaller than minumum of " + minRequired);
        }
        if (samples.length < nSamples) {
            throw new IllegalArgumentException("Input array length " + samples.length + "is smaller than specified number of samples " + nSamples);
        }
        for (int i = 0; i < nSamples; ++i) {
            if (samples[i].length >= 3) continue;
            throw new IllegalArgumentException("Input sample " + i + " is of length " + samples[i].length + ", where 3 is required");
        }
    }

    public double interpolateUsingAutomaticModelAndBandwidth(double qx, double qy, int nSamples, double[][] samples) {
        this.checkInputs(nSamples, samples);
        double[] weights = new double[nSamples];
        double[][] sampleWeightsMatrix = new double[nSamples][nSamples];
        double[] distsq = new double[nSamples];
        double meanDist = this.prepDistances(qx, qy, nSamples, samples, distsq);
        double bestAICc = Double.POSITIVE_INFINITY;
        double bestBandwidth = Double.POSITIVE_INFINITY;
        SurfaceModel bestModel = null;
        for (SurfaceModel model : SurfaceModel.values()) {
            if (!this.prepWeights(model, BandwidthSelectionMethod.OptimalAICc, 0.0, qx, qy, nSamples, samples, distsq, weights, sampleWeightsMatrix, meanDist) || nSamples < model.getCoefficientCount() + 1) continue;
            this.gwr.initWeightsMatrixUsingGaussianKernel(samples, nSamples, this.bandwidth, sampleWeightsMatrix);
            double AICc = this.gwr.evaluateAICc(model, qx, qy, nSamples, samples, weights, sampleWeightsMatrix);
            if (!(AICc < bestAICc)) continue;
            bestAICc = AICc;
            bestBandwidth = this.bandwidth;
            bestModel = model;
        }
        if (bestModel == null) {
            return Double.NaN;
        }
        this.bandwidth = bestBandwidth;
        this.computeWeights(nSamples, distsq, weights, bestBandwidth);
        this.beta = this.gwr.computeRegression(bestModel, qx, qy, nSamples, samples, weights, null);
        if (this.beta == null) {
            return Double.NaN;
        }
        return this.beta[0];
    }

    private void computeWeights(int nSamples, double[] distsq, double[] weights, double lambda) {
        double lambda2 = lambda * lambda;
        for (int i = 0; i < nSamples; ++i) {
            weights[i] = Math.exp(-0.5 * (distsq[i] / lambda2));
        }
    }

    private boolean prepWeights(SurfaceModel model, BandwidthSelectionMethod bandwidthMethod, double bandwidthParameter, double qx, double qy, int nSamples, double[][] samples, double[] distsq, double[] weights, double[][] sampleWeightsMatrix, double meanDist) {
        this.minRequiredSamples = this.gwr.getMinimumRequiredSamples(model);
        if (this.minRequiredSamples > nSamples) {
            return false;
        }
        this.bandwidthMethod = bandwidthMethod;
        this.bandwidthParameter = bandwidthParameter;
        switch (bandwidthMethod) {
            case FixedBandwidth: {
                this.bandwidth = bandwidthParameter;
                break;
            }
            case FixedProportionalBandwidth: {
                this.bandwidth = meanDist * bandwidthParameter;
                break;
            }
            case OptimalAICc: {
                this.bandwidth = this.prepAutomaticBandwidthSelection(model, qx, qy, nSamples, samples, distsq, weights, sampleWeightsMatrix, meanDist);
                break;
            }
            case OrdinaryLeastSquares: {
                this.bandwidth = Double.POSITIVE_INFINITY;
                break;
            }
            default: {
                this.bandwidth = Double.POSITIVE_INFINITY;
            }
        }
        if (bandwidthMethod == BandwidthSelectionMethod.OrdinaryLeastSquares || Double.isInfinite(this.bandwidth)) {
            Arrays.fill(weights, 0, nSamples, 1.0);
        } else {
            this.computeWeights(nSamples, distsq, weights, this.bandwidth);
        }
        return true;
    }

    private double prepDistances(double qx, double qy, int nSamples, double[][] samples, double[] distsq) {
        double sumDist = 0.0;
        for (int i = 0; i < nSamples; ++i) {
            double d2;
            double[] s = samples[i];
            double dx = s[0] - qx;
            double dy = s[1] - qy;
            distsq[i] = d2 = dx * dx + dy * dy;
            sumDist += Math.sqrt(d2);
        }
        return sumDist / (double)nSamples;
    }

    private double testBandwidth(SurfaceModel model, double qx, double qy, int nSamples, double[][] samples, double[] distsq, double[] weights, double[][] sampleWeightsMatrix, double lambda) {
        ++this.nAutomaticBandwidthTests;
        double lambda2 = lambda * lambda;
        for (int i = 0; i < nSamples; ++i) {
            weights[i] = Math.exp(-0.5 * (distsq[i] / lambda2));
        }
        this.gwr.initWeightsMatrixUsingGaussianKernel(samples, nSamples, lambda, sampleWeightsMatrix);
        return this.gwr.evaluateAICc(model, qx, qy, nSamples, samples, weights, sampleWeightsMatrix);
    }

    private double testOrdinaryLeastSquares(SurfaceModel model, double qx, double qy, int nSamples, double[][] samples, double[] weights, double[][] sampleWeightsMatrix) {
        Arrays.fill(weights, 0, nSamples, 1.0);
        for (int i = 0; i < nSamples; ++i) {
            Arrays.fill(sampleWeightsMatrix[i], 0, nSamples, 1.0);
        }
        this.gwr.computeRegression(model, qx, qy, nSamples, samples, weights, sampleWeightsMatrix);
        return this.gwr.getAICc();
    }

    private double prepAutomaticBandwidthSelection(SurfaceModel model, double qx, double qy, int nSamples, double[][] samples, double[] distsq, double[] weights, double[][] sampleWeightsMatrix, double meanDist) {
        int i;
        double m1 = meanDist * 1.0;
        double m0 = meanDist * 0.3;
        double deltaM = m1 - m0;
        if (deltaM < 0.0) {
            deltaM = 0.0;
        }
        int nCut = 6;
        double[] x = new double[nCut];
        double[] y = new double[nCut];
        for (int i2 = 0; i2 < nCut; ++i2) {
            x[i2] = automaticTestParameters[i2] * deltaM + m0;
            y[i2] = this.testBandwidth(model, qx, qy, nSamples, samples, distsq, weights, sampleWeightsMatrix, x[i2]);
        }
        double acceptX = deltaM / 100000.0;
        double xBest = x[0];
        double yBest = y[0];
        int iBest = 0;
        for (i = 1; i < nCut; ++i) {
            if (!(y[i] <= yBest)) continue;
            xBest = x[i];
            yBest = y[i];
            iBest = i;
        }
        if (iBest == nCut - 1) {
            double yTest = this.testOrdinaryLeastSquares(model, qx, qy, nSamples, samples, weights, sampleWeightsMatrix);
            if (yTest < yBest) {
                return Double.POSITIVE_INFINITY;
            }
            return xBest;
        }
        block2: for (i = 1; i < nCut - 1; ++i) {
            double Xc2;
            double Xb2;
            double det;
            double Yc;
            double Xb;
            double Yb;
            double Xc;
            double A;
            double y2 = y[i + 1];
            double y1 = y[i];
            double x2 = x[i + 1];
            double x1 = x[i];
            double s1 = (y2 - y1) / (x2 - x1);
            double y0 = y[i - 1];
            double x0 = x[i - 1];
            double s0 = (y1 - y0) / (x1 - x0);
            if (!(s1 > s0)) continue;
            for (int iTest = 0; iTest < 3 && !((A = ((Xc = x2 - x0) * (Yb = y1 - y0) - (Xb = x1 - x0) * (Yc = y2 - y0)) / (det = (Xb2 = Xb * Xb) * Xc - Xb * (Xc2 = Xc * Xc))) <= 0.0); ++iTest) {
                double delta;
                double yTest;
                double B = (Xb2 * Yc - Xc2 * Yb) / det;
                double xTest = x0 - B / (2.0 * A);
                if (xTest < x1) {
                    if (xTest < x0 || Double.isNaN(yTest = this.testBandwidth(model, qx, qy, nSamples, samples, distsq, weights, sampleWeightsMatrix, xTest))) continue block2;
                    delta = x1 - xTest;
                    x2 = x1;
                    y2 = y1;
                    x1 = xTest;
                    y1 = yTest;
                } else {
                    if (xTest > x2 || Double.isNaN(yTest = this.testBandwidth(model, qx, qy, nSamples, samples, distsq, weights, sampleWeightsMatrix, xTest))) continue block2;
                    delta = xTest - x1;
                    x0 = x1;
                    y0 = y1;
                    x1 = xTest;
                    y1 = yTest;
                }
                if (yTest < yBest) {
                    yBest = yTest;
                    xBest = xTest;
                }
                if (delta < acceptX) continue block2;
            }
        }
        return xBest;
    }

    public double interpolate(SurfaceModel model, BandwidthSelectionMethod bandwidthMethod, double bandwidthParameter, double qx, double qy, int nSamples, double[][] samples) {
        this.checkInputs(nSamples, samples);
        double[] distsq = new double[nSamples];
        double[] weights = new double[nSamples];
        double distMean = this.prepDistances(qx, qy, nSamples, samples, distsq);
        double[][] sampleWeightsMatrix = null;
        if (bandwidthMethod == BandwidthSelectionMethod.OptimalAICc) {
            sampleWeightsMatrix = new double[nSamples][nSamples];
        }
        if (!this.prepWeights(model, bandwidthMethod, bandwidthParameter, qx, qy, nSamples, samples, distsq, weights, sampleWeightsMatrix, distMean)) {
            return Double.NaN;
        }
        this.beta = this.gwr.computeRegression(model, qx, qy, nSamples, samples, weights, sampleWeightsMatrix);
        if (this.beta == null) {
            return Double.NaN;
        }
        return this.beta[0];
    }

    private void prepSampleWeightsMatrix() {
        if (!this.gwr.isSampleWeightsMatrixSet()) {
            int nSamples = this.gwr.getSampleCount();
            if (nSamples == 0) {
                return;
            }
            double[][] samples = this.gwr.getSamples();
            double[][] sampleWeightMatrix = new double[nSamples][nSamples];
            this.gwr.initWeightsMatrixUsingGaussianKernel(samples, nSamples, this.bandwidth, sampleWeightMatrix);
            this.gwr.setSampleWeightsMatrix(sampleWeightMatrix);
        }
    }

    public double getAICc() {
        this.prepSampleWeightsMatrix();
        return this.gwr.getAICc();
    }

    public double[] getCoefficients() {
        if (this.beta == null) {
            return new double[0];
        }
        return Arrays.copyOf(this.beta, this.beta.length);
    }

    public double getEffectiveDegreesOfFreedom() {
        this.prepSampleWeightsMatrix();
        return this.gwr.getEffectiveDegreesOfFreedom();
    }

    public double getLeungDelta1() {
        this.prepSampleWeightsMatrix();
        return this.gwr.getLeungDelta1();
    }

    public double getLeungDelta2() {
        this.prepSampleWeightsMatrix();
        return this.gwr.getLeungDelta2();
    }

    public double[] getPredictionInterval(double alpha) {
        this.prepSampleWeightsMatrix();
        double h = this.getPredictionIntervalHalfRange(alpha);
        double[] a = new double[]{this.beta[0] - h, this.beta[0] + h};
        return a;
    }

    public double getPredictionIntervalHalfRange(double alpha) {
        this.prepSampleWeightsMatrix();
        return this.gwr.getPredictionIntervalHalfRange(alpha);
    }

    public double[] getResiduals() {
        this.prepSampleWeightsMatrix();
        return this.gwr.getResiduals();
    }

    public double getResidualSumOfTheSquares() {
        this.prepSampleWeightsMatrix();
        return this.gwr.getResidualSumOfTheSquares();
    }

    public double[][] getSamples() {
        return this.gwr.getSamples();
    }

    public double getSlope() {
        if (this.beta == null) {
            return Double.NaN;
        }
        double fx = this.beta[1];
        double fy = this.beta[2];
        return Math.sqrt(fx * fx + fy * fy);
    }

    public double getStandardDeviation() {
        this.prepSampleWeightsMatrix();
        return this.gwr.getStandardDeviation();
    }

    public double getSigmaML() {
        this.prepSampleWeightsMatrix();
        return this.gwr.getSigmaML();
    }

    public SurfaceModel getSurfaceModel() {
        return this.gwr.getModel();
    }

    public double[] getSurfaceNormal() {
        if (this.beta == null) {
            return new double[0];
        }
        double[] n = new double[3];
        double fx = -this.beta[1];
        double fy = -this.beta[2];
        double s = Math.sqrt(fx * fx + fy * fy + 1.0);
        n[0] = fx / s;
        n[1] = fy / s;
        n[2] = 1.0 / s;
        return n;
    }

    public double getVariance() {
        this.prepSampleWeightsMatrix();
        return this.gwr.getVariance();
    }

    public double[] getWeights() {
        return this.gwr.getWeights();
    }

    public BootstrapResult bootstrap(SurfaceModel model, BandwidthSelectionMethod bandwidthMethod, double bandwidthParameter, double qx, double qy, int nSamples, double[][] samples, int nRepetitions, double threshold) {
        this.checkInputs(nSamples, samples);
        double[] distsq = new double[nSamples];
        double[] weights = new double[nSamples];
        double meanDist = this.prepDistances(qx, qy, nSamples, samples, distsq);
        double[][] sampleWeightsMatrix = null;
        if (bandwidthMethod == BandwidthSelectionMethod.OptimalAICc) {
            sampleWeightsMatrix = new double[nSamples][nSamples];
        }
        if (!this.prepWeights(model, bandwidthMethod, bandwidthParameter, qx, qy, nSamples, samples, distsq, weights, sampleWeightsMatrix, meanDist)) {
            return null;
        }
        double[][] jInputs = new double[nSamples][];
        double[] jWeights = new double[nSamples];
        Random jRand = new Random(0L);
        double jSum = 0.0;
        double j2Sum = 0.0;
        int n = 0;
        for (int jN = 0; jN < nRepetitions; ++jN) {
            int k = 0;
            for (int i = 0; i < nSamples; ++i) {
                double d = jRand.nextDouble();
                if (d < threshold) continue;
                jInputs[k] = samples[i];
                jWeights[k] = weights[i];
                ++k;
            }
            if (k < this.minRequiredSamples) continue;
            this.beta = this.gwr.computeRegression(model, qx, qy, k, jInputs, jWeights, null);
            if (this.beta == null || Double.isNaN(this.beta[0])) continue;
            jSum += this.beta[0];
            j2Sum += this.beta[0] * this.beta[0];
            ++n;
        }
        double jMean = jSum / (double)n;
        double s2 = ((double)n * j2Sum - jSum * jSum) / (double)(n * (n - 1));
        return new BootstrapResult(n, jMean, s2);
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public long getAutomaticBandwidthTestCount() {
        return this.nAutomaticBandwidthTests;
    }

    public BandwidthSelectionMethod getBandwidthSelectionMethod() {
        return this.bandwidthMethod;
    }

    static {
        int n = 6;
        automaticTestParameters = new double[n];
        for (int i = 1; i < n - 1; ++i) {
            double x;
            GwrInterpolator.automaticTestParameters[i] = x = Math.pow(2.0, (double)(-(n - i)) / 2.0);
        }
        GwrInterpolator.automaticTestParameters[n - 1] = 1.0;
    }

    public static class BootstrapResult {
        int n;
        double mean;
        double variance;

        BootstrapResult(int n, double mean, double variance) {
            this.n = n;
            this.mean = mean;
            this.variance = variance;
        }

        public double getConfidenceIntervalHalfSpan(double alpha) {
            TDistribution td = new TDistribution(this.n);
            double ta = td.inverseCumulativeProbability(1.0 - alpha / 2.0);
            return Math.sqrt(this.variance) * ta;
        }

        public int getN() {
            return this.n;
        }

        public double getMean() {
            return this.mean;
        }

        public double getVariance() {
            return this.variance;
        }

        public String toString() {
            return "Bootstrap result n=" + this.n + ", mean=" + this.mean + ", variance=" + this.variance;
        }
    }
}

