/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.gwr;

import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.INeighborhoodPointsCollector;
import org.tinfour.common.Vertex;
import org.tinfour.gwr.BandwidthSelectionMethod;
import org.tinfour.gwr.GwrInterpolator;
import org.tinfour.gwr.SurfaceModel;
import org.tinfour.interpolation.IInterpolatorOverTin;
import org.tinfour.interpolation.IVertexValuator;
import org.tinfour.interpolation.VertexValuatorDefault;

public class GwrTinInterpolator
extends GwrInterpolator
implements IInterpolatorOverTin {
    IIncrementalTin tin;
    int minRequiredSamples;
    private final VertexValuatorDefault defaultValuator = new VertexValuatorDefault();
    int maxDepth;
    int nSamples;
    int nSamplesSum;
    double interpolationPointX;
    double interpolationPointY;
    List<Vertex> sampleVertexList = new ArrayList<Vertex>();
    double[][] samples = new double[64][3];
    INeighborhoodPointsCollector neighborhoodPoints;

    private boolean prepSamples(double qx, double qy, IVertexValuator valuator) {
        this.nSamples = 0;
        this.interpolationPointX = qx;
        this.interpolationPointY = qy;
        IVertexValuator vq = valuator;
        if (vq == null) {
            vq = this.defaultValuator;
        }
        this.sampleVertexList = this.neighborhoodPoints.collectNeighboringVertices(qx, qy, this.maxDepth, this.minRequiredSamples);
        this.nSamples = this.sampleVertexList.size();
        this.nSamplesSum += this.nSamples;
        if (this.nSamples == 0) {
            return false;
        }
        if (this.nSamples > this.samples.length) {
            this.samples = new double[this.nSamples + 32][3];
        }
        int k = 0;
        for (Vertex sample : this.sampleVertexList) {
            this.samples[k][0] = sample.x;
            this.samples[k][1] = sample.y;
            this.samples[k][2] = vq.value(sample);
            ++k;
        }
        return true;
    }

    public GwrTinInterpolator(IIncrementalTin tin) {
        this.neighborhoodPoints = tin.getNeighborhoodPointsCollector();
        this.tin = tin;
        this.maxDepth = 3;
    }

    public GwrTinInterpolator(IIncrementalTin tin, int maxDepth) {
        this.neighborhoodPoints = tin.getNeighborhoodPointsCollector();
        this.tin = tin;
        this.maxDepth = maxDepth;
    }

    @Override
    public void resetForChangeToTin() {
        this.neighborhoodPoints.resetForChangeToTin();
    }

    @Override
    public double interpolate(double qx, double qy, IVertexValuator valuator) {
        return this.interpolate(SurfaceModel.CubicWithCrossTerms, BandwidthSelectionMethod.FixedProportionalBandwidth, 0.5, qx, qy, valuator);
    }

    public double interpolateUsingAutomaticModelAndBandwidth(double qx, double qy, IVertexValuator valuator) {
        if (!this.prepSamples(qx, qy, valuator)) {
            return Double.NaN;
        }
        return this.interpolateUsingAutomaticModelAndBandwidth(qx, qy, this.nSamples, this.samples);
    }

    public double interpolate(SurfaceModel model, BandwidthSelectionMethod bandwidthMethod, double bandwidthParameter, double qx, double qy, IVertexValuator valuator) {
        if (!this.prepSamples(qx, qy, valuator)) {
            return Double.NaN;
        }
        return this.interpolate(model, bandwidthMethod, bandwidthParameter, qx, qy, this.nSamples, this.samples);
    }

    public int getSampleCount() {
        return this.nSamples;
    }

    public Vertex[] getSampleVertices() {
        if (this.nSamples == 0) {
            return new Vertex[0];
        }
        return this.sampleVertexList.toArray(new Vertex[this.nSamples]);
    }

    @Override
    public boolean isSurfaceNormalSupported() {
        return true;
    }

    @Override
    public String getMethod() {
        BandwidthSelectionMethod bMethod = this.getBandwidthSelectionMethod();
        double bParameter = this.getBandwidth();
        SurfaceModel model = this.getSurfaceModel();
        if (model == null) {
            return "GWR: No interpolation performed";
        }
        return "GWR " + (Object)((Object)model) + ", depth " + this.maxDepth + ", bandwidth " + (Object)((Object)bMethod) + ":" + bParameter;
    }

    public double getSampleDistanceMean() {
        double sumDist = 0.0;
        if (this.nSamples == 0) {
            return Double.NaN;
        }
        for (int i = 0; i < this.nSamples; ++i) {
            double[] s = this.samples[i];
            double dx = s[0] - this.interpolationPointX;
            double dy = s[1] - this.interpolationPointY;
            double d2 = dx * dx + dy * dy;
            sumDist += Math.sqrt(d2);
        }
        return sumDist / (double)this.nSamples;
    }

    public boolean wasTargetExteriorToTin() {
        return this.neighborhoodPoints.wasTargetExteriorToTin();
    }
}

