/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.util.List;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;

public final class Polyside {
    private Polyside() {
    }

    public static Result isPointInPolygon(List<IQuadEdge> list, double x, double y) {
        int n = list.size();
        if (n < 3) {
            throw new IllegalArgumentException("A polygon needs at least three edges, but the input size is " + n);
        }
        IQuadEdge e0 = list.get(0);
        IQuadEdge e1 = list.get(n - 1);
        if (!e0.getA().equals(e1.getB())) {
            throw new IllegalArgumentException("Input polygon is not closed (last edge must at at start of first)");
        }
        int rCross = 0;
        int lCross = 0;
        for (IQuadEdge e : list) {
            double xTest;
            Vertex v0 = e.getA();
            Vertex v1 = e.getB();
            double x0 = v0.getX();
            double y0 = v0.getY();
            double x1 = v1.getX();
            double y1 = v1.getY();
            double yDelta = y0 - y1;
            if (y1 > y != y0 > y && (xTest = (x1 * y0 - x0 * y1 + y * (x0 - x1)) / yDelta) > x) {
                ++rCross;
            }
            if (y1 < y == y0 < y || !((xTest = (x1 * y0 - x0 * y1 + y * (x0 - x1)) / yDelta) < x)) continue;
            ++lCross;
        }
        if ((rCross ^ lCross) & true) {
            return Result.Edge;
        }
        if (rCross & true) {
            return Result.Inside;
        }
        return Result.Outside;
    }

    public static enum Result {
        Outside(false),
        Inside(true),
        Edge(true);

        private final boolean covered;

        private Result(boolean covered) {
            this.covered = covered;
        }

        public boolean isCovered() {
            return this.covered;
        }
    }
}

