/* --------------------------------------------------------------------
 * Copyright (C) 2019  Gary W. Lucas.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ---------------------------------------------------------------------
 */

 /*
 * -----------------------------------------------------------------------
 *
 * Revision History:
 * Date     Name         Description
 * ------   ---------    -------------------------------------------------
 * 03/2019  G. Lucas     Created  
 *
 * Notes:
 *
 * -----------------------------------------------------------------------
 */
package org.tinfour.demo.viewer;

/**
 * A small panel to serve as an accessory to the image-save dialog.
 */
public class ExportImageOptionsPanel extends javax.swing.JPanel {

  /**
   * Standard constructor
   */
  public ExportImageOptionsPanel() {
    initComponents();
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    imageFrameCheckBox = new javax.swing.JCheckBox();
    transparentBackgroundCheckBox = new javax.swing.JCheckBox();
    worldFileCheckbox = new javax.swing.JCheckBox();

    setBorder(javax.swing.BorderFactory.createEtchedBorder());
    setToolTipText("Set options for storing image");

    imageFrameCheckBox.setText("Add frame to image");
    imageFrameCheckBox.setToolTipText("Draw a thin frame (box) around image");

    transparentBackgroundCheckBox.setText("Transparent Background");
    transparentBackgroundCheckBox.setToolTipText("Save image with transparent background (PNG iimages only)");

    worldFileCheckbox.setText("Generate \"World\" File");
    worldFileCheckbox.setToolTipText("Generate a world file (.jgw, .pgw, .gfw)");

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(imageFrameCheckBox)
          .addComponent(transparentBackgroundCheckBox)
          .addComponent(worldFileCheckbox))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(imageFrameCheckBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(transparentBackgroundCheckBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(worldFileCheckbox)
        .addContainerGap(10, Short.MAX_VALUE))
    );
  }// </editor-fold>//GEN-END:initComponents

  boolean isImageFrameEnabled() {
    return imageFrameCheckBox.isSelected();
  }

  boolean isTransparentBackgroundEnabled() {
    return transparentBackgroundCheckBox.isSelected();
  }

  boolean isWorldFileEnabled() {
    return worldFileCheckbox.isSelected();
  }


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JCheckBox imageFrameCheckBox;
  private javax.swing.JCheckBox transparentBackgroundCheckBox;
  private javax.swing.JCheckBox worldFileCheckbox;
  // End of variables declaration//GEN-END:variables
}
