/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.development.cdt;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.SimpleTimeZone;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.TestOptions;

public class MultiSquareConstraintTest
implements IDevelopmentTest {
    private int nRows = 5;
    private int nCols = 5;
    private int nTests = 10000000;

    public static void main(String[] args) {
        MultiSquareConstraintTest test = new MultiSquareConstraintTest();
        test.runTest(System.out, args);
    }

    @Override
    public void runTest(PrintStream ps, String[] args) {
        TestOptions options = new TestOptions();
        boolean[] optionsMatched = options.argumentScan(args);
        options.checkForUnrecognizedArgument(args, optionsMatched);
        Class<?> tinClass = options.getTinClass();
        this.nRows = options.getRowCount(this.nRows);
        this.nCols = options.getRowCount(this.nCols);
        this.nTests = options.getTestCount(this.nTests);
        int reportInterval = this.nTests / 100;
        if (reportInterval == 0) {
            reportInterval = 1;
        }
        long randomSeed = options.getRandomSeed(0L);
        Random random = new Random(randomSeed);
        Locale locale = Locale.getDefault();
        Date date = new Date();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", locale);
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        ps.println("Multi-square Constraint Test");
        ps.format("Date of test:       %s UTC%n", sdFormat.format(date));
        ps.format("TIN class:          %s%n", tinClass.getName());
        ps.format("nRows:              %d%n", this.nRows);
        ps.format("nCols:              %d%n", this.nCols);
        ArrayList<PolygonConstraint> constraints = new ArrayList<PolygonConstraint>(this.nRows * this.nCols);
        int iVertex = 0;
        for (int iRow = 0; iRow < this.nRows; ++iRow) {
            int iCol = 0;
            while (iCol < this.nCols) {
                int iConstraint = iRow * this.nCols + iCol;
                PolygonConstraint p = new PolygonConstraint();
                p.setApplicationData((Object)iConstraint);
                int ix0 = iCol++;
                int iy0 = iRow;
                int ix1 = ix0 + 1;
                int iy1 = iy0 + 1;
                p.add(new Vertex((double)ix0, (double)iy0, 0.0, iVertex++));
                p.add(new Vertex((double)ix1, (double)iy0, 0.0, iVertex++));
                p.add(new Vertex((double)ix1, (double)iy1, 0.0, iVertex++));
                p.add(new Vertex((double)ix0, (double)iy1, 0.0, iVertex++));
                p.complete();
                constraints.add(p);
            }
        }
        IIncrementalTin tin = options.getNewInstanceOfTestTin();
        tin.addConstraints(constraints, true);
        IIncrementalTinNavigator navigator = tin.getNavigator();
        ps.format("%n", new Object[0]);
        ps.format("       Test        Inside     Border Even   Border Odd    Errors%n", new Object[0]);
        int kTests = 0;
        int kInterior = 0;
        int kBorderEven = 0;
        int kBorderOdd = 0;
        int kError = 0;
        for (int iTest = 0; iTest < this.nTests; ++iTest) {
            int coordIndex;
            double x = random.nextDouble() * (double)this.nCols;
            double y = random.nextDouble() * (double)this.nRows;
            if (x == Math.floor(x + 1.0E-6) || y == Math.floor(y + 1000000.0)) continue;
            IQuadEdge e = navigator.getNeighborEdge(x, y);
            if (e == null) {
                ++kError;
                continue;
            }
            Vertex C = e.getForward().getB();
            if (C == null) {
                ++kError;
                continue;
            }
            int index = -1;
            IConstraint constraint = tin.getRegionConstraint(e);
            if (constraint != null) {
                index = (Integer)constraint.getApplicationData();
                if (e.isConstrainedRegionInterior()) {
                    ++kInterior;
                } else if (e.isConstrainedRegionBorder()) {
                    if ((e.getIndex() & 1) == 0) {
                        ++kBorderEven;
                    } else {
                        ++kBorderOdd;
                    }
                }
            }
            if ((coordIndex = (int)y * this.nCols + (int)x) != index) {
                Vertex A = e.getA();
                Vertex B = e.getB();
                ps.format("Error at %d %s %s%n", e.getIndex(), A.toString(), B.toString());
                ++kError;
            }
            if (++kTests % reportInterval != 0) continue;
            ps.format("%12d %12d %12d %12d %12d%n", kTests, kInterior, kBorderEven, kBorderOdd, kError);
        }
        if (kTests % reportInterval != 0) {
            ps.format("%12d %12d %12d %12d%n", kTests, kInterior, kBorderEven, kBorderOdd, kError);
        }
        if (kError == 0) {
            ps.format("%nNo errors encountered, test passes", new Object[0]);
        } else {
            ps.format("%nErrors encountered, test fails", new Object[0]);
        }
    }
}

