/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.examples;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.TestVertices;
import org.tinfour.voronoi.BoundedVoronoiBuildOptions;
import org.tinfour.voronoi.BoundedVoronoiDiagram;
import org.tinfour.voronoi.BoundedVoronoiDrawingUtility;
import org.tinfour.voronoi.BoundedVoronoiStylerDefault;
import org.tinfour.voronoi.IBoundedVoronoiStyler;

public class ExampleVoronoi {
    public static void main(String[] args) throws IOException {
        int nVertices = 50;
        List<Vertex> vList = TestVertices.makeRandomVertices(nVertices, 0);
        BoundedVoronoiBuildOptions options = new BoundedVoronoiBuildOptions();
        options.enableAutomaticColorAssignment(true);
        BoundedVoronoiDiagram diagram = new BoundedVoronoiDiagram(vList, options);
        int width = 1000;
        int height = 1000;
        int padding = 5;
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = bImage.createGraphics();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        BoundedVoronoiStylerDefault defaultStyler = new BoundedVoronoiStylerDefault();
        BoundedVoronoiDrawingUtility drawUtility = new BoundedVoronoiDrawingUtility(diagram, width, height, padding, null);
        drawUtility.draw((Graphics)g2d, (IBoundedVoronoiStyler)defaultStyler);
        g2d.dispose();
        File outputFile = new File("ExampleVoronoi.png");
        ImageIO.write((RenderedImage)bImage, "PNG", outputFile);
    }
}

