/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.examples;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import javax.imageio.ImageIO;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.demo.utils.TestPalette;
import org.tinfour.demo.utils.VertexLoader;
import org.tinfour.standard.IncrementalTin;
import org.tinfour.utils.HilbertSort;

public class ExampleWireframeWithThinning
implements IDevelopmentTest {
    static String[] mandatoryOptions = new String[]{"-in"};

    AffineTransform initTransform(int width, int height, double x0, double x1, double y0, double y1) {
        double rImage = (double)width / (double)height;
        double rData = (x1 - x0) / (y1 - y0);
        double rAspect = rImage / rData;
        double uPerPixel = rAspect >= 1.0 ? (y1 - y0) / (double)height : (x1 - x0) / (double)width;
        double scale = 1.0 / uPerPixel;
        double xCenter = (x0 + x1) / 2.0;
        double yCenter = (y0 + y1) / 2.0;
        double xOffset = (double)(width / 2) - scale * xCenter;
        double yOffset = (double)(height / 2) + scale * yCenter;
        AffineTransform af = new AffineTransform(scale, 0.0, 0.0, -scale, xOffset, yOffset);
        return af;
    }

    @Override
    public void runTest(PrintStream ps, String[] args) throws IOException {
        long time1;
        int i;
        long time0;
        Date date = new Date();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.getDefault());
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        ps.println("ExampleWireframeWithThinning");
        ps.println("");
        ps.format("Date/time of test: %s (UTC)%n", sdFormat.format(date));
        TestOptions options = new TestOptions();
        boolean[] optionsMatched = options.argumentScan(args);
        options.checkForMandatoryOptions(args, mandatoryOptions);
        Integer width = options.scanIntOption(args, "-width", optionsMatched, 500);
        Integer height = options.scanIntOption(args, "-height", optionsMatched, 500);
        int separationInPixels = 20;
        double[] frame = options.getFrame();
        boolean isFrameSet = options.isFrameSet();
        options.checkForUnrecognizedArgument(args, optionsMatched);
        File inputFile = options.getInputFile();
        File outputFile = options.getOutputFile();
        String outputPath = "None";
        if (outputFile != null) {
            outputPath = outputFile.getAbsolutePath();
        }
        ps.format("Input file:  %s%n", inputFile.getAbsolutePath());
        ps.format("Output file: %s%n", outputPath);
        VertexLoader loader = new VertexLoader();
        List<Vertex> vertexList = loader.readInputFile(options);
        int nVertices = vertexList.size();
        double xmin = loader.getXMin();
        double xmax = loader.getXMax();
        double ymin = loader.getYMin();
        double ymax = loader.getYMax();
        double zmin = loader.getZMin();
        double zmax = loader.getZMax();
        ps.format("Number of vertices: %8d%n", nVertices);
        ps.format("Range x values:     %11.3f, %11.3f, (%f)%n", xmin, xmax, xmax - xmin);
        ps.format("Range y values:     %11.3f, %11.3f, (%f)%n", ymin, ymax, ymax - ymin);
        ps.format("Range z values:     %11.3f, %11.3f, (%f)%n", zmin, zmax, zmax - zmin);
        ps.flush();
        double x0 = xmin;
        double x1 = xmax;
        double y0 = ymin;
        double y1 = ymax;
        if (isFrameSet) {
            x0 = frame[0];
            x1 = frame[1];
            y0 = frame[2];
            y1 = frame[3];
            ps.format("Frame x values:     %11.3f, %11.3f, (%f)%n", x0, x1, x1 - x0);
            ps.format("Frame y values:     %11.3f, %11.3f, (%f)%n", y0, y1, y1 - y0);
        }
        AffineTransform af = this.initTransform(width, height, x0, x1, y0, y1);
        double scale = Math.sqrt(Math.abs(af.getDeterminant()));
        ps.format("Data to image scale: %11.3f%n", scale);
        Point2D.Double llCorner = new Point2D.Double(xmin, ymin);
        Point2D.Double urCorner = new Point2D.Double(xmax, ymax);
        af.transform(llCorner, llCorner);
        af.transform(urCorner, urCorner);
        double dWidth = ((Point2D)urCorner).getX() - ((Point2D)llCorner).getX();
        double dHeight = ((Point2D)llCorner).getY() - ((Point2D)urCorner).getY();
        double area = dWidth * dHeight;
        double s = separationInPixels;
        double k = area / (s * s * 0.866);
        if (k < (double)nVertices * 0.9) {
            int index;
            time0 = System.nanoTime();
            HilbertSort hilbertSort = new HilbertSort();
            hilbertSort.sort(vertexList);
            int n = (int)k;
            ArrayList<Vertex> thinList = new ArrayList<Vertex>();
            for (i = 0; i <= n && (index = (int)((double)i / k * (double)nVertices + 0.5)) < nVertices; ++i) {
                thinList.add(vertexList.get(index));
            }
            vertexList = thinList;
            nVertices = vertexList.size();
            time1 = System.nanoTime();
            ps.format("Time to thin vertices (milliseconds):       %11.3f%n", (double)(time1 - time0) / 1000000.0);
            ps.format("Number of thinned vertices:                 %7d%n", nVertices);
        }
        Object tin = options.isTinClassSet() ? options.getNewInstanceOfTestTin() : new IncrementalTin();
        ps.format("%nBuilding TIN using: %s%n", tin.getClass().getName());
        time0 = System.nanoTime();
        tin.add(vertexList, null);
        time1 = System.nanoTime();
        ps.format("Time to process vertices (milliseconds):    %11.3f%n", (double)(time1 - time0) / 1000000.0);
        if (outputFile == null) {
            return;
        }
        String name = outputFile.getName();
        String fmt = "PNG";
        i = name.lastIndexOf(46);
        if (i > 0) {
            fmt = name.substring(i + 1, name.length());
            if ("PNG".equalsIgnoreCase(fmt)) {
                fmt = "PNG";
            } else if ("JPEG".equalsIgnoreCase(fmt) || "JPG".equalsIgnoreCase(fmt)) {
                fmt = "JPEG";
            } else if ("GIF".equalsIgnoreCase(fmt)) {
                fmt = "GIF";
            } else {
                throw new IllegalArgumentException("Output file must be one of PNG, JPEG, or GIF%n");
            }
        }
        BufferedImage bImage = this.render(ps, af, width, height, x0, x1, y0, y1, zmin, zmax, (IIncrementalTin)tin, vertexList);
        ImageIO.write((RenderedImage)bImage, fmt, outputFile);
        ps.println("Example application processing complete.");
    }

    public static void main(String[] args) {
        ExampleWireframeWithThinning example = new ExampleWireframeWithThinning();
        try {
            example.runTest(System.out, args);
        }
        catch (IOException | IllegalArgumentException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private boolean inBounds(Vertex p, double x0, double x1, double y0, double y1) {
        double x = p.getX();
        double y = p.getY();
        return x0 <= x && x <= x1 && y0 <= y && y <= y1;
    }

    BufferedImage render(PrintStream ps, AffineTransform af, int width, int height, double x0, double x1, double y0, double y1, double zMin, double zMax, IIncrementalTin tin, List<Vertex> vertexList) throws IOException {
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = bImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(Color.black);
        g2d.fillRect(0, 0, width, height);
        Point2D.Double llCorner = new Point2D.Double(x0, y0);
        Point2D.Double urCorner = new Point2D.Double(x1, y1);
        af.transform(llCorner, llCorner);
        af.transform(urCorner, urCorner);
        Rectangle2D.Double clipBounds = new Rectangle2D.Double(((Point2D)llCorner).getX(), ((Point2D)urCorner).getY(), ((Point2D)urCorner).getX() - ((Point2D)llCorner).getX(), ((Point2D)llCorner).getY() - ((Point2D)urCorner).getY());
        g2d.setColor(Color.darkGray);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.draw(clipBounds);
        g2d.setClip(clipBounds);
        TestPalette palette = TestPalette.getRedToYellowToWhitePalette();
        Point2D.Double p0 = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        Line2D.Double l2d = new Line2D.Double();
        Ellipse2D.Double e2d = new Ellipse2D.Double();
        g2d.setStroke(new BasicStroke(2.0f));
        int nEdgeLen = 0;
        double sumEdgeLen = 0.0;
        List edges = tin.getEdges();
        for (IQuadEdge edge : edges) {
            Vertex v0 = edge.getA();
            Vertex v1 = edge.getB();
            if (v0 == null || v1 == null || !this.inBounds(v0, x0, x1, y0, y1) && !this.inBounds(v1, x0, x1, y0, y1)) continue;
            ((Point2D)p0).setLocation(v0.getX(), v0.getY());
            ((Point2D)p1).setLocation(v1.getX(), v1.getY());
            af.transform(p0, p0);
            af.transform(p1, p1);
            ++nEdgeLen;
            sumEdgeLen += p0.distance(p1);
            l2d.setLine(p0, p1);
            double z0 = v0.getZ();
            double z1 = v1.getZ();
            Color c0 = palette.getColor(z0, zMin, zMax);
            Color c1 = palette.getColor(z1, zMin, zMax);
            GradientPaint paint = new GradientPaint((float)v0.getX(), (float)v0.getY(), c0, (float)v1.getX(), (float)v1.getY(), c1);
            g2d.setPaint(paint);
            g2d.draw(l2d);
        }
        double avgLen = 0.0;
        if (nEdgeLen > 0) {
            avgLen = sumEdgeLen / (double)nEdgeLen;
        }
        ps.format("Number of edges rendered:                   %7d%n", nEdgeLen);
        ps.format("Average length of edges:                    %11.3f%n", avgLen);
        g2d.setStroke(new BasicStroke(1.0f));
        for (Vertex v : vertexList) {
            if (!this.inBounds(v, x0, x1, y0, y1)) continue;
            ((Point2D)p0).setLocation(v.getX(), v.getY());
            double z = v.getZ();
            int argb = palette.getARGB(z, zMin, zMax);
            Color c = new Color(argb);
            g2d.setColor(c);
            af.transform(p0, p1);
            ((RectangularShape)e2d).setFrame(((Point2D)p1).getX() - 2.0, ((Point2D)p1).getY() - 2.0, 6.0, 6.0);
            g2d.fill(e2d);
            g2d.draw(e2d);
        }
        g2d.setColor(Color.darkGray);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.setClip(null);
        g2d.draw(clipBounds);
        return bImage;
    }
}

