/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tinfour.common.Vertex;
import org.tinfour.gis.shapefile.DbfField;
import org.tinfour.gis.shapefile.DbfFileReader;
import org.tinfour.gis.shapefile.ShapefileReader;
import org.tinfour.gis.shapefile.ShapefileRecord;

public class VertexLoaderShapefile
implements Closeable {
    static final double eRadius = 6378137.0;
    static final double eFlattening = 0.003352810664781205;
    final File file;
    final String rootPath;
    ShapefileReader reader;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double zMin;
    double zMax;
    double timeForLoad;
    double geoScaleX = 1.0;
    double geoScaleY = 1.0;
    double geoOffsetX;
    double geoOffsetY;
    boolean geographicCoordinates;

    public VertexLoaderShapefile(File file) throws IOException {
        this.file = file;
        this.geoScaleX = 1.0;
        this.geoScaleY = 1.0;
        this.geoOffsetX = 0.0;
        this.geoOffsetY = 0.0;
        String testExt = null;
        String path = file.getPath();
        int lastPeriod = path.lastIndexOf(46);
        if (lastPeriod > 0) {
            testExt = path.substring(lastPeriod + 1, path.length());
        }
        if (!"shp".equalsIgnoreCase(testExt)) {
            throw new IllegalArgumentException("File must be of type .shp");
        }
        this.rootPath = path.substring(0, lastPeriod);
        this.reader = this.openFile(file);
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getZMin() {
        return this.zMin;
    }

    public double getZMax() {
        return this.zMax;
    }

    public double getTimeForLoad() {
        return this.timeForLoad;
    }

    public boolean isSourceInGeographicCoordinates() {
        return this.geographicCoordinates;
    }

    public double getGeoScaleX() {
        return this.geoScaleX;
    }

    public double getGeoScaleY() {
        return this.geoScaleY;
    }

    public double getGeoOffsetX() {
        return this.geoOffsetX;
    }

    public double getGeoOffsetY() {
        return this.geoOffsetY;
    }

    public List<Vertex> loadVertices(String dbfFieldForZ) throws IOException {
        DbfFileReader dbfReader = null;
        DbfField zField = null;
        boolean useShapefileZ = true;
        if (dbfFieldForZ != null && !dbfFieldForZ.trim().isEmpty()) {
            File dbfFile = this.reader.getCoFile("DBF");
            dbfReader = this.reader.getDbfFileReader();
            zField = dbfReader.getFieldByName(dbfFieldForZ.trim());
            if (zField == null) {
                try {
                    dbfReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IllegalArgumentException("The specified field " + dbfFieldForZ + " was not found in " + dbfFile.getName());
            }
            if (!zField.isNumeric()) {
                try {
                    dbfReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IllegalArgumentException("The specified field " + dbfFieldForZ + " is not numeric in" + dbfFile.getName());
            }
            useShapefileZ = false;
        }
        ArrayList<Vertex> vList = new ArrayList<Vertex>();
        ShapefileRecord record = null;
        this.xMin = Double.POSITIVE_INFINITY;
        this.yMin = Double.POSITIVE_INFINITY;
        this.zMin = Double.POSITIVE_INFINITY;
        this.xMax = Double.NEGATIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
        this.zMax = Double.NEGATIVE_INFINITY;
        while (this.reader.hasNext()) {
            record = this.reader.readNextRecord(record);
            int recNo = record.recordNumber;
            double[] xyz = record.xyz;
            double z = 0.0;
            if (dbfReader != null && zField != null) {
                dbfReader.readField(recNo, zField);
                z = zField.getDouble();
            }
            for (int i = 0; i < record.nPoints; ++i) {
                double x = xyz[0];
                double y = xyz[1];
                if (useShapefileZ) {
                    z = xyz[2];
                }
                if (this.geographicCoordinates) {
                    x = (x - this.geoOffsetX) * this.geoScaleX;
                    y = (y - this.geoOffsetY) * this.geoScaleY;
                }
                vList.add(new Vertex(x, y, z, recNo));
                if (x < this.xMin) {
                    this.xMin = x;
                }
                if (y < this.yMin) {
                    this.yMin = y;
                }
                if (z < this.zMin) {
                    this.zMin = z;
                }
                if (x > this.xMax) {
                    this.xMax = x;
                }
                if (y > this.yMax) {
                    this.yMax = y;
                }
                if (!(z > this.zMax)) continue;
                this.zMax = z;
            }
        }
        if (dbfReader != null) {
            dbfReader.close();
        }
        return vList;
    }

    private ShapefileReader openFile(File file) throws IOException, IllegalArgumentException {
        File target = file;
        ShapefileReader reader = null;
        try {
            reader = new ShapefileReader(target);
            this.checkForGeographicCoordinates(reader);
        }
        catch (IOException ioex) {
            try {
                if (reader != null) {
                    reader.close();
                    reader = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return reader;
    }

    private void checkForGeographicCoordinates(ShapefileReader reader) throws IOException {
        File target = reader.getCoFile("prj");
        if (target != null) {
            try (FileInputStream fins2 = new FileInputStream(target);){
                StringBuilder sb = new StringBuilder();
                byte[] buffer = new byte[8192];
                int n = 0;
                while ((n = fins2.read(buffer)) > 0) {
                    for (int i = 0; i < n; ++i) {
                        sb.append((char)buffer[i]);
                    }
                }
                String content = sb.toString().toUpperCase();
                int indexPROJ = content.indexOf("PROJ");
                if (indexPROJ >= 0) {
                    return;
                }
                int indexGEOCS = content.indexOf("GEOCS");
                if (indexGEOCS > 0) {
                    this.geographicCoordinates = true;
                }
            }
            catch (IOException fins2) {
                // empty catch block
            }
        }
        double x0 = reader.getMinX();
        double y0 = reader.getMinY();
        double x1 = reader.getMaxX();
        double y1 = reader.getMaxY();
        double dx = x1 - x0;
        double dy = y1 - y0;
        boolean bl = this.geographicCoordinates = dx <= 360.0 && dy < 90.0 && -180.0 <= x0 && x1 < 180.0 && -90.0 <= y0 && y1 <= 90.0;
        if (this.geographicCoordinates) {
            double cenLat = (y0 + y1) / 2.0;
            double phi = Math.toRadians(cenLat);
            double sinPhi = Math.sin(phi);
            double adjustment = 1.0 - 0.003352810664781205 * sinPhi * sinPhi;
            double adjRadius = adjustment * 6378137.0;
            this.geoScaleX = adjRadius * Math.cos(phi) * (Math.PI / 180);
            this.geoScaleY = adjRadius * (Math.PI / 180);
            this.geoOffsetX = x0;
            this.geoOffsetY = y0;
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

