/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.ModelAdapter;
import org.tinfour.gis.utils.VertexReaderShapefile;

public class ModelFromShapefile
extends ModelAdapter
implements IModel {
    static final double eRadius = 6378137.0;
    static final double eFlattening = 0.003352810664781205;
    String rootPath;
    String dbfFieldOption;

    public ModelFromShapefile(File file, String dbfFieldOption) {
        super(file);
        this.dbfFieldOption = dbfFieldOption;
        this.geoScaleX = 1.0;
        this.geoScaleY = 1.0;
        this.geoOffsetX = 0.0;
        this.geoOffsetY = 0.0;
        try (VertexReaderShapefile reader = new VertexReaderShapefile(file);){
            this.geographicCoordinates = reader.isSourceInGeographicCoordinates();
            this.coordinateTransform = reader.getCoordinateTransform();
            this.linearUnits = reader.getLinearUnits();
        }
        catch (IOException ioex) {
            throw new IllegalArgumentException("Unable to read " + file.getPath() + ", " + ioex.getMessage(), ioex);
        }
    }

    @Override
    public void load(IMonitorWithCancellation monitor) throws IOException {
        if (this.areVerticesLoaded) {
            System.out.println("Internal error, multiple calls to load model");
            return;
        }
        long time0 = System.currentTimeMillis();
        List vList = null;
        try (VertexReaderShapefile reader = new VertexReaderShapefile(this.file);){
            reader.setDbfFieldForZ(this.dbfFieldOption);
            vList = reader.read(monitor);
            this.xMin = reader.getXMin();
            this.yMin = reader.getYMin();
            this.xMax = reader.getXMax();
            this.yMax = reader.getYMax();
            this.zMin = reader.getZMin();
            this.zMax = reader.getZMax();
        }
        if (vList == null || vList.isEmpty()) {
            monitor.reportDone();
            throw new IOException("Unable to read points from file");
        }
        long time1 = System.currentTimeMillis();
        this.timeToLoad = time1 - time0;
        System.out.println("Loaded " + vList.size() + " vertices in " + this.timeToLoad + " ms");
        this.prepareModelForRendering(vList, monitor);
    }

    @Override
    public String getDescription() {
        return "Shapefile " + this.file.getName();
    }

    public String toString() {
        String conType = this.hasConstraints() ? " CDT" : "";
        String loaded = this.isLoaded() ? "Loaded" : "Unloaded";
        return String.format("Model From TXT %d %s%s", this.serialIndex, loaded, conType);
    }
}

