/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.development.cdt;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;

public class TestPanelForCdt
extends JPanel {
    static final long serialVersionUID = 1L;
    IIncrementalTin tin;
    AffineTransform af = new AffineTransform();
    AffineTransform afInverse = new AffineTransform();
    double afScale = 1.0;
    private Path2D path;
    private List<IQuadEdge> eList;
    private boolean fillPath;
    private double oversize = 1.5;
    private final Font labelFont = new Font("Arial", 1, 12);
    private Point2D pointMark;
    private TextLayout labelLayout;
    private Rectangle labelRectangle;
    private boolean valueLabelEnabled = false;
    private boolean indexLabelEnabled = true;
    private boolean directionEnabled = false;
    private String valueLabelFormat = "%f";
    private final List<Vertex> specialVertexList = new ArrayList<Vertex>();
    private final List<Vertex[]> specialChainList = new ArrayList<Vertex[]>();
    private Color edgeColor = Color.lightGray;
    private List<Vertex> overpaintPolygon;
    private Color overpaintFill;
    private Color overpaintEdge;

    void setOverpaintPolygon(List<Vertex> poly, Color fill, Color edge) {
        this.overpaintPolygon = poly;
        this.overpaintFill = fill;
        this.overpaintEdge = edge;
    }

    TestPanelForCdt(IIncrementalTin tin) {
        super(new BorderLayout());
        this.tin = tin;
    }

    void setNewTin(IIncrementalTin tin) {
        this.tin = tin;
        this.eList = null;
        this.pointMark = null;
        this.fillPath = false;
        this.path = null;
        this.specialVertexList.clear();
        this.specialChainList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addVertexToSpecialList(Vertex v) {
        TestPanelForCdt testPanelForCdt = this;
        synchronized (testPanelForCdt) {
            this.specialVertexList.add(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChainToSpecialList(Vertex[] v) {
        TestPanelForCdt testPanelForCdt = this;
        synchronized (testPanelForCdt) {
            this.specialChainList.add(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSpecialChainList() {
        TestPanelForCdt testPanelForCdt = this;
        synchronized (testPanelForCdt) {
            this.specialChainList.clear();
        }
    }

    void setOversize(double oversize) {
        this.oversize = oversize;
    }

    void setValueLabelEnabled(boolean valueLabelEnabled) {
        this.valueLabelEnabled = valueLabelEnabled;
    }

    void setValueLabelFormat(String format) {
        this.valueLabelFormat = format;
    }

    void setIndexLabelEnabled(boolean indexLabelEnabled) {
        this.indexLabelEnabled = indexLabelEnabled;
    }

    void setDirectionArrowEnabled(boolean enabled) {
        this.directionEnabled = enabled;
    }

    void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    void setPointMark(Point2D pointMark) {
        this.pointMark = pointMark;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(this.labelFont);
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        Rectangle2D bounds = this.tin.getBounds();
        double aB = bounds.getWidth() / bounds.getHeight();
        double aP = (double)w / (double)h;
        double scale = aP / aB > 1.0 ? (double)h / (bounds.getHeight() * this.oversize) : (double)w / (bounds.getWidth() * this.oversize);
        int xOffset = (int)((double)w / 2.0 - scale * bounds.getCenterX());
        int yOffset = (int)((double)h / 2.0 + scale * bounds.getCenterY());
        this.af = new AffineTransform(scale, 0.0, 0.0, -scale, (double)xOffset, (double)yOffset);
        this.afScale = scale;
        try {
            this.afInverse = this.af.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        if (this.eList != null) {
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(Color.lightGray);
            for (IQuadEdge e : this.eList) {
                Path2D.Double path2D = new Path2D.Double();
                ((Path2D)path2D).moveTo(e.getA().getX(), e.getA().getY());
                ((Path2D)path2D).lineTo(e.getB().getX(), e.getB().getY());
                Vertex c = e.getForward().getB();
                if (c == null) continue;
                ((Path2D)path2D).lineTo(c.getX(), c.getY());
                path2D.closePath();
                Shape s = path2D.createTransformedShape(this.af);
                g2d.fill(s);
                g2d.draw(s);
            }
        }
        if (this.path != null) {
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(Color.ORANGE);
            Shape s = this.path.createTransformedShape(this.af);
            if (this.fillPath) {
                g2d.fill(s);
            } else {
                g2d.draw(s);
            }
        }
        Point2D.Double p = new Point2D.Double();
        Point2D.Double p0 = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        Line2D.Double l2d = new Line2D.Double();
        Ellipse2D.Double e2d = new Ellipse2D.Double();
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(this.edgeColor);
        List edges = this.tin.getEdges();
        for (IQuadEdge e : edges) {
            if (e.getB() == null) continue;
            if (e.isConstrained()) {
                g2d.setColor(this.edgeColor.darker());
            } else {
                g2d.setColor(this.edgeColor);
            }
            ((Point2D)p0).setLocation(e.getA().x, e.getA().y);
            ((Point2D)p1).setLocation(e.getB().x, e.getB().y);
            this.af.transform(p0, p0);
            this.af.transform(p1, p1);
            l2d.setLine(p0, p1);
            g2d.draw(l2d);
            double mx = (e.getA().x + e.getB().x) / 2.0;
            double my = (e.getA().y + e.getB().y) / 2.0;
            double ux = ((Point2D)p1).getX() - ((Point2D)p0).getX();
            double uy = ((Point2D)p1).getY() - ((Point2D)p0).getY();
            double u = Math.sqrt(ux * ux + uy * uy);
            double px = -(uy /= u);
            double py = ux /= u;
            ((Point2D)p0).setLocation(mx, my);
            this.af.transform(p0, p0);
            mx = ((Point2D)p0).getX();
            my = ((Point2D)p0).getY();
            if (this.directionEnabled) {
                ((Line2D)l2d).setLine(mx + 2.0 * ux, my + 2.0 * uy, mx - 5.0 * ux + 3.0 * px, my - 5.0 * uy + 3.0 * py);
                g2d.draw(l2d);
                ((Line2D)l2d).setLine(mx + 2.0 * ux, my + 2.0 * uy, mx - 5.0 * ux - 3.0 * px, my - 5.0 * uy - 3.0 * py);
                g2d.draw(l2d);
            }
            if (!this.indexLabelEnabled) continue;
            String s = Integer.toString(e.getIndex());
            g2d.drawString(s, (float)(mx + 10.0 * px), (float)(my + 10.0 * py));
        }
        if (this.overpaintPolygon != null) {
            Path2D.Double path2D = new Path2D.Double();
            boolean move = true;
            for (Vertex vOver : this.overpaintPolygon) {
                if (move) {
                    move = false;
                    ((Path2D)path2D).moveTo(vOver.getX(), vOver.getY());
                    continue;
                }
                ((Path2D)path2D).lineTo(vOver.getX(), vOver.getY());
            }
            path2D.closePath();
            Shape s = path2D.createTransformedShape(this.af);
            g2d.setColor(this.overpaintFill);
            g2d.fill(s);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(this.overpaintEdge);
            g2d.draw(s);
        }
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(Color.BLACK);
        ArrayList<Vertex> junk = new ArrayList<Vertex>();
        for (IQuadEdge e : edges) {
            if (e.getA() == null) continue;
            if (!junk.contains(e.getA())) {
                junk.add(e.getA());
            }
            if (e.getB() == null || junk.contains(e.getB())) continue;
            junk.add(e.getB());
        }
        Vertex[] v = junk.toArray(new Vertex[junk.size()]);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            builder.setLength(0);
            ((Point2D)p0).setLocation(v[i].x, v[i].y);
            this.af.transform(p0, p1);
            ((RectangularShape)e2d).setFrame(((Point2D)p1).getX() - 2.0, ((Point2D)p1).getY() - 2.0, 4.0, 4.0);
            g2d.draw(e2d);
            g2d.fill(e2d);
            if (this.indexLabelEnabled) {
                builder.append(Integer.toString(v[i].getIndex()));
            }
            if (this.valueLabelEnabled) {
                if (this.indexLabelEnabled) {
                    builder.append("|");
                }
                builder.append(String.format(this.valueLabelFormat, v[i].getZ()));
            }
            g2d.drawString(builder.toString(), (float)((Point2D)p1).getX() + 3.0f, (float)((Point2D)p1).getY() - 3.0f);
        }
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(Color.RED);
        TestPanelForCdt i = this;
        synchronized (i) {
            for (Vertex vS : this.specialVertexList) {
                ((Point2D)p0).setLocation(vS.x, vS.y);
                this.af.transform(p0, p1);
                ((RectangularShape)e2d).setFrame(((Point2D)p1).getX() - 2.0, ((Point2D)p1).getY() - 2.0, 6.0, 6.0);
                g2d.draw(e2d);
                g2d.fill(e2d);
            }
        }
        for (Vertex[] vC : this.specialChainList) {
            if (vC.length <= 1) continue;
            for (int i2 = 0; i2 < vC.length - 1; ++i2) {
                ((Point2D)p0).setLocation(vC[i2].x, vC[i2].y);
                ((Point2D)p1).setLocation(vC[i2 + 1].x, vC[i2 + 1].y);
                this.af.transform(p0, p0);
                this.af.transform(p1, p1);
                l2d.setLine(p0, p1);
                g2d.draw(l2d);
                double mx = (vC[i2].x + vC[i2 + 1].x) / 2.0;
                double my = (vC[i2].y + vC[i2 + 1].y) / 2.0;
                double ux = ((Point2D)p1).getX() - ((Point2D)p0).getX();
                double uy = ((Point2D)p1).getY() - ((Point2D)p0).getY();
                double u = Math.sqrt(ux * ux + uy * uy);
                double px = -(uy /= u);
                double py = ux /= u;
                ((Point2D)p0).setLocation(mx, my);
                this.af.transform(p0, p0);
                mx = ((Point2D)p0).getX();
                my = ((Point2D)p0).getY();
                if (!this.directionEnabled) continue;
                ((Line2D)l2d).setLine(mx + 2.0 * ux, my + 2.0 * uy, mx - 5.0 * ux + 3.0 * px, my - 5.0 * uy + 3.0 * py);
                g2d.draw(l2d);
                ((Line2D)l2d).setLine(mx + 2.0 * ux, my + 2.0 * uy, mx - 5.0 * ux - 3.0 * px, my - 5.0 * uy - 3.0 * py);
                g2d.draw(l2d);
            }
        }
        if (this.labelLayout != null) {
            double x = 5.0;
            double y = this.getHeight() - 10;
            g2d.setColor(Color.BLACK);
            this.labelLayout.draw(g2d, (float)x, (float)y);
        }
        if (this.pointMark != null) {
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(Color.RED);
            this.af.transform(this.pointMark, p);
            double xC = ((Point2D)p).getX();
            double yC = ((Point2D)p).getY();
            ((Line2D)l2d).setLine(xC - 5.0, yC, xC + 5.0, yC);
            g2d.draw(l2d);
            ((Line2D)l2d).setLine(xC, yC - 5.0, xC, yC + 5.0);
            g2d.draw(l2d);
        }
    }

    Point2D mapPanelToTIN(Point2D point) {
        Point2D.Double result = new Point2D.Double();
        this.afInverse.transform(point, result);
        return result;
    }

    void setDiagnosticPath(Path2D path, boolean fill) {
        this.fillPath = fill;
        this.path = path;
        this.repaint();
    }

    AffineTransform getAffineTransform() {
        return new AffineTransform(this.af);
    }

    AffineTransform getAffineTransformInverse() {
        return new AffineTransform(this.afInverse);
    }

    public static TestPanelForCdt plot(IIncrementalTin tin, final String header) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            ex.printStackTrace(System.err);
        }
        final TestPanelForCdt testPanel = new TestPanelForCdt(tin);
        testPanel.setOversize(1.25);
        testPanel.setPreferredSize(new Dimension(500, 500));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.getB()oldMetal", Boolean.FALSE);
                JFrame frame = new JFrame(header);
                frame.setDefaultCloseOperation(3);
                frame.add(testPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
        return testPanel;
    }

    void setLabel(String label) {
        double x = 5.0;
        double y = this.getHeight() - 10;
        if (this.labelLayout != null) {
            Rectangle2D r2d = this.labelLayout.getBounds();
            this.labelRectangle = new Rectangle((int)(x + r2d.getX() - 2.0), (int)(y + r2d.getY() - 2.0), (int)(r2d.getWidth() + 4.0), (int)(r2d.getHeight() + 2.0));
            this.repaint(this.labelRectangle);
            this.labelLayout = null;
        }
        if (label != null && label.length() > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, true);
            this.labelLayout = new TextLayout(label, this.labelFont, frc);
        }
    }
}

