/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.examples;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.TabulatorDelta;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.demo.utils.VertexLoader;
import org.tinfour.gwr.BandwidthSelectionMethod;
import org.tinfour.gwr.GwrTinInterpolator;
import org.tinfour.interpolation.NaturalNeighborInterpolator;
import org.tinfour.interpolation.TriangularFacetInterpolator;
import org.tinfour.regression.SurfaceModel;
import org.tinfour.utils.TinInstantiationUtility;
import org.tinfour.utils.Tincalc;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;

public class ExampleCrossValidation
implements IDevelopmentTest {
    static String[] mandatoryOptions = new String[]{"-in"};

    public static void main(String[] args) {
        ExampleCrossValidation example = new ExampleCrossValidation();
        try {
            example.runTest(System.out, args);
        }
        catch (IOException | IllegalArgumentException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void runTest(PrintStream ps, String[] args) throws IOException {
        Class tinClass;
        double y1;
        double y0;
        double x1;
        double x0;
        double sSpace;
        Date date = new Date();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.getDefault());
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        ps.format("Example Cross Validation%n", new Object[0]);
        ps.format("Date/time of test: %s (UTC)%n", sdFormat.format(date));
        TestOptions options = new TestOptions();
        options.setLidarClass(2);
        boolean[] optionsMatched = options.argumentScan(args);
        options.checkForMandatoryOptions(args, mandatoryOptions);
        double[] frame = options.getFrame();
        boolean isFrameSet = options.isFrameSet();
        Double marginArg = options.scanDoubleOption(args, "-margin", optionsMatched);
        if (marginArg == null) {
            marginArg = 10.0;
        }
        boolean enableAutoBW = options.scanBooleanOption(args, "-autoBW", optionsMatched, false);
        boolean logProgress = options.scanBooleanOption(args, "-showProgress", optionsMatched, false);
        options.checkForUnrecognizedArgument(args, optionsMatched);
        File inputFile = options.getInputFile();
        ps.format("Input file: %s%n", inputFile.getAbsolutePath());
        VertexLoader loader = new VertexLoader();
        List vertexList = loader.readInputFile(options);
        int nVertices = vertexList.size();
        ps.format("Number of vertices: %8d%n", nVertices);
        double xmin = loader.getXMin();
        double xmax = loader.getXMax();
        double ymin = loader.getYMin();
        double ymax = loader.getYMax();
        double zmin = loader.getZMin();
        double zmax = loader.getZMax();
        double area = (xmax - xmin) * (ymax - ymin);
        double nominalPointSpacing = sSpace = Tincalc.sampleSpacing((double)area, (int)nVertices);
        ICoordinateTransform cTrans = loader.getCoordinateTransform();
        if (cTrans != null) {
            CoordinatePair g0 = new CoordinatePair();
            CoordinatePair g1 = new CoordinatePair();
            cTrans.inverse(xmin, ymin, g0);
            cTrans.inverse(xmax, ymax, g1);
            double gx = g1.x - g0.x;
            double gy = g1.y - g0.y;
            double gArea = gx * gy;
            double gsSpace = Tincalc.sampleSpacing((double)gArea, (int)nVertices);
            ps.format("Source data horizontal coordinates were transformed%n", new Object[0]);
            if (loader.isSourceInGeographicCoordinates()) {
                ps.format("Geographic coordinates are mapped to projected coordinates%n", new Object[0]);
            }
            ps.format("Range x values:     %11.6f, %11.6f, (%f)%n", g0.x, g1.x, gx);
            ps.format("Range y values:     %11.6f, %11.6f, (%f)%n", g0.y, g1.y, gy);
            ps.format("Est. sample spacing:   %e degrees of arc%n", gsSpace);
        }
        ps.format("Range x values:     %12.3f, %12.3f, (%f)%n", xmin, xmax, xmax - xmin);
        ps.format("Range y values:     %12.3f, %12.3f, (%f)%n", ymin, ymax, ymax - ymin);
        ps.format("Range z values:     %12.3f, %12.3f, (%f)%n", zmin, zmax, zmax - zmin);
        ps.format("Est. sample spacing:%12.3f%n", sSpace);
        ps.flush();
        if (isFrameSet) {
            x0 = frame[0];
            x1 = frame[1];
            y0 = frame[2];
            y1 = frame[3];
            ps.println("Using frame settings from supplied arguments");
            ps.format("Frame x values:     %12.3f, %12.3f, (%f)%n", x0, x1, x1 - x0);
            ps.format("Frame y values:     %12.3f, %12.3f, (%f)%n", y0, y1, y1 - y0);
        } else {
            double s = marginArg / 100.0;
            double dx = xmax - xmin;
            double dy = ymax - ymin;
            x0 = xmin + s * dx;
            x1 = xmin + (1.0 - s) * dx;
            y0 = ymin + s * dy;
            y1 = ymin + (1.0 - s) * dy;
            ps.println("Computing frame to allow a " + marginArg + " percent margin");
            ps.format("Frame x values:     %12.3f, %12.3f, (%f)%n", x0, x1, x1 - x0);
            ps.format("Frame y values:     %12.3f, %12.3f, (%f)%n", y0, y1, y1 - y0);
        }
        TinInstantiationUtility tiu = new TinInstantiationUtility(0.5, nVertices);
        if (options.isTinClassSet()) {
            tinClass = options.getTinClass();
        } else {
            ps.println("Performing automatic selection of TIN class based on memory and number of vertices");
            tiu.printSummary(ps);
            tinClass = tiu.getTinClass();
        }
        IIncrementalTin tin = tiu.constructInstance(tinClass, nominalPointSpacing);
        ps.format("%nBuilding TIN using: %s%n", tin.getClass().getName());
        long time0 = System.nanoTime();
        tin.add(vertexList, null);
        long time1 = System.nanoTime();
        ps.format("Time to process vertices (milliseconds):    %12.3f%n", (double)(time1 - time0) / 1000000.0);
        NaturalNeighborInterpolator inNni = new NaturalNeighborInterpolator(tin);
        TriangularFacetInterpolator inTri = new TriangularFacetInterpolator(tin);
        GwrTinInterpolator inGwr = new GwrTinInterpolator(tin);
        SurfaceModel sm3 = SurfaceModel.CubicWithCrossTerms;
        BandwidthSelectionMethod bsmFixed = BandwidthSelectionMethod.FixedBandwidth;
        double bandwidth = nominalPointSpacing;
        BandwidthSelectionMethod bsmPro = BandwidthSelectionMethod.FixedProportionalBandwidth;
        TabulatorDelta tabNni = new TabulatorDelta();
        TabulatorDelta tabTri = new TabulatorDelta();
        TabulatorDelta tabFix = new TabulatorDelta();
        TabulatorDelta tabPro = new TabulatorDelta();
        TabulatorDelta tabAdp = new TabulatorDelta();
        SurfaceModel[] smValues = SurfaceModel.values();
        int[] adpModelCount = new int[smValues.length];
        TabulatorDelta tabProB = new TabulatorDelta();
        TabulatorDelta tabBdw = new TabulatorDelta();
        TabulatorDelta tabBdwPro = new TabulatorDelta();
        TabulatorDelta tabSampleCount = new TabulatorDelta();
        ps.println("Performing cross validation");
        ps.println("Fixed bandwidth is " + bandwidth);
        vertexList = tin.getVertices();
        int nExpected = 0;
        for (Vertex v : vertexList) {
            double x = v.getX();
            double y = v.getY();
            if (!(x0 <= x) || !(x <= x1) || !(y0 <= y) || !(y <= y1)) continue;
            ++nExpected;
        }
        ps.println("Number of expected tests " + nExpected);
        int progressModulus = 0;
        if (logProgress) {
            progressModulus = (nExpected + 19) / 20;
        }
        int nTest = 0;
        int nOrdinary = 0;
        long timePrior = time0 = System.nanoTime();
        for (Vertex v : vertexList) {
            double x = v.getX();
            double y = v.getY();
            double z = v.getZ();
            if (!(x0 <= x) || !(x <= x1) || !(y0 <= y) || !(y <= y1) || !tin.remove(v)) continue;
            ++nTest;
            inNni.resetForChangeToTin();
            inTri.resetForChangeToTin();
            inGwr.resetForChangeToTin();
            double zNni = inNni.interpolate(x, y, null);
            double zTri = inTri.interpolate(x, y, null);
            double zFix = inGwr.interpolate(sm3, bsmFixed, bandwidth, x, y, null);
            double zPro = inGwr.interpolate(sm3, bsmPro, 0.45, x, y, null);
            tabNni.tabulate(zNni - z);
            tabTri.tabulate(zTri - z);
            tabFix.tabulate(zFix - z);
            tabPro.tabulate(zPro - z);
            tabSampleCount.tabulate(inGwr.getSampleCount());
            tabProB.tabulate(inGwr.getBandwidth());
            if (enableAutoBW) {
                int index;
                if (progressModulus > 0 && nTest % progressModulus == 0) {
                    int percentDone = 100 * nTest / nExpected;
                    time1 = System.nanoTime();
                    double deltaT = (double)(time1 - timePrior) / 1000000.0;
                    timePrior = time1;
                    double rate = (double)progressModulus / deltaT;
                    long estTimeRemaining = (long)((double)(nExpected - nTest) / rate);
                    Date estFinish = new Date(System.currentTimeMillis() + estTimeRemaining);
                    System.out.format("Completed %3d%%   (%f per sec)    est finish %s%n", percentDone, rate * 1000.0, estFinish.toString());
                    System.out.flush();
                }
                double zAdp = inGwr.interpolateUsingAutomaticModelAndBandwidth(x, y, null);
                double autoBandwidth = inGwr.getBandwidth();
                if (Double.isInfinite(autoBandwidth)) {
                    ++nOrdinary;
                } else {
                    double autoPro = autoBandwidth / inGwr.getSampleDistanceMean();
                    tabBdw.tabulate(autoBandwidth);
                    tabBdwPro.tabulate(autoPro);
                }
                SurfaceModel autoModel = inGwr.getSurfaceModel();
                int n = index = autoModel.ordinal();
                adpModelCount[n] = adpModelCount[n] + 1;
                tabAdp.tabulate(zAdp - z);
            }
            tin.add(v);
        }
        time1 = System.nanoTime();
        double deltaSeconds = (double)(time1 - time0) / 1.0E9;
        double testPerSec = (double)nTest / deltaSeconds;
        ps.format("Tested %d of %d vertices (%3.2f/sec)%n", nTest, vertexList.size(), testPerSec);
        ps.format("Method                        mean |err|  std dev |err|     range of err     sum err%n", new Object[0]);
        tabTri.summarize(ps, "Triangular Facet         ");
        tabNni.summarize(ps, "Natural Neighbor         ");
        tabFix.summarize(ps, String.format("GWR, Fixed Bandwith %4.2f ", bandwidth));
        tabPro.summarize(ps, String.format("GWR, Proportionate  %4.2f ", 0.45));
        if (enableAutoBW) {
            tabAdp.summarize(ps, "GWR, Automatic BW AICc   ");
            ps.format("%nValues for automatically selected bandwidth", new Object[0]);
            ps.format("   Mean:           %12.6f   (%8.6f of mean dist)%n", tabBdw.getMeanAbsValue(), tabBdwPro.getMeanAbsValue());
            ps.format("   Std Dev         %12.6f   (%8.6f)%n", tabBdw.getStdDevAbsValue(), tabBdwPro.getStdDevAbsValue());
            ps.format("   Min,Max:        %12.6f, %12.6f  (%5.3f, %5.3f of mean dist)%n", tabBdw.getMinValue(), tabBdw.getMaxValue(), tabBdwPro.getMinValue(), tabBdwPro.getMaxValue());
            ps.format("Number of Ordinary Least Squares: %d%n", nOrdinary);
            for (int i = 0; i < adpModelCount.length; ++i) {
                SurfaceModel sm = smValues[i];
                ps.format("%-25.25s  %8d%n", sm.name(), adpModelCount[i]);
            }
            long nAdpTest = inGwr.getAutomaticBandwidthTestCount();
            double adpRate = (double)nAdpTest / (double)adpModelCount.length / (double)nTest;
            ps.format("Number of Automatic Bandwidth Iterations %d (%f/model/vertex)%n", nAdpTest, adpRate);
        }
        ps.format("%nValues for proportionately selected bandwidth%n", new Object[0]);
        ps.format("Mean:    %12.6f%n", tabProB.getMeanAbsValue());
        ps.format("Std Dev: %12.6f%n", tabProB.getStdDevAbsValue());
        ps.format("%nNumber of samples used for GWR%n", new Object[0]);
        ps.format("Mean:    %12.6f%n", tabSampleCount.getMeanAbsValue());
        ps.format("Std Dev: %12.6f%n", tabSampleCount.getStdDevAbsValue());
        ps.println("Example application processing complete.");
    }
}

