/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.performance;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIntegrityCheck;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.IDevelopmentTest;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.demo.utils.VertexLoader;
import org.tinfour.utils.Tincalc;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;

public class SingleBuildTest
implements IDevelopmentTest {
    static String[] mandatoryOptions = new String[]{"-in"};

    public static void main(String[] args) {
        SingleBuildTest test = new SingleBuildTest();
        try {
            test.runTest(System.out, args);
        }
        catch (IOException | IllegalArgumentException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void runTest(PrintStream ps, String[] args) throws IOException {
        long time1;
        if (args.length == 0) {
            ps.println("usage: TestSingleBuild");
            ps.println("   Mandatory Arguments:");
            ps.println("       -in <valid LAS, CSV, or TXT file>");
            ps.println("   Optional Arguments:");
            ps.println("       -lidarClass      value in the range 0 to 255, defaults to not applied");
            ps.println("       -lidarThinning   thinnging factor, range 0 to 1.0, defaults to not applied");
            ps.println("       -clip            xmin, xmax, ymin, ymax");
            ps.println("       -prealloc, -noPrealloc  boolean, default noPreAlloc");
            ps.println("       -preSort,  -noPreSort   boolean, dfault noPreSort");
            return;
        }
        TestOptions options = new TestOptions();
        boolean[] optionsMatched = options.argumentScan(args);
        options.checkForUnrecognizedArgument(args, optionsMatched);
        options.checkForMandatoryOptions(args, mandatoryOptions);
        File target = options.getInputFile();
        boolean usePreSort = options.isPreSortEnabled(false);
        boolean usePreAlloc = options.isPreAllocateEnabled(false);
        Locale locale = Locale.getDefault();
        Date date = new Date();
        SimpleDateFormat sdFormat = new SimpleDateFormat("dd MMM yyyy HH:mm", locale);
        sdFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        Class<?> tinClass = options.getTinClass();
        long mem0 = this.getUsedMemory();
        VertexLoader loader = new VertexLoader();
        List<Vertex> vertexList = loader.readInputFile(options);
        double timeForPreSort = loader.getTimeForPreSort();
        ps.println("");
        ps.println("Date of Test: " + sdFormat.format(date) + " UTC");
        ps.println("TIN class:    " + tinClass.getName());
        ps.println("Input File:   " + target);
        ps.println("Number of vertices in file (all classes): " + loader.getNumberOfVerticesInFile());
        int nVertices = vertexList.size();
        ps.format("Number of vertices to process: %8d%n", nVertices);
        double xmin = loader.getXMin();
        double xmax = loader.getXMax();
        double ymin = loader.getYMin();
        double ymax = loader.getYMax();
        double zmin = loader.getZMin();
        double zmax = loader.getZMax();
        double area = (xmax - xmin) * (ymax - ymin);
        double sSpace = Tincalc.sampleSpacing((double)area, (int)nVertices);
        ICoordinateTransform cTrans = loader.getCoordinateTransform();
        if (cTrans != null) {
            CoordinatePair g0 = new CoordinatePair();
            CoordinatePair g1 = new CoordinatePair();
            cTrans.inverse(xmin, ymin, g0);
            cTrans.inverse(xmax, ymax, g1);
            double gx = g1.x - g0.x;
            double gy = g1.y - g0.y;
            double gArea = gx * gy;
            double gsSpace = Tincalc.sampleSpacing((double)gArea, (int)nVertices);
            ps.format("Source data horizontal coordinates were transformed%n", new Object[0]);
            if (loader.isSourceInGeographicCoordinates()) {
                ps.format("Geographic coordinates are mapped to projected coordinates%n", new Object[0]);
            }
            ps.format("Range x values:     %11.6f, %11.6f, (%f)%n", g0.x, g1.x, gx);
            ps.format("Range y values:     %11.6f, %11.6f, (%f)%n", g0.y, g1.y, gy);
            ps.format("Est. sample spacing:   %e degrees of arc%n", gsSpace);
        }
        ps.format("Range x values:     %12.3f, %12.3f, (%f)%n", xmin, xmax, xmax - xmin);
        ps.format("Range y values:     %12.3f, %12.3f, (%f)%n", ymin, ymax, ymax - ymin);
        ps.format("Range z values:     %12.3f, %12.3f, (%f)%n", zmin, zmax, zmax - zmin);
        ps.format("Est. sample spacing:%12.3f%n", sSpace);
        if (usePreSort) {
            ps.format("Time for pre-sort:          %8.2f%n", timeForPreSort);
        } else {
            ps.format("Pre-sort option is not used%n", new Object[0]);
        }
        loader = null;
        long mem1 = this.getUsedMemory();
        long vertexMemory = mem1 - mem0;
        long time0 = System.nanoTime();
        IIncrementalTin tin = options.getNewInstanceOfTestTin();
        long preAllocTime = 0L;
        if (usePreAlloc) {
            tin.preAllocateEdges(nVertices);
            time1 = System.nanoTime();
            preAllocTime = time1 - time0;
            ps.format("Time to pre-allocate edges: %8.2f%n", (double)preAllocTime / 1000000.0);
        } else {
            ps.format("Pre-alloc is not used%n", new Object[0]);
        }
        ps.println("Begin insertion");
        time0 = System.nanoTime();
        tin.add(vertexList, null);
        time1 = System.nanoTime();
        long buildTime = time1 - time0;
        ps.format("Time build TIN:             %8.2f%n", (double)buildTime / 1000000.0);
        ps.format("Total time for TIN:         %8.2f%n", (double)(buildTime + preAllocTime) / 1000000.0);
        ps.println("Checking memory");
        long mem2 = this.getUsedMemory();
        ps.println("");
        long tinMemory = mem2 - mem1;
        double bytesPerVertex = (double)(tinMemory + vertexMemory) / (double)nVertices;
        double verticesOnly = (double)vertexMemory / (double)nVertices;
        double tinOnly = (double)tinMemory / (double)nVertices;
        long totalMemory = Runtime.getRuntime().totalMemory();
        ps.println("Memory use (bytes/vertex) ");
        ps.format("   All objects:              %6.2f%n", bytesPerVertex);
        ps.format("   Vertices only:            %6.2f%n", verticesOnly);
        ps.format("   Edges and other elements: %6.2f%n", tinOnly);
        ps.format("%n", new Object[0]);
        ps.format("Total for application (mb): %6.2f%n", (double)totalMemory / 1024.0 / 1024.0);
        ps.format("%n%n", new Object[0]);
        tin.printDiagnostics(System.out);
        ps.println("\nPerforming integrity check");
        IIntegrityCheck sane2 = tin.getIntegrityCheck();
        boolean status = sane2.inspect();
        if (!status) {
            ps.println("Integrity check failed " + sane2.getMessage());
            return;
        }
        ps.println("Integrity test passed");
        sane2.printSummary(ps);
        status = sane2.testGetVerticesAgainstInputList(vertexList);
        if (!status) {
            ps.println("Input/output vertex set don't match: " + sane2.getMessage());
            return;
        }
        ps.println("Input vertex set matches output");
        ps.println("Test complete");
        tin.dispose();
    }

    private long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return runtime.totalMemory() - runtime.freeMemory();
    }
}

