/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.demo.utils.InterpolationMethod;
import org.tinfour.demo.utils.TestPalette;
import org.tinfour.gwr.GwrTinInterpolator;
import org.tinfour.interpolation.IInterpolatorOverTin;
import org.tinfour.interpolation.NaturalNeighborInterpolator;
import org.tinfour.interpolation.TriangularFacetInterpolator;
import org.tinfour.standard.IncrementalTin;

public class TestOptions {
    private static final String virtualClassName = "org.tinfour.semivirtual.SemiVirtualIncrementalTin";
    private static final String standardClassName = "org.tinfour.standard.IncrementalTin";
    public static final String[] BUILT_IN_OPTIONS = new String[]{"-in", "-out", "-nRows", "-nColumns", "-nVertices", "-nTests", "-preSort", "-preAllocate", "-maxVertices", "-seed", "-lidarClass", "-lidarReturn", "-lidarThinning", "-clip", "-frame", "-tinClass", "-geo", "-delimiter", "-palette", "-interpolator", "-imageSize", "-dbfField", "-plot"};
    File inputFile;
    File outputFile;
    File constraintsFile;
    Integer nVertices;
    Integer nRows;
    Integer nColumns;
    Integer nTests;
    Integer lidarClass;
    String lidarReturn;
    Double lidarThinning;
    Long maxVertices;
    Long randomSeed;
    Boolean preSort;
    Boolean preAllocate;
    double[] clipBounds;
    double[] frame;
    String tinClassName;
    Class<?> tinClass;
    TestPalette palette;
    GeoCoordinateOption geoCoordOption;
    String delimiter;
    String interpolator;
    InterpolationMethod interpolationMethod;
    int[] imageSize;
    String dbfField;
    Boolean plot;

    private boolean isOption(String s) {
        char c = s.charAt(0);
        return c == '-' || c == '+';
    }

    private void checkOptions() {
        if (this.inputFile != null) {
            if (!this.inputFile.exists()) {
                throw new IllegalArgumentException("Input file does not exist: " + this.inputFile.getPath());
            }
            if (!this.inputFile.canRead()) {
                throw new IllegalArgumentException("Unable to access input file: " + this.inputFile.getPath());
            }
        }
        if (this.tinClassName != null) {
            if ("virtual".equalsIgnoreCase(this.tinClassName)) {
                this.tinClassName = virtualClassName;
            } else if ("semivirtual".equalsIgnoreCase(this.tinClassName)) {
                this.tinClassName = virtualClassName;
            } else if ("standard".equalsIgnoreCase(this.tinClassName)) {
                this.tinClassName = standardClassName;
            }
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                this.tinClass = classLoader.loadClass(this.tinClassName);
                if (!IIncrementalTin.class.isAssignableFrom(this.tinClass)) {
                    throw new IllegalArgumentException("Test Class " + this.tinClass.getName() + " is not instance of " + IIncrementalTin.class.getName());
                }
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Test class not found: " + this.tinClassName, ex);
            }
        }
        if (this.delimiter != null && this.delimiter.length() != 1) {
            throw new IllegalArgumentException("Delimiter must be a single character");
        }
    }

    public Integer scanIntOption(String[] args, String option, boolean[] matched, Integer defaultValue) throws IllegalArgumentException {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(option)) continue;
            if (i == args.length - 1) {
                throw new IllegalArgumentException("Missing argument for " + option);
            }
            try {
                if (matched != null && matched.length == args.length) {
                    matched[i] = true;
                    matched[i + 1] = true;
                }
                return Integer.parseInt(args[i + 1]);
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Illegal integer value for " + option + ", " + nex.getMessage(), nex);
            }
        }
        return defaultValue;
    }

    public Long scanLongOption(String[] args, String option, boolean[] matched) throws IllegalArgumentException {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(option)) continue;
            if (i == args.length - 1) {
                throw new IllegalArgumentException("Missing argument for " + option);
            }
            try {
                if (matched != null && matched.length == args.length) {
                    matched[i] = true;
                    matched[i + 1] = true;
                }
                return Long.parseLong(args[i + 1]);
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Illegal integer value for " + option + ", " + nex.getMessage(), nex);
            }
        }
        return null;
    }

    public Double scanDoubleOption(String[] args, String option, boolean[] matched) throws IllegalArgumentException {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(option)) continue;
            if (i == args.length - 1) {
                throw new IllegalArgumentException("Missing argument for " + option);
            }
            try {
                if (matched != null && matched.length == args.length) {
                    matched[i] = true;
                    matched[i + 1] = true;
                }
                return Double.parseDouble(args[i + 1]);
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Illegal floating-point value for " + option + ", " + nex.getMessage(), nex);
            }
        }
        return null;
    }

    public Boolean scanBooleanOption(String[] args, String option, boolean[] matched, Boolean defaultValue) {
        String notOption = "-no" + option.substring(1, option.length());
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase(option)) {
                if (matched != null && matched.length == args.length) {
                    matched[i] = true;
                }
                return true;
            }
            if (!args[i].equalsIgnoreCase(notOption)) continue;
            if (matched != null && matched.length == args.length) {
                matched[i] = true;
            }
            return false;
        }
        return defaultValue;
    }

    public String scanStringOption(String[] args, String option, boolean[] matched) throws IllegalArgumentException {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(option)) continue;
            if (i == args.length - 1) {
                throw new IllegalArgumentException("Missing argument for " + option);
            }
            if (matched != null && matched.length == args.length) {
                matched[i] = true;
                matched[i + 1] = true;
            }
            return args[i + 1];
        }
        return null;
    }

    public double[] scanBounds(String[] args, String option, boolean[] matched) {
        double[] a = new double[4];
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(option)) continue;
            if (i > args.length - 5) {
                throw new IllegalArgumentException("Fewer than 4 arguments where bounds specified for argument " + i);
            }
            matched[i] = true;
            for (int j = 0; j < 4; ++j) {
                int index = i + 1 + j;
                matched[index] = true;
                String s = args[index];
                try {
                    a[j] = Double.parseDouble(s);
                    continue;
                }
                catch (NumberFormatException nex) {
                    throw new IllegalArgumentException("Illegal floating-point value for " + option + ", argument " + s + ", " + nex.getMessage(), nex);
                }
            }
            if (a[0] >= a[1] || a[2] >= a[3]) {
                throw new IllegalArgumentException("Values for " + option + " should be minX maxX minY maxY");
            }
            return a;
        }
        return new double[0];
    }

    public int[] scanSizeOption(String[] args, String option, boolean[] matched) throws IllegalArgumentException {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(option)) continue;
            if (i == args.length - 1) {
                throw new IllegalArgumentException("Missing argument for " + option);
            }
            try {
                String s;
                int index;
                if (matched != null && matched.length == args.length) {
                    matched[i] = true;
                    matched[i + 1] = true;
                }
                if ((index = (s = args[i + 1]).indexOf("x")) < 0) {
                    index = s.indexOf(",");
                }
                if (index <= 1 || index == s.length() - 1) {
                    throw new IllegalArgumentException("Invalid entry where size specificaiton expected: " + s);
                }
                int[] result = new int[]{Integer.parseInt(s.substring(0, index)), Integer.parseInt(s.substring(index + 1, s.length()))};
                if (result[0] < 1 || result[1] < 1) {
                    throw new IllegalArgumentException("Invalid numeric values for size specification: " + s);
                }
                return result;
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Illegal integer size value for " + option + ", " + nex.getMessage(), nex);
            }
        }
        return new int[0];
    }

    private void checkForValidArgsArray(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Null argument array not allowed");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null && args[i].length() != 0) continue;
            throw new IllegalArgumentException("Null or zero-length argument at index " + i);
        }
    }

    public String getFileExtension(File file) {
        String name;
        int i;
        if (file != null && (i = (name = file.getName()).lastIndexOf(46)) > 0 && i < name.length() - 1) {
            return name.substring(i + 1, name.length());
        }
        return null;
    }

    public boolean[] argumentScan(String[] args) {
        String geoCoordOptionString;
        String constraintsFileName;
        String outputFileName;
        this.checkForValidArgsArray(args);
        boolean[] matched = new boolean[args.length];
        if (args.length == 0) {
            return matched;
        }
        if (args.length == 1 && !this.isOption(args[0])) {
            String inputFileName = args[0];
            matched[0] = true;
            this.inputFile = new File(inputFileName);
            this.checkOptions();
            return matched;
        }
        String inputFileName = this.scanStringOption(args, "-in", matched);
        if (inputFileName != null) {
            this.inputFile = new File(inputFileName);
        }
        if ((outputFileName = this.scanStringOption(args, "-out", matched)) != null) {
            this.outputFile = new File(outputFileName);
        }
        if ((constraintsFileName = this.scanStringOption(args, "-constraints", matched)) != null) {
            this.constraintsFile = new File(constraintsFileName);
        }
        this.nRows = this.scanIntOption(args, "-nRows", matched, null);
        this.nColumns = this.scanIntOption(args, "-nColumns", matched, null);
        this.nVertices = this.scanIntOption(args, "-nVertices", matched, null);
        this.nTests = this.scanIntOption(args, "-nTests", matched, null);
        this.preSort = this.scanBooleanOption(args, "-preSort", matched, this.preSort);
        this.preAllocate = this.scanBooleanOption(args, "-preAllocate", matched, this.preAllocate);
        this.maxVertices = this.scanLongOption(args, "-maxVertices", matched);
        this.randomSeed = this.scanLongOption(args, "-seed", matched);
        this.lidarClass = this.scanIntOption(args, "-lidarClass", matched, this.lidarClass);
        this.lidarReturn = this.scanStringOption(args, "-lidarReturn", matched);
        this.lidarThinning = this.scanDoubleOption(args, "-lidarThinning", matched);
        if (this.lidarReturn != null) {
            switch (this.lidarReturn.toLowerCase()) {
                case "first": {
                    this.lidarReturn = "First";
                    break;
                }
                case "last": {
                    this.lidarReturn = "Last";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid lidar return specification " + this.lidarReturn);
                }
            }
        }
        this.clipBounds = this.scanBounds(args, "-clip", matched);
        this.frame = this.scanBounds(args, "-frame", matched);
        this.imageSize = this.scanSizeOption(args, "-imageSize", matched);
        this.tinClassName = this.scanStringOption(args, "-tinClass", matched);
        String paletteName = this.scanStringOption(args, "-palette", matched);
        this.delimiter = this.scanStringOption(args, "-delimiter", matched);
        this.checkOptions();
        if (paletteName != null) {
            this.palette = TestPalette.getPaletteByName(paletteName);
            if (this.palette == null) {
                throw new IllegalArgumentException("Unrecognized palette \"" + paletteName + "\"");
            }
        }
        if ((geoCoordOptionString = this.scanStringOption(args, "-geo", matched)) != null) {
            if ("Meters".equalsIgnoreCase(geoCoordOptionString)) {
                this.geoCoordOption = GeoCoordinateOption.Meters;
            } else if ("Feet".equalsIgnoreCase(geoCoordOptionString)) {
                this.geoCoordOption = GeoCoordinateOption.Feet;
            } else if ("Degrees".equalsIgnoreCase(geoCoordOptionString)) {
                this.geoCoordOption = GeoCoordinateOption.Degrees;
            } else {
                throw new IllegalArgumentException("Invalid specification for -geo option, must be Meters, Feet, or Degrees (not recommended)");
            }
        }
        this.interpolator = this.scanStringOption(args, "-interpolator", matched);
        if (this.interpolator != null) {
            this.interpolationMethod = InterpolationMethod.lenientValue(this.interpolator);
            if (this.interpolationMethod == null) {
                String gripe = "Invalid specification for -interpolator option \"" + this.interpolator + "\"";
                throw new IllegalArgumentException(gripe);
            }
        }
        this.dbfField = this.scanStringOption(args, "-dbfField", matched);
        this.plot = this.scanBooleanOption(args, "-plot", matched, this.plot);
        return matched;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public String getInputFileRootString() {
        if (this.inputFile == null) {
            return null;
        }
        String path = this.inputFile.getPath();
        int index = path.lastIndexOf(46);
        if (index == -1) {
            return path;
        }
        return path.substring(0, index);
    }

    public int getRowCount(int defaultCount) {
        if (this.nRows == null) {
            return defaultCount;
        }
        return this.nRows;
    }

    public int getColumnCount(int defaultCount) {
        if (this.nColumns == null) {
            return defaultCount;
        }
        return this.nColumns;
    }

    public int getVertexCount(int defaultCount) {
        if (this.nVertices == null) {
            return defaultCount;
        }
        return this.nVertices;
    }

    public int getTestCount(int defaultCount) {
        if (this.nTests == null) {
            return defaultCount;
        }
        return this.nTests;
    }

    public long getMaxVertices(long defaultMax) {
        if (this.maxVertices == null) {
            return defaultMax;
        }
        return this.maxVertices;
    }

    public long getRandomSeed(long defaultSeed) {
        if (this.randomSeed == null) {
            return defaultSeed;
        }
        return this.randomSeed;
    }

    public boolean isPreSortEnabled(boolean defaultEnabled) {
        if (this.preSort == null) {
            return defaultEnabled;
        }
        return this.preSort;
    }

    void setPreSortEnabled(boolean enablePreSort) {
        this.preSort = enablePreSort;
    }

    public boolean isPreAllocateEnabled(boolean defaultEnabled) {
        if (this.preAllocate == null) {
            return defaultEnabled;
        }
        return this.preAllocate;
    }

    public void checkForUnrecognizedArgument(String[] args, boolean[] matched) {
        int i;
        this.checkForValidArgsArray(args);
        if (matched == null || matched.length < args.length) {
            throw new IllegalArgumentException("Implementation error: matched array must correspond to args array");
        }
        for (i = 0; i < args.length; ++i) {
            if (!this.isOption(args[i]) || matched[i]) continue;
            throw new IllegalArgumentException("Unrecognized argument " + args[i]);
        }
        for (i = 0; i < args.length; ++i) {
            if (matched[i]) continue;
            throw new IllegalArgumentException("Unrecognized argument " + args[i]);
        }
    }

    public void checkForMandatoryOptions(String[] args, String[] options) {
        for (String s : options) {
            if (!"-in".equalsIgnoreCase(s) || this.inputFile != null) continue;
            boolean found = false;
            for (String t : args) {
                if (!s.equalsIgnoreCase(t)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Missing mandatory setting for " + s);
        }
    }

    public int getLidarClass() {
        if (this.lidarClass == null) {
            return -1;
        }
        return this.lidarClass;
    }

    public String getLidarReturn() {
        return this.lidarReturn;
    }

    public void setLidarClass(int classification) {
        if (classification < -1 || classification > 255) {
            throw new IllegalArgumentException("Lidar classification must be in range 0 to 255  (0 to 15 is commonly used)");
        }
        this.lidarClass = classification;
    }

    public double getLidarThinningFactor() {
        if (this.lidarThinning == null) {
            return 1.0;
        }
        return this.lidarThinning;
    }

    public double[] getClipBounds() {
        if (this.clipBounds == null) {
            return new double[0];
        }
        return Arrays.copyOf(this.clipBounds, this.clipBounds.length);
    }

    public boolean isClipSet() {
        return this.clipBounds != null && this.clipBounds.length == 4;
    }

    public boolean isFrameSet() {
        return this.frame != null && this.frame.length == 4;
    }

    public double[] getFrame() {
        if (this.frame == null) {
            return new double[0];
        }
        return Arrays.copyOf(this.frame, 4);
    }

    public int[] getImageSize(int defaultWidth, int defaultHeight) {
        if (this.imageSize != null && this.imageSize.length == 2) {
            return Arrays.copyOf(this.imageSize, 2);
        }
        return new int[]{defaultWidth, defaultHeight};
    }

    public boolean isTinClassSet() {
        return this.tinClass != null;
    }

    public Class<?> getTinClass() {
        if (this.tinClass == null) {
            return IncrementalTin.class;
        }
        return this.tinClass;
    }

    public IIncrementalTin getNewInstanceOfTestTin() {
        if (this.tinClass == null) {
            return new IncrementalTin();
        }
        Constructor<?> constructor = null;
        try {
            constructor = this.tinClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalArgumentException("No-argument constructor not available for " + this.tinClass.getName(), ex);
        }
        try {
            return (IIncrementalTin)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            throw new IllegalArgumentException("Unable to instantiate class " + this.tinClass.getName(), ex);
        }
    }

    public boolean isPaletteSet() {
        return this.palette != null;
    }

    public TestPalette getPalette() {
        if (this.isPaletteSet()) {
            return this.palette;
        }
        return TestPalette.getDefaultPalette();
    }

    public GeoCoordinateOption getGeoCoordinateOption() {
        return this.geoCoordOption;
    }

    public char getDelimiter() {
        if (this.delimiter == null) {
            return '\u0000';
        }
        return this.delimiter.charAt(0);
    }

    public IInterpolatorOverTin getInterpolator(IIncrementalTin tin) {
        switch (this.interpolationMethod) {
            case TriangularFacet: {
                return new TriangularFacetInterpolator(tin);
            }
            case GeographicallyWeightedRegression: {
                return new GwrTinInterpolator(tin);
            }
        }
        return new NaturalNeighborInterpolator(tin);
    }

    public InterpolationMethod getInterpolationMethod() {
        if (this.interpolationMethod == null) {
            return InterpolationMethod.NaturalNeighbor;
        }
        return this.interpolationMethod;
    }

    public File getConstraintsFile() {
        return this.constraintsFile;
    }

    String getDbfField() {
        return this.dbfField;
    }

    public boolean isPlotEnabled(boolean defaultEnabled) {
        if (this.plot == null) {
            return defaultEnabled;
        }
        return this.plot;
    }

    public static enum GeoCoordinateOption {
        Meters,
        Feet,
        Degrees;

    }
}

