/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.TestPalette;

public class TinRenderingUtility {
    public AffineTransform initTransform(int width, int height, double x0, double x1, double y0, double y1) {
        double rImage = (double)width / (double)height;
        double rData = (x1 - x0) / (y1 - y0);
        double rAspect = rImage / rData;
        double uPerPixel = rAspect >= 1.0 ? (y1 - y0) / (double)height : (x1 - x0) / (double)width;
        double scale = 1.0 / uPerPixel;
        double xCenter = (x0 + x1) / 2.0;
        double yCenter = (y0 + y1) / 2.0;
        double xOffset = (double)(width / 2) - scale * xCenter;
        double yOffset = (double)(height / 2) + scale * yCenter;
        AffineTransform af = new AffineTransform(scale, 0.0, 0.0, -scale, xOffset, yOffset);
        try {
            af.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            throw new IllegalArgumentException("Input elements result in a degenerate transform: " + ex.getMessage(), ex);
        }
        return af;
    }

    private boolean inBounds(Vertex p, double x0, double x1, double y0, double y1) {
        double x = p.getX();
        double y = p.getY();
        return x0 <= x && x <= x1 && y0 <= y && y <= y1;
    }

    public BufferedImage render(AffineTransform af, int width, int height, double x0, double x1, double y0, double y1, double zMin, double zMax, Color background, Color foreground, TestPalette palette, IIncrementalTin tin) {
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = bImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(background);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(foreground);
        Point2D.Double llCorner = new Point2D.Double(x0, y0);
        Point2D.Double urCorner = new Point2D.Double(x1, y1);
        af.transform(llCorner, llCorner);
        af.transform(urCorner, urCorner);
        Rectangle2D.Double clipBounds = new Rectangle2D.Double(((Point2D)llCorner).getX(), ((Point2D)urCorner).getY(), ((Point2D)urCorner).getX() - ((Point2D)llCorner).getX(), ((Point2D)llCorner).getY() - ((Point2D)urCorner).getY());
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.draw(clipBounds);
        g2d.setClip(clipBounds);
        Point2D.Double p0 = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        Line2D.Double l2d = new Line2D.Double();
        Ellipse2D.Double e2d = new Ellipse2D.Double();
        g2d.setStroke(new BasicStroke(2.0f));
        List edges = tin.getEdges();
        for (IQuadEdge edge : edges) {
            Vertex v0 = edge.getA();
            Vertex v1 = edge.getB();
            if (v0 == null || v1 == null || !this.inBounds(v0, x0, x1, y0, y1) && !this.inBounds(v1, x0, x1, y0, y1)) continue;
            ((Point2D)p0).setLocation(v0.getX(), v0.getY());
            ((Point2D)p1).setLocation(v1.getX(), v1.getY());
            af.transform(p0, p0);
            af.transform(p1, p1);
            l2d.setLine(p0, p1);
            double z0 = v0.getZ();
            double z1 = v1.getZ();
            if (palette != null) {
                Color c0 = palette.getColor(z0, zMin, zMax);
                Color c1 = palette.getColor(z1, zMin, zMax);
                GradientPaint paint = new GradientPaint((float)v0.getX(), (float)v0.getY(), c0, (float)v1.getX(), (float)v1.getY(), c1);
                g2d.setPaint(paint);
            }
            g2d.draw(l2d);
        }
        List vertexList = tin.getVertices();
        g2d.setStroke(new BasicStroke(1.0f));
        for (Vertex v : vertexList) {
            if (!this.inBounds(v, x0, x1, y0, y1)) continue;
            ((Point2D)p0).setLocation(v.getX(), v.getY());
            double z = v.getZ();
            if (palette != null) {
                Color c = palette.getColor(z, zMin, zMax);
                g2d.setColor(c);
            }
            af.transform(p0, p1);
            ((RectangularShape)e2d).setFrame(((Point2D)p1).getX() - 2.0, ((Point2D)p1).getY() - 2.0, 6.0, 6.0);
            g2d.fill(e2d);
            g2d.draw(e2d);
        }
        g2d.setColor(foreground);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.setClip(null);
        g2d.draw(clipBounds);
        g2d.dispose();
        return bImage;
    }

    public static void drawTin(IIncrementalTin tin, int width, int height, File file) throws IOException {
        Rectangle2D r2d = tin.getBounds();
        double x0 = r2d.getMinX();
        double x1 = r2d.getMaxX();
        double y0 = r2d.getMinY();
        double y1 = r2d.getMaxY();
        if (r2d == null) {
            throw new IllegalArgumentException("Input TIN is not bootstrapped");
        }
        TinRenderingUtility tru = new TinRenderingUtility();
        AffineTransform af = tru.initTransform(width, height, x0, x1, y0, y1);
        BufferedImage bImage = tru.render(af, width, height, x0, x1, y0, y1, y1, y1, Color.white, Color.darkGray, null, tin);
        String s = file.getName();
        int i = s.lastIndexOf(".");
        String fmt = null;
        if (i > 0) {
            fmt = s.substring(i + 1, s.length());
            fmt = "png".equalsIgnoreCase(fmt) ? "PNG" : ("jpg".equalsIgnoreCase(fmt) ? "JPEG" : ("jepg".equalsIgnoreCase(fmt) ? "JPEG" : ("gif".equalsIgnoreCase(fmt) ? "GIF" : null)));
        }
        if (fmt == null) {
            fmt = "PNG";
        }
        ImageIO.write((RenderedImage)bImage, fmt, file);
    }
}

