/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.gis.las.ILasRecordFilter;
import org.tinfour.gis.las.LasPoint;
import org.tinfour.gis.las.LasRecordFilterByFirstReturn;
import org.tinfour.gis.las.LasRecordFilterByLastReturn;
import org.tinfour.gis.utils.VertexReaderLas;
import org.tinfour.gis.utils.VertexReaderShapefile;
import org.tinfour.utils.HilbertSort;
import org.tinfour.utils.LinearUnits;
import org.tinfour.utils.loaders.ICoordinateTransform;
import org.tinfour.utils.loaders.VertexReaderText;

public class VertexLoader {
    static final double eRadius = 6378137.0;
    static final double eFlattening = 0.003352810664781205;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double zMin;
    double zMax;
    long maximumNumberOfVertices = Integer.MAX_VALUE;
    long numberOfVerticesInSource;
    boolean hilbertSortEnabled;
    double timeForSort;
    double timeForLoad;
    boolean isClippingSet;
    double xClipMin;
    double xClipMax;
    double yClipMin;
    double yClipMax;
    boolean isSourceInGeographicCoordinates;
    ICoordinateTransform coordinateTransform;
    TestOptions.GeoCoordinateOption geoCoordOpt;
    LinearUnits linearUnits = LinearUnits.UNKNOWN;

    public void setMaximumNumberOfVertices(long maxN) {
        this.maximumNumberOfVertices = maxN;
    }

    public void setPreSortEnabed(boolean enabled) {
        this.hilbertSortEnabled = enabled;
    }

    public List<Vertex> readInputFile(TestOptions options) throws IOException {
        this.geoCoordOpt = options.getGeoCoordinateOption();
        this.hilbertSortEnabled = options.isPreSortEnabled(this.hilbertSortEnabled);
        File file = options.getInputFile();
        if (file == null) {
            throw new IllegalArgumentException("Missing specification for input file");
        }
        String ext = options.getFileExtension(file);
        ext = ext == null ? "text" : ext.toLowerCase();
        VertexReaderText reader = null;
        List list = null;
        if ("csv".equals(ext)) {
            try (VertexReaderText textReader = new VertexReaderText(file);){
                reader = textReader;
                list = reader.read(null);
            }
        }
        if ("txt".equals(ext)) {
            try (VertexReaderText textReader = new VertexReaderText(file);){
                reader = textReader;
                char delimiter = options.getDelimiter();
                if (delimiter != '\u0000') {
                    reader.setDelimiter(delimiter);
                }
                list = reader.read(null);
            }
        }
        if ("shp".equals(ext)) {
            try (VertexReaderShapefile sReader = new VertexReaderShapefile(file);){
                String dbfField = options.getDbfField();
                if (dbfField != null) {
                    sReader.setDbfFieldForZ(dbfField);
                }
                reader = sReader;
                list = sReader.read(null);
            }
        }
        if ("las".equals(ext) || "laz".equals(ext)) {
            try (VertexReaderLas lasReader = new VertexReaderLas(file);){
                double tv;
                reader = lasReader;
                long nRecords = lasReader.getNumberOfVerticesInSource();
                this.linearUnits = lasReader.getLinearUnits();
                int lidarClass = options.getLidarClass();
                String lidarReturn = options.getLidarReturn();
                double thinning = options.getLidarThinningFactor();
                this.maximumNumberOfVertices = options.getMaxVertices(Long.MAX_VALUE);
                if (this.maximumNumberOfVertices < Long.MAX_VALUE && nRecords > this.maximumNumberOfVertices && (tv = (double)this.maximumNumberOfVertices / (double)nRecords) < thinning) {
                    thinning = tv;
                }
                double[] clipBounds = options.getClipBounds();
                Object filter = "First".equals(lidarReturn) ? new LasRecordFilterByFirstReturn() : ("Last".equals(lidarReturn) ? new LasRecordFilterByLastReturn() : (lidarClass == -1 && thinning == 1.0 && clipBounds == null ? new ILasRecordFilter(){

                    public boolean accept(LasPoint record) {
                        return !record.withheld;
                    }
                } : new ThinningClassificationFilter(lidarClass, thinning, clipBounds)));
                lasReader.setFilter((ILasRecordFilter)filter);
                list = lasReader.read(null);
            }
        }
        if (list == null || reader == null) {
            throw new IOException("Unable to obtain vertices from input " + file.getPath());
        }
        this.isSourceInGeographicCoordinates = reader.isSourceInGeographicCoordinates();
        this.coordinateTransform = reader.getCoordinateTransform();
        this.postProcessList(list);
        return list;
    }

    private void postProcessList(List<Vertex> list) {
        if (list.isEmpty()) {
            this.xMin = Double.NaN;
            this.xMax = Double.NaN;
            this.yMin = Double.NaN;
            this.yMax = Double.NaN;
            this.zMin = Double.NaN;
            this.zMax = Double.NaN;
            return;
        }
        Vertex v = list.get(0);
        this.xMax = this.xMin = v.getX();
        this.yMax = this.yMin = v.getY();
        this.zMax = this.zMin = v.getZ();
        for (Vertex vertex : list) {
            double x = vertex.getX();
            double y = vertex.getY();
            double z = vertex.getZ();
            if (x < this.xMin) {
                this.xMin = x;
            } else if (x > this.xMax) {
                this.xMax = x;
            }
            if (y < this.yMin) {
                this.yMin = y;
            } else if (y > this.yMax) {
                this.yMax = y;
            }
            if (z < this.zMin) {
                this.zMin = z;
                continue;
            }
            if (!(z > this.zMax)) continue;
            this.zMax = z;
        }
        if (this.hilbertSortEnabled) {
            long time0 = System.nanoTime();
            HilbertSort hilbert = new HilbertSort();
            hilbert.sort(list);
            long time1 = System.nanoTime();
            this.timeForSort = (double)(time1 - time0) / 1000000.0;
        }
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getZMin() {
        return this.zMin;
    }

    public double getZMax() {
        return this.zMax;
    }

    public double getTimeForPreSort() {
        return this.timeForSort;
    }

    public double getTimeForLoad() {
        return this.timeForLoad;
    }

    public long getNumberOfVerticesInFile() {
        return this.numberOfVerticesInSource;
    }

    public void setClip(double xClipMin, double xClipMax, double yClipMin, double yClipMax) {
        this.isClippingSet = true;
        this.xClipMin = xClipMin;
        this.xClipMax = xClipMax;
        this.yClipMin = yClipMin;
        this.yClipMax = yClipMax;
    }

    public boolean isSourceInGeographicCoordinates() {
        return this.isSourceInGeographicCoordinates;
    }

    public LinearUnits getLinearUnits() {
        return this.linearUnits;
    }

    public ICoordinateTransform getCoordinateTransform() {
        return this.coordinateTransform;
    }

    private static class ThinningClassificationFilter
    implements ILasRecordFilter {
        int classification;
        double thinningFactor;
        double xClipMin;
        double xClipMax;
        double yClipMin;
        double yClipMax;
        boolean isClipBoundsSet;
        Random random = new Random();

        public ThinningClassificationFilter(int classification, double thinningFactor, double[] clipBounds) {
            this.classification = classification;
            this.thinningFactor = thinningFactor;
            if (clipBounds != null && clipBounds.length >= 4) {
                this.isClipBoundsSet = true;
                this.xClipMin = clipBounds[0];
                this.xClipMax = clipBounds[1];
                this.yClipMin = clipBounds[2];
                this.yClipMax = clipBounds[3];
            }
        }

        public boolean accept(LasPoint record) {
            if (record.withheld) {
                return false;
            }
            if (this.classification >= 0 && record.classification != this.classification) {
                return false;
            }
            if (this.isClipBoundsSet) {
                double x = record.x;
                double y = record.y;
                if (x < this.xClipMin || x > this.xClipMax || y < this.yClipMin || y > this.yClipMax) {
                    return false;
                }
            }
            if (this.thinningFactor < 1.0) {
                double test = this.random.nextDouble();
                return test < this.thinningFactor;
            }
            return true;
        }
    }
}

