/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Formatter;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.tinfour.demo.viewer.DataViewingPanel;
import org.tinfour.demo.viewer.ExportImage;
import org.tinfour.demo.viewer.ExportImageOptionsPanel;

public class ExportControl
extends JMenuItem {
    private JFileChooser fileChooser;
    private ExportImageOptionsPanel exportImageOptions;
    final JMenu fileMenu;
    File currentDirectory = new File(".");
    private static final String[] validExtensions = new String[]{"PNG", "GIF", "JPG", "JPEG"};

    private String getFileExtension(File file) {
        String name;
        int i;
        if (file != null && (i = (name = file.getName()).lastIndexOf(46)) > 0 && i < name.length() - 1) {
            return name.substring(i + 1, name.length());
        }
        return null;
    }

    ExportControl(final JMenu fileMenu, final DataViewingPanel dvPanel) {
        super("Export Image");
        this.fileMenu = fileMenu;
        this.setToolTipText("Save current display to an image");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportImage eImage;
                String name;
                int n;
                if (ExportControl.this.fileChooser == null) {
                    ExportControl.this.fileChooser = ExportControl.this.makeFileChooser();
                }
                int returnVal = ExportControl.this.fileChooser.showSaveDialog(fileMenu);
                String[] extensions = new String[]{};
                ExportControl.this.currentDirectory = ExportControl.this.fileChooser.getCurrentDirectory();
                if (returnVal != 0) {
                    return;
                }
                File file = ExportControl.this.fileChooser.getSelectedFile();
                FileFilter filter = ExportControl.this.fileChooser.getFileFilter();
                if (filter instanceof FileNameExtensionFilter) {
                    FileNameExtensionFilter fne = (FileNameExtensionFilter)filter;
                    extensions = fne.getExtensions();
                }
                String ext = ExportControl.this.getFileExtension(file);
                if (extensions.length == 0) {
                    for (String s : validExtensions) {
                        if (!s.equalsIgnoreCase(ext)) continue;
                        extensions = new String[]{ext};
                    }
                }
                if (extensions.length == 0) {
                    JOptionPane.showMessageDialog(ExportControl.this.fileChooser, "To save an image, you must select or specifya valid image format (file extension)", "Missing Format Extension", 0);
                    return;
                }
                boolean fileNameHasExtension = false;
                for (int i = 0; i < extensions.length; ++i) {
                    if (!extensions[i].equalsIgnoreCase(ext)) continue;
                    fileNameHasExtension = true;
                }
                if (!fileNameHasExtension) {
                    ext = extensions[0];
                    String path = file.getPath();
                    file = new File(path + "." + ext);
                }
                if (file.exists() && (n = JOptionPane.showConfirmDialog(ExportControl.this.fileChooser, "Do you wish to overwrite existing file " + (name = file.getName()) + "?", "Confirm replacement of existing file", 0)) != 0) {
                    return;
                }
                boolean transparentBackground = ExportControl.this.exportImageOptions.isTransparentBackgroundEnabled();
                boolean frameImage = ExportControl.this.exportImageOptions.isImageFrameEnabled();
                boolean writeWorldFile = ExportControl.this.exportImageOptions.isWorldFileEnabled();
                boolean jpegFlag = false;
                if ("jpg".equalsIgnoreCase(ext) || "jpeg".equalsIgnoreCase(ext)) {
                    jpegFlag = true;
                    transparentBackground = false;
                }
                if ((eImage = dvPanel.getRenderedImage(transparentBackground, frameImage)) == null) {
                    return;
                }
                BufferedImage bImage = eImage.bImage;
                if (jpegFlag) {
                    bImage = new BufferedImage(bImage.getWidth(), bImage.getHeight(), 1);
                    Graphics g = bImage.getGraphics();
                    g.drawImage(eImage.bImage, 0, 0, null);
                    g.dispose();
                }
                try {
                    ImageIO.write((RenderedImage)bImage, ext, file);
                }
                catch (IOException ioex) {
                    ioex.printStackTrace(System.out);
                }
                if (writeWorldFile) {
                    String wExt = null;
                    wExt = ext.equalsIgnoreCase("JPEG") || ext.equalsIgnoreCase("JPG") ? "jgw" : (ext.equalsIgnoreCase("PNG") ? "pgw" : "gfw");
                    Object path = file.getPath();
                    int i = ((String)path).lastIndexOf(46);
                    path = ((String)path).substring(0, i + 1) + wExt;
                    file = new File((String)path);
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        Formatter fmt = new Formatter(bos, "US-ASCII");
                        AffineTransform i2m = eImage.i2m;
                        fmt.format("%f%n", i2m.getScaleX());
                        fmt.format("0%n", new Object[0]);
                        fmt.format("0%n", new Object[0]);
                        fmt.format("%f%n", i2m.getScaleY());
                        fmt.format("%f%n", i2m.getTranslateX());
                        fmt.format("%f%n", i2m.getTranslateY());
                        fmt.flush();
                        bos.flush();
                    }
                    catch (IOException ioex) {
                        ioex.printStackTrace(System.out);
                    }
                }
            }
        });
    }

    private JFileChooser makeFileChooser() {
        this.fileChooser = new JFileChooser();
        this.exportImageOptions = new ExportImageOptionsPanel();
        this.fileChooser.setAccessory(this.exportImageOptions);
        FileNameExtensionFilter jpegFilter = new FileNameExtensionFilter("JPEG (.jpeg, .jpg)", "jpg", "jpeg");
        FileNameExtensionFilter gifFilter = new FileNameExtensionFilter("GIF (.gif)", "gif");
        FileNameExtensionFilter pngFilter = new FileNameExtensionFilter("PNG (.png)", "png");
        this.fileChooser.addChoosableFileFilter(jpegFilter);
        this.fileChooser.addChoosableFileFilter(pngFilter);
        this.fileChooser.addChoosableFileFilter(gifFilter);
        this.fileChooser.setFileFilter(jpegFilter);
        this.fileChooser.setDialogTitle("Specify a path for exporting the image");
        return this.fileChooser;
    }
}

