/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

class ScaleIntervals {
    private static final double LN10 = Math.log(10.0);
    private static final double[][] divisions = new double[][]{{0.0, 0.0}, {0.5, 0.1}, {1.0, 0.5}, {1.0, 0.5}, {2.0, 1.0}, {5.0, 1.0}, {0.0, 0.0}, {0.0, 0.0}, {4.0, 2.0}, {0.0, 0.0}};
    final int maxSizeInPixels;
    final double maxValue;
    final double[][] cTics;
    final double[] cLabels;
    final double unitsPerPixel;
    final String labelFormat;

    ScaleIntervals(int maxSizeInPixels, double maxValue, double[][] cTics, double[] cLabels, double unitsPerPixel, String labelFormat) {
        this.maxSizeInPixels = maxSizeInPixels;
        this.maxValue = maxValue;
        this.cTics = (double[][])Arrays.copyOf(cTics, cTics.length);
        this.cLabels = Arrays.copyOf(cLabels, cLabels.length);
        this.unitsPerPixel = unitsPerPixel;
        this.labelFormat = labelFormat;
    }

    double getMaxValue() {
        return this.maxValue;
    }

    double[][] getTicCoordinates() {
        double[][] d = new double[this.cTics.length][];
        for (int i = 0; i < this.cTics.length; ++i) {
            d[i] = Arrays.copyOf(this.cTics[i], this.cTics[i].length);
        }
        return d;
    }

    double[] getLabelCoordinates() {
        return Arrays.copyOf(this.cLabels, this.cLabels.length);
    }

    String[] getLabels() {
        String[] a = new String[this.cLabels.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = String.format(this.labelFormat, this.cLabels[i]);
        }
        return a;
    }

    String getLabelFormat() {
        return this.labelFormat;
    }

    double getCoordinateScale() {
        return 1.0 / this.unitsPerPixel;
    }

    private void drawLines(Graphics2D g2d, int x0, int y0, double extra) {
        Line2D.Double l2d = new Line2D.Double();
        for (int iDraw = 0; iDraw < 2; ++iDraw) {
            ((Line2D)l2d).setLine((double)x0 + extra, y0, (double)(x0 + this.maxSizeInPixels) - extra, y0);
            g2d.draw(l2d);
            for (int iTicSet = 0; iTicSet < this.cTics.length; ++iTicSet) {
                double ticSize = 10.0;
                if (iTicSet == 1) {
                    ticSize /= 2.0;
                }
                for (int i = 0; i < this.cTics[iTicSet].length; ++i) {
                    double x = (double)x0 + extra + this.cTics[iTicSet][i] / this.unitsPerPixel;
                    ((Line2D)l2d).setLine(x, y0, x, (double)y0 - ticSize);
                    g2d.draw(l2d);
                }
            }
        }
    }

    void render(Graphics g, int x0, int y0, Font font, Color color, Color relief) {
        Graphics2D g2d = (Graphics2D)g;
        BasicStroke thin = new BasicStroke(1.0f);
        BasicStroke fat = new BasicStroke(3.0f);
        double extra = ((double)this.maxSizeInPixels - this.maxValue / this.unitsPerPixel) / 2.0;
        if (relief != null) {
            g2d.setColor(relief);
            g2d.setStroke(fat);
            this.drawLines(g2d, x0, y0, extra);
        }
        g2d.setColor(color);
        g2d.setStroke(thin);
        this.drawLines(g2d, x0, y0, extra);
        BasicStroke outlineStroke = new BasicStroke(3.5f, 0, 2);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        String[] labels = this.getLabels();
        for (int i = 0; i < labels.length; ++i) {
            TextLayout layout = new TextLayout(labels[i], font, frc);
            Rectangle2D bounds = layout.getBounds();
            double x = (double)x0 + extra + this.cLabels[i] / this.unitsPerPixel - bounds.getCenterX();
            double y = (double)y0 + bounds.getHeight() + 5.0;
            if (relief != null) {
                Shape outline = layout.getOutline(AffineTransform.getTranslateInstance(x, y + 0.5));
                g2d.setStroke(outlineStroke);
                g2d.setColor(relief);
                g2d.draw(outline);
            }
            g2d.setStroke(thin);
            g2d.setColor(color);
            layout.draw(g2d, (float)x, (float)y);
        }
    }

    static ScaleIntervals computeIntervals(int maxSizeInPixels, int minGapInPixels, double unitsPerPixel) {
        double f;
        int n;
        double maxScale = (double)maxSizeInPixels * unitsPerPixel;
        double log10 = Math.log(maxScale) / LN10;
        double p10 = Math.floor(log10);
        double m10 = Math.exp(p10 * LN10);
        if (p10 > 0.0) {
            m10 = Math.floor(m10 + 1.0E-9);
        }
        if ((n = (int)Math.floor((f = Math.exp((log10 - p10) * LN10)) + 1.0E-9)) == 6 || n == 7) {
            n = 5;
        } else if (n == 9) {
            n = 8;
        } else if (n == 10) {
            f = 0.0;
            n = 1;
            p10 += 1.0;
            m10 *= 10.0;
        }
        double div1 = divisions[n][0] * m10;
        double div2 = divisions[n][1] * m10;
        double divPix1 = div1 / unitsPerPixel;
        double divPix2 = div2 / unitsPerPixel;
        int nDiv = divPix2 >= (double)minGapInPixels ? 2 : (divPix1 >= (double)minGapInPixels ? 1 : 0);
        double maxVal = (double)n * m10;
        if (n == 1 && f >= 1.5 && nDiv > 0) {
            maxVal = 1.5 * m10;
        }
        double[] xLabel = new double[]{};
        if (nDiv == 1) {
            xLabel = new double[]{0.0, (double)n * m10};
        } else if (nDiv == 2) {
            int nLabel = (int)Math.floor(maxVal / div1 + 1.0E-7) + 1;
            xLabel = new double[nLabel];
            for (int iLabel = 0; iLabel < nLabel; ++iLabel) {
                xLabel[iLabel] = (double)iLabel * div1;
            }
        }
        double[][] xTic = new double[nDiv][];
        if (nDiv > 0) {
            int nTic1 = (int)Math.floor(maxVal / div1 + 1.0E-7) + 1;
            xTic[0] = new double[nTic1];
            for (int i = 0; i < nTic1; ++i) {
                xTic[0][i] = (double)i * div1;
            }
            if (nDiv == 2) {
                int nTic2 = (int)Math.floor(maxVal / div2 + 1.0E-7) + 1;
                xTic[1] = new double[nTic2 - nTic1];
                int k = 0;
                double divMod = (int)Math.floor(divisions[n][0] / divisions[n][1] + 1.0E-7);
                for (int i = 0; i < nTic2; ++i) {
                    if ((double)i % divMod == 0.0) continue;
                    xTic[1][k++] = (double)i * div2;
                }
            }
        }
        int iPowerOfTen = (int)p10;
        Object labelFmt = "%f";
        if (iPowerOfTen == 0) {
            labelFmt = n == 1 && nDiv > 0 ? "%3.1f" : "%1.0f";
        } else if (iPowerOfTen > 0) {
            if (iPowerOfTen < 7) {
                labelFmt = "%1.0f";
            }
        } else if (iPowerOfTen < 0 && iPowerOfTen >= -3) {
            int nDecimals = -iPowerOfTen;
            if (n == 1 && nDiv > 0) {
                ++nDecimals;
            }
            labelFmt = "%" + (nDecimals + 2) + "." + nDecimals + "f";
        }
        return new ScaleIntervals(maxSizeInPixels, maxVal, xTic, xLabel, unitsPerPixel, (String)labelFmt);
    }
}

