/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.Container;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.demo.viewer.StatusPanel;

class StatusPanelMonitor
extends JProgressBar
implements IMonitorWithCancellation {
    private static final long serialVersionUID = 1L;
    private final StatusPanel statusPanel;
    private final int taskIndex;
    private boolean cancelled;

    private StatusPanelMonitor() {
        this.statusPanel = null;
        this.taskIndex = 0;
    }

    public StatusPanelMonitor(StatusPanel statusPanel, int taskIndex, int orient, int min, int max) {
        super(orient, min, max);
        this.statusPanel = statusPanel;
        this.taskIndex = taskIndex;
    }

    public int getReportingIntervalInPercent() {
        return 5;
    }

    public void reportProgress(final int percentComplete) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusPanelMonitor.this.setValue(percentComplete);
            }
        });
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
        this.reportDone();
    }

    public void reportDone() {
        final StatusPanelMonitor self = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container parent = StatusPanelMonitor.this.getParent();
                while (parent != null) {
                    if (parent instanceof StatusPanel) {
                        parent.remove(self);
                        return;
                    }
                    parent = StatusPanelMonitor.this.getParent();
                }
            }
        });
    }

    public void postMessage(String message) {
        this.statusPanel.postMessage(this.taskIndex, message);
    }
}

