/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.NearestEdgeResult;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.TestPalette;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.IModelViewTask;
import org.tinfour.demo.viewer.backplane.ModelFromLas;
import org.tinfour.demo.viewer.backplane.MvQueryResult;
import org.tinfour.demo.viewer.backplane.ViewOptions;
import org.tinfour.gwr.BandwidthSelectionMethod;
import org.tinfour.gwr.GwrTinInterpolator;
import org.tinfour.interpolation.NaturalNeighborInterpolator;
import org.tinfour.interpolation.TriangularFacetInterpolator;
import org.tinfour.regression.SurfaceModel;
import org.tinfour.utils.AxisIntervals;
import org.tinfour.utils.LinearUnits;

public class MvComposite {
    static final double tinMemoryUseFraction = 0.1;
    private static AtomicInteger serialIndexSource = new AtomicInteger();
    private final int serialIndex;
    private final int taskIndex;
    private final IModel model;
    private final ViewOptions view;
    private final int width;
    private final int height;
    AffineTransform m2c;
    AffineTransform c2m;
    private IIncrementalTin wireframeTin;
    private IIncrementalTin rasterTin;
    IIncrementalTin interpolatingTin;
    double reductionForInterpolatingTin = Double.POSITIVE_INFINITY;
    private int reductionForWireframe;
    private int reductionForRaster;
    private List<IConstraint> constraintsForRender;
    GwrTinInterpolator interpolator;
    IIncrementalTinNavigator navigator;
    double vx0;
    double vy0;
    double vx1;
    double vy1;
    double zVisMin = Double.POSITIVE_INFINITY;
    double zVisMax = Double.NEGATIVE_INFINITY;
    BufferedImage rasterImage;
    private long timeForRenderWireframe0;
    private long timeForRenderWireframe1;
    private int nVerticesInWireframe;
    private long timeForBuildRaster0;
    private long timeForBuildRaster1;
    boolean zGridComplete;
    boolean zGridIncludesHillshade;
    private float[] zGrid;
    private String modelAndRenderingReport;
    private Shape clipMask;

    private MvComposite() {
        this.taskIndex = 0;
        this.model = null;
        this.view = null;
        this.width = 0;
        this.height = 0;
        this.m2c = null;
        this.serialIndex = serialIndexSource.incrementAndGet();
    }

    public MvComposite(IModel model, ViewOptions view, int width, int height, AffineTransform m2c, AffineTransform c2m, int taskIndex) {
        if (model == null) {
            throw new IllegalArgumentException("Null model not allowed");
        }
        if (view == null) {
            throw new IllegalArgumentException("Null view not allowed");
        }
        this.taskIndex = taskIndex;
        this.width = width;
        this.height = height;
        this.m2c = m2c;
        this.c2m = c2m;
        this.model = model;
        this.view = view;
        this.serialIndex = serialIndexSource.incrementAndGet();
        double[] c = new double[8];
        c[0] = 0.0;
        c[1] = height;
        c[2] = width;
        c[3] = 0.0;
        c2m.transform(c, 0, c, 4, 2);
        this.vx0 = c[4];
        this.vy0 = c[5];
        this.vx1 = c[6];
        this.vy1 = c[7];
        if (model.isLoaded()) {
            this.interpolatingTin = model.getReferenceTin();
            this.reductionForInterpolatingTin = model.getReferenceReductionFactor();
            this.interpolator = new GwrTinInterpolator(this.interpolatingTin);
            this.navigator = this.interpolatingTin.getNavigator();
            this.applyRangeOfVisibleSamples(model.getVertexList());
        }
        this.updateReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MvComposite(MvComposite mvComposite, ViewOptions view, boolean preserveTins, int taskIndex) {
        MvComposite mvComposite2;
        this.taskIndex = taskIndex;
        this.width = mvComposite.width;
        this.height = mvComposite.height;
        this.m2c = mvComposite.m2c;
        this.c2m = mvComposite.c2m;
        this.model = mvComposite.model;
        if (preserveTins) {
            mvComposite2 = mvComposite;
            synchronized (mvComposite2) {
                this.reductionForWireframe = mvComposite.reductionForWireframe;
                this.reductionForRaster = mvComposite.reductionForRaster;
                this.reductionForInterpolatingTin = mvComposite.reductionForInterpolatingTin;
                this.wireframeTin = mvComposite.wireframeTin;
                this.rasterTin = mvComposite.rasterTin;
                this.interpolatingTin = mvComposite.interpolatingTin;
                this.interpolator = mvComposite.interpolator;
                this.timeForBuildRaster0 = mvComposite.timeForBuildRaster0;
                this.timeForBuildRaster1 = mvComposite.timeForBuildRaster1;
                this.navigator = mvComposite.navigator;
                this.constraintsForRender = mvComposite.constraintsForRender;
            }
        }
        this.view = view;
        this.modelAndRenderingReport = mvComposite.modelAndRenderingReport;
        this.serialIndex = serialIndexSource.incrementAndGet();
        mvComposite2 = mvComposite;
        synchronized (mvComposite2) {
            this.interpolatingTin = mvComposite.interpolatingTin;
            this.reductionForInterpolatingTin = mvComposite.reductionForInterpolatingTin;
            this.interpolator = new GwrTinInterpolator(this.interpolatingTin);
            this.navigator = this.interpolatingTin.getNavigator();
            this.zVisMin = mvComposite.zVisMin;
            this.zVisMax = mvComposite.zVisMax;
        }
        double[] c = new double[8];
        c[0] = 0.0;
        c[1] = this.height;
        c[2] = this.width;
        c[3] = 0.0;
        this.c2m.transform(c, 0, c, 4, 2);
        this.vx0 = c[4];
        this.vy0 = c[5];
        this.vx1 = c[6];
        this.vy1 = c[7];
        if (mvComposite.zGridComplete) {
            this.zGrid = mvComposite.zGrid;
            this.zGridComplete = true;
            this.zGridIncludesHillshade = mvComposite.zGridIncludesHillshade;
        }
        if (this.model.isLoaded()) {
            IIncrementalTin ref = this.model.getReferenceTin();
            ref.getNavigator();
            this.interpolator = new GwrTinInterpolator(ref);
            this.navigator = ref.getNavigator();
        }
    }

    public IModel getModel() {
        return this.model;
    }

    public ViewOptions getView() {
        return this.view;
    }

    public int getTaskIndex() {
        return this.taskIndex;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    AffineTransform getModelToDisplayTransform() {
        return this.m2c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWireframeTin(IIncrementalTin tin, int reduction) {
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            this.wireframeTin = tin;
            this.reductionForWireframe = reduction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRasterTin(IIncrementalTin rasterTin, int reduction) {
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            this.rasterTin = rasterTin;
            this.reductionForRaster = reduction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void applyRangeOfVisibleSamples(List<Vertex> vList) {
        if (vList == null) {
            return;
        }
        double zMin = Double.POSITIVE_INFINITY;
        double zMax = Double.NEGATIVE_INFINITY;
        for (Vertex v : vList) {
            double x = v.getX();
            double y = v.getY();
            if (!(this.vx0 <= x) || !(x <= this.vx1) || !(this.vy0 <= y) || !(y <= this.vy1)) continue;
            double z = v.getZ();
            if (z < zMin) {
                zMin = z;
            }
            if (!(z > zMax)) continue;
            zMax = z;
        }
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            if (zMin < this.zVisMin) {
                this.zVisMin = zMin;
            }
            if (zMax > this.zVisMax) {
                this.zVisMax = zMax;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getRangeOfVisibleSamples() {
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            if (this.zVisMin == Double.POSITIVE_INFINITY) {
                return new double[0];
            }
            double[] d = new double[]{this.zVisMin, this.zVisMax};
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitCandidateTinForInterpolation(IIncrementalTin tin, double reductionFactor) {
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            if (reductionFactor < this.reductionForInterpolatingTin) {
                this.interpolatingTin = tin;
                this.reductionForInterpolatingTin = reductionFactor;
                this.interpolator = new GwrTinInterpolator(this.interpolatingTin);
                this.navigator = this.interpolatingTin.getNavigator();
            }
        }
    }

    private int cohenSutherlandCode(Vertex v) {
        double x = v.getX();
        double y = v.getY();
        int mask = 0;
        if (x < this.vx0) {
            mask |= 2;
        } else if (x > this.vx1) {
            mask |= 1;
        }
        if (y < this.vy0) {
            mask |= 4;
        } else if (y > this.vy1) {
            mask |= 8;
        }
        return mask;
    }

    BufferedImage renderWireframePointsOnly(List<Vertex> vList) {
        this.timeForRenderWireframe1 = 0L;
        this.nVerticesInWireframe = 0;
        this.timeForRenderWireframe0 = System.currentTimeMillis();
        BufferedImage bImage = new BufferedImage(this.width, this.height, 6);
        Graphics2D g2d = bImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(this.view.getForeground());
        double[] c = new double[8];
        double zMinForPalette = this.model.getMinZ();
        double zMaxForPalette = this.model.getMaxZ();
        TestPalette palette = null;
        if (this.view.usePaletteForWireframe()) {
            String paletteName = this.view.getPaletteName();
            palette = TestPalette.getPaletteByName(paletteName);
            if (this.view.useRangeOfValuesForPalette()) {
                double[] pRange = this.view.getRangeForPalette();
                zMinForPalette = pRange[0];
                zMaxForPalette = pRange[1];
            }
        }
        g2d.setColor(this.view.getForeground());
        boolean labeling = this.view.isLabelRenderingSelected();
        boolean indexLabeling = "ID".equalsIgnoreCase(this.view.getFieldForLabel());
        g2d.setFont(new Font("Arial", 0, 10));
        Ellipse2D.Double e2d = new Ellipse2D.Double();
        for (Vertex a : vList) {
            double x = a.getX();
            double y = a.getY();
            c[0] = x;
            c[1] = y;
            this.m2c.transform(c, 0, c, 2, 1);
            x = c[2];
            y = c[3];
            if (!(0.0 <= x) || !(x <= (double)this.width) || !(0.0 <= y) || !(y <= (double)this.height)) continue;
            ((RectangularShape)e2d).setFrame(c[2] - 2.0, c[3] - 2.0, 5.0, 5.0);
            if (palette != null) {
                double z = a.getZ();
                Color color = palette.getColor(z, zMinForPalette, zMaxForPalette);
                g2d.setColor(color);
            }
            g2d.fill(e2d);
            if (!labeling) continue;
            String s = indexLabeling ? Integer.toString(a.getIndex()) : String.format("%5.3f", a.getZ());
            g2d.drawString(s, (float)(c[2] + 3.0), (float)(c[3] - 3.0));
        }
        return bImage;
    }

    BufferedImage renderWireframe() {
        this.timeForRenderWireframe1 = 0L;
        this.nVerticesInWireframe = 0;
        if (!this.view.isEdgeRenderingSelected() && !this.view.isVertexRenderingSelected()) {
            return null;
        }
        this.timeForRenderWireframe0 = System.currentTimeMillis();
        BufferedImage bImage = new BufferedImage(this.width, this.height, 6);
        Graphics2D g2d = bImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(this.view.getForeground());
        double[] c = new double[8];
        double zMinForPalette = this.model.getMinZ();
        double zMaxForPalette = this.model.getMaxZ();
        TestPalette palette = null;
        if (this.view.usePaletteForWireframe()) {
            String paletteName = this.view.getPaletteName();
            palette = TestPalette.getPaletteByName(paletteName);
            if (this.view.useRangeOfValuesForPalette()) {
                double[] pRange = this.view.getRangeForPalette();
                zMinForPalette = pRange[0];
                zMaxForPalette = pRange[1];
            }
        }
        g2d.setColor(this.view.getForeground());
        int maxVertexIndex = 0;
        List edgeList = this.wireframeTin.getEdges();
        for (IQuadEdge e : edgeList) {
            int index;
            Object b;
            int index2;
            Vertex a = e.getA();
            if (a != null && (index2 = a.getIndex()) > maxVertexIndex) {
                maxVertexIndex = index2;
            }
            if ((b = e.getB()) == null || (index = b.getIndex()) <= maxVertexIndex) continue;
            maxVertexIndex = index;
        }
        int nVerticesIncluded = 0;
        int[] bitmap = new int[1 + maxVertexIndex / 32];
        if (this.view.isEdgeRenderingSelected()) {
            Line2D.Double l2d = new Line2D.Double();
            for (IQuadEdge e : edgeList) {
                int bMask;
                int aMask;
                Vertex a = e.getA();
                Vertex b = e.getB();
                if (a == null || b == null || ((aMask = this.cohenSutherlandCode(a)) & (bMask = this.cohenSutherlandCode(b))) != 0) continue;
                if (aMask == 0) {
                    ++nVerticesIncluded;
                    int aIndex = a.getIndex();
                    if (aIndex >= 0) {
                        int n = aIndex >> 5;
                        bitmap[n] = bitmap[n] | 1 << (aIndex & 0x1F);
                    }
                }
                if (bMask == 0) {
                    ++nVerticesIncluded;
                    int bIndex = b.getIndex();
                    if (bIndex >= 0) {
                        int n = bIndex >> 5;
                        bitmap[n] = bitmap[n] | 1 << (bIndex & 0x1F);
                    }
                }
                if (palette != null) {
                    double z0 = a.getZ();
                    double z1 = a.getZ();
                    Color c0 = palette.getColor(z0, zMinForPalette, zMaxForPalette);
                    Color c1 = palette.getColor(z1, zMinForPalette, zMaxForPalette);
                    GradientPaint paint = new GradientPaint((float)a.getX(), (float)b.getY(), c0, (float)a.getX(), (float)b.getY(), c1);
                    g2d.setPaint(paint);
                }
                c[0] = a.getX();
                c[1] = a.getY();
                c[2] = b.getX();
                c[3] = b.getY();
                this.m2c.transform(c, 0, c, 4, 2);
                ((Line2D)l2d).setLine(c[4], c[5], c[6], c[7]);
                g2d.draw(l2d);
            }
        }
        if (!this.view.isEdgeRenderingSelected()) {
            for (IQuadEdge e : edgeList) {
                double y;
                double x;
                Vertex a = e.getA();
                Vertex b = e.getB();
                if (a != null) {
                    x = a.getX();
                    y = a.getY();
                    if (this.vx0 <= x && x <= this.vx1 && this.vy0 <= y && y <= this.vy1) {
                        ++nVerticesIncluded;
                        int aIndex = a.getIndex();
                        if (aIndex >= 0) {
                            int n = aIndex >> 5;
                            bitmap[n] = bitmap[n] | 1 << (aIndex & 0x1F);
                        }
                    }
                }
                if (b == null) continue;
                x = b.getX();
                y = b.getY();
                if (!(this.vx0 <= x) || !(x <= this.vx1) || !(this.vy0 <= y) || !(y <= this.vy1)) continue;
                ++nVerticesIncluded;
                int bIndex = b.getIndex();
                if (bIndex < 0) continue;
                int n = bIndex >> 5;
                bitmap[n] = bitmap[n] | 1 << (bIndex & 0x1F);
            }
        }
        if (this.view.isVertexRenderingSelected()) {
            boolean labeling = this.view.isLabelRenderingSelected();
            boolean indexLabeling = "ID".equalsIgnoreCase(this.view.getFieldForLabel());
            g2d.setFont(new Font("Arial", 0, 10));
            Ellipse2D.Double e2d = new Ellipse2D.Double();
            for (IQuadEdge e : edgeList) {
                int bIndex;
                Color color;
                double y;
                double x;
                int mask;
                int aIndex;
                Vertex a = e.getA();
                Vertex b = e.getB();
                if (a != null && (aIndex = a.getIndex()) >= 0 && (bitmap[aIndex >> 5] & (mask = 1 << (aIndex & 0x1F))) != 0) {
                    int n = aIndex >> 5;
                    bitmap[n] = bitmap[n] & ~mask;
                    x = a.getX();
                    y = a.getY();
                    c[0] = x;
                    c[1] = y;
                    this.m2c.transform(c, 0, c, 2, 1);
                    ((RectangularShape)e2d).setFrame(c[2] - 2.0, c[3] - 2.0, 5.0, 5.0);
                    if (palette != null) {
                        double z = a.getZ();
                        color = palette.getColor(z, zMinForPalette, zMaxForPalette);
                        g2d.setColor(color);
                    }
                    g2d.fill(e2d);
                    if (labeling) {
                        String s = indexLabeling ? a.getLabel() : String.format("%5.3f", a.getZ());
                        g2d.drawString(s, (float)(c[2] + 3.0), (float)(c[3] - 3.0));
                    }
                }
                if (b == null || (bIndex = b.getIndex()) < 0 || (bitmap[bIndex >> 5] & (mask = 1 << (bIndex & 0x1F))) == 0) continue;
                int n = bIndex >> 5;
                bitmap[n] = bitmap[n] & ~mask;
                x = b.getX();
                y = b.getY();
                c[0] = x;
                c[1] = y;
                this.m2c.transform(c, 0, c, 2, 1);
                ((RectangularShape)e2d).setFrame(c[2] - 2.0, c[3] - 2.0, 5.0, 5.0);
                if (palette != null) {
                    double z = b.getZ();
                    color = palette.getColor(z, zMinForPalette, zMaxForPalette);
                    g2d.setColor(color);
                }
                g2d.fill(e2d);
                if (!labeling) continue;
                String s = indexLabeling ? Integer.toString(b.getIndex()) : String.format("%5.3f", b.getZ());
                g2d.drawString(s, (float)(c[2] + 3.0), (float)(c[3] - 3.0));
            }
        }
        g2d.dispose();
        this.timeForRenderWireframe1 = System.currentTimeMillis();
        this.nVerticesInWireframe = nVerticesIncluded;
        this.updateReport();
        return bImage;
    }

    BufferedImage renderConstraints() {
        if (!this.view.isConstraintRenderingSelected()) {
            return null;
        }
        BufferedImage bImage = new BufferedImage(this.width, this.height, 6);
        Graphics2D g2d = bImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(this.view.getForeground());
        double[] c = new double[8];
        g2d.setColor(this.view.getConstraintColor());
        g2d.setStroke(new BasicStroke(2.0f));
        for (IConstraint con : this.constraintsForRender) {
            if (!con.isValid()) continue;
            boolean moveFlag = true;
            Path2D.Double path = new Path2D.Double();
            for (Vertex v : con) {
                c[0] = v.getX();
                c[1] = v.getY();
                this.m2c.transform(c, 0, c, 2, 1);
                if (moveFlag) {
                    moveFlag = false;
                    ((Path2D)path).moveTo(c[2], c[3]);
                    continue;
                }
                ((Path2D)path).lineTo(c[2], c[3]);
            }
            if (con.isPolygon()) {
                path.closePath();
            }
            g2d.draw(path);
        }
        return bImage;
    }

    public AffineTransform getComposite2ModelTransform() {
        return new AffineTransform(this.c2m);
    }

    public AffineTransform getModel2CompositeTransform() {
        return new AffineTransform(this.m2c);
    }

    public String getModelDataStringAtCoordinates(double x, double y) {
        double[] c = new double[4];
        c[0] = x;
        c[1] = y;
        this.c2m.transform(c, 0, c, 2, 1);
        double mx = c[2];
        double my = c[3];
        Object s = this.model.getFormattedCoordinates(c[2], c[3]);
        if (mx < this.vx0 || mx > this.vx1 || my < this.vy0 || my > this.vy1) {
            return s;
        }
        if (this.interpolator != null) {
            double z = this.interpolator.interpolate(SurfaceModel.QuadraticWithCrossTerms, BandwidthSelectionMethod.FixedProportionalBandwidth, 1.0, mx, my, null);
            s = Double.isNaN(z) ? (String)s + " : N/A" : (String)s + String.format(" : %4.2f", z);
        }
        return s;
    }

    public MvQueryResult performQuery(double x, double y) {
        String units;
        double[] c = new double[4];
        c[0] = x;
        c[1] = y;
        this.c2m.transform(c, 0, c, 2, 1);
        double mx = c[2];
        double my = c[3];
        Point2D.Double compositePoint = new Point2D.Double(x, y);
        Point2D.Double modelPoint = new Point2D.Double(mx, my);
        if (this.interpolator == null) {
            new MvQueryResult(compositePoint, modelPoint, "<html>Data not available. Model not loaded</html>", null);
        }
        switch (this.model.getLinearUnits()) {
            case METERS: 
            case FEET: {
                units = this.model.getLinearUnits().getAbbreviation();
                break;
            }
            default: {
                units = "units";
            }
        }
        NearestEdgeResult result = this.navigator.getNearestEdge(mx, my);
        boolean queryIsOutside = !result.isInterior();
        Vertex vNear = result.getNearestVertex();
        double dNear = result.getDistanceToNearestVertex();
        StringBuilder sb = new StringBuilder(512);
        Formatter fmt = new Formatter(sb);
        fmt.format("<html><strong>Query/Regression Results</strong><br><pre><small>", new Object[0]);
        double z = this.interpolator.interpolate(SurfaceModel.QuadraticWithCrossTerms, BandwidthSelectionMethod.OptimalAICc, 1.0, mx, my, null);
        String q = this.model.getFormattedX(mx);
        fmt.format("X:     %s%n", this.model.getFormattedX(mx));
        fmt.format("Y:     %s%n", this.model.getFormattedY(my));
        if (queryIsOutside) {
            fmt.format("Query point is outside of TIN", new Object[0]);
        } else if (Double.isNaN(z)) {
            fmt.format("Z:     Not available%n", new Object[0]);
        } else {
            double[] beta = this.interpolator.getCoefficients();
            double descA = Math.toDegrees(Math.atan2(-beta[2], -beta[1]));
            double descB = 90.0 - descA;
            if (descB < 0.0) {
                descB += 360.0;
            }
            double zX = beta[1];
            double zY = beta[2];
            double slope = Math.sqrt(zX * zX + zY * zY);
            double kP = Double.NaN;
            double kS = Double.NaN;
            double h = Double.NaN;
            try {
                h = this.interpolator.getPredictionIntervalHalfRange(0.05);
            }
            catch (SingularMatrixException smex) {
                fmt.format("Data does not support statistical analysis%n", new Object[0]);
            }
            if (!Double.isNaN(h)) {
                switch (this.interpolator.getSurfaceModel()) {
                    case QuadraticWithCrossTerms: 
                    case CubicWithCrossTerms: {
                        double zXX = 2.0 * beta[3];
                        double zYY = 2.0 * beta[4];
                        double zXY = beta[5];
                        kP = (zXX * zX * zX + 2.0 * zXY * zX * zY + zYY * zY * zY) / ((zX * zX + zY * zY) * Math.pow(zX * zX + zY * zY + 1.0, 1.5));
                        kS = (zX * zY * (zXX - zYY) + (zY * zY - zX * zX) * zXY) / Math.pow(zX * zX + zY * zY, 1.5);
                        break;
                    }
                }
                fmt.format("Z:     %11.2f &plusmn; %4.2f %s%n", z, h, units);
                fmt.format("Slope: %11.2f %%%n", slope * 100.0);
                fmt.format("Curvature%n", new Object[0]);
                fmt.format("  Profile:    %8.5f (radian/%s)%n", kP, units);
                fmt.format("  Streamline: %8.5f (radian/%s)%n", kS, units);
                fmt.format("Steepest Descent%n", new Object[0]);
                fmt.format("  Azimuth:    %4d&deg;%n", (int)descA);
                fmt.format("  Compass Brg: %03d&deg;%n", (int)descB);
            }
            fmt.format("Nearest Point%n", new Object[0]);
            fmt.format("  Dist:  %11.2f %s%n", dNear, units);
            fmt.format("  X:     %s%n", this.model.getFormattedX(vNear.getX()));
            fmt.format("  Y:     %s%n", this.model.getFormattedY(vNear.getY()));
            fmt.format("  Z:     %11.2f%n", vNear.getZ());
            fmt.format("  ID:    %8d%n", vNear.getIndex());
            if (this.model instanceof ModelFromLas) {
                ((ModelFromLas)this.model).formatLidarFields(fmt, vNear.getIndex());
            }
            if (!Double.isNaN(h)) {
                fmt.format("%nRegression used %d samples%n", this.interpolator.getSampleCount());
            }
        }
        fmt.format("</small></pre></html>", new Object[0]);
        return new MvQueryResult(compositePoint, modelPoint, sb.toString(), vNear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float[] getArrayForZ() {
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            if (this.zGrid == null) {
                this.zGrid = new float[this.width * this.height * 3];
                for (int i = 0; i < this.zGrid.length; ++i) {
                    this.zGrid[i] = Float.NaN;
                }
            }
            return this.zGrid;
        }
    }

    void startGridBuildTimer() {
        this.timeForBuildRaster0 = System.currentTimeMillis();
    }

    void buildGrid(int row0, int nRows, boolean hillshade, IModelViewTask task) {
        this.getArrayForZ();
        this.zGridIncludesHillshade = hillshade;
        double minX = this.model.getMinX();
        double maxX = this.model.getMaxX();
        double minY = this.model.getMinY();
        double maxY = this.model.getMaxY();
        int rowLimit = row0 + nRows;
        IIncrementalTin t = this.rasterTin;
        if (t == null) {
            t = this.wireframeTin;
        }
        double[] c = new double[8];
        ViewOptions.RasterInterpolationMethod rim = this.view.getRasterInterpolationMethod();
        switch (rim) {
            case NaturalNeighbor: {
                NaturalNeighborInterpolator nni = new NaturalNeighborInterpolator(t);
                if (hillshade) {
                    P3 pa = new P3();
                    P3 pb = new P3();
                    P3 pc = new P3();
                    P3 pd = new P3();
                    for (int iRow = row0; iRow < rowLimit; ++iRow) {
                        int index = iRow * this.width * 3;
                        c[0] = 0.0;
                        c[1] = (double)iRow - 0.5;
                        c[2] = this.width;
                        c[3] = (double)iRow + 0.5;
                        this.c2m.transform(c, 0, c, 4, 2);
                        double x0 = c[4];
                        double y0 = c[5];
                        double x1 = c[6];
                        double y1 = c[7];
                        double y = (y0 + y1) / 2.0;
                        if (y < minY || y > maxY) continue;
                        double dx = (x1 - x0) / (double)this.width;
                        pd.x = x0;
                        pd.y = y1;
                        pd.z = nni.interpolate(pd.x, pd.y, null);
                        pc.x = x0;
                        pc.y = y0;
                        pc.z = nni.interpolate(pc.x, pc.y, null);
                        for (int iCol = 0; iCol < this.width; ++iCol) {
                            P3 swap = pa;
                            pa = pd;
                            pd = swap;
                            swap = pb;
                            pb = pc;
                            pc = swap;
                            double x = ((double)iCol + 0.5) * dx + x0;
                            pd.x = x + dx / 2.0;
                            pd.y = y1;
                            pd.z = Double.NaN;
                            pc.x = x + dx / 2.0;
                            pc.y = y0;
                            pc.z = Double.NaN;
                            if (minX <= x && x <= maxX) {
                                double z = nni.interpolate(x, y, null);
                                pd.z = nni.interpolate(pd.x, pd.y, null);
                                pc.z = nni.interpolate(pc.x, pc.y, null);
                                if (Double.isNaN(z) || Double.isNaN(pa.z) || Double.isNaN(pb.z) || Double.isNaN(pc.z) || Double.isNaN(pd.z)) {
                                    this.zGrid[index] = Float.NaN;
                                } else {
                                    this.zGrid[index] = (float)z;
                                    double xA = pa.x - pb.x;
                                    double yA = pa.y - pb.y;
                                    double zA = pa.z - pb.z;
                                    double xC = pc.x - pb.x;
                                    double yC = pc.y - pb.y;
                                    double zC = pc.z - pb.z;
                                    double xN = yC * zA - zC * yA;
                                    double yN = zC * xA - xC * zA;
                                    double zN = xC * yA - yC * xA;
                                    xA = pa.x - pd.x;
                                    yA = pa.y - pd.y;
                                    zA = pa.z - pd.z;
                                    xC = pc.x - pd.x;
                                    yC = pc.y - pd.y;
                                    zC = pc.z - pd.z;
                                    this.zGrid[index + 1] = (float)(-(xN += yA * zC - zA * yC) / (zN += xA * yC - yA * xC));
                                    this.zGrid[index + 2] = (float)(-(yN += zA * xC - xA * zC) / zN);
                                }
                            }
                            index += 3;
                        }
                        if (task == null || !task.isCancelled()) continue;
                        return;
                    }
                } else {
                    for (int iRow = row0; iRow < rowLimit; ++iRow) {
                        int index = iRow * this.width * 3;
                        c[0] = 0.0;
                        c[1] = (double)iRow + 0.5;
                        c[2] = this.width;
                        c[3] = (double)iRow + 0.5;
                        this.c2m.transform(c, 0, c, 4, 2);
                        double x0 = c[4];
                        double y0 = c[5];
                        double x1 = c[6];
                        double y1 = c[7];
                        double y = (y0 + y1) / 2.0;
                        if (y < minY || y > maxY) continue;
                        double dx = (x1 - x0) / (double)this.width;
                        for (int iCol = 0; iCol < this.width; ++iCol) {
                            double x = ((double)iCol + 0.5) * dx + x0;
                            if (minX <= x && x <= maxX) {
                                double z = nni.interpolate(x, y, null);
                                this.zGrid[index] = Double.isNaN(z) ? Float.NaN : (float)z;
                            }
                            index += 3;
                        }
                        if (task == null || !task.isCancelled()) continue;
                        return;
                    }
                }
                break;
            }
            case GeographicallyWeightedRegression: {
                GwrTinInterpolator gwr = new GwrTinInterpolator(t);
                for (int iRow = row0; iRow < rowLimit; ++iRow) {
                    int index = iRow * this.width * 3;
                    c[0] = 0.0;
                    c[1] = (double)iRow + 0.5;
                    c[2] = this.width;
                    c[3] = (double)iRow + 0.5;
                    this.c2m.transform(c, 0, c, 4, 2);
                    double x0 = c[4];
                    double y0 = c[5];
                    double x1 = c[6];
                    double y1 = c[7];
                    double y = (y0 + y1) / 2.0;
                    if (y < minY || y > maxY) continue;
                    double dx = (x1 - x0) / (double)this.width;
                    for (int iCol = 0; iCol < this.width; ++iCol) {
                        double x = ((double)iCol + 0.5) * dx + x0;
                        if (minX <= x && x <= maxX) {
                            double z = gwr.interpolate(SurfaceModel.QuadraticWithCrossTerms, BandwidthSelectionMethod.FixedProportionalBandwidth, 1.0, x, y, null);
                            if (gwr.wasTargetExteriorToTin()) {
                                this.zGrid[index] = Float.NaN;
                            } else if (Double.isNaN(z)) {
                                this.zGrid[index] = Float.NaN;
                            } else {
                                this.zGrid[index] = (float)z;
                                double[] beta = gwr.getCoefficients();
                                this.zGrid[index + 1] = (float)beta[1];
                                this.zGrid[index + 2] = (float)beta[2];
                            }
                        }
                        index += 3;
                    }
                    if (task == null || !task.isCancelled()) continue;
                    return;
                }
                break;
            }
            default: {
                TriangularFacetInterpolator tri = new TriangularFacetInterpolator(t);
                for (int iRow = row0; iRow < rowLimit; ++iRow) {
                    int index = iRow * this.width * 3;
                    c[0] = 0.0;
                    c[1] = (double)iRow + 0.5;
                    c[2] = this.width;
                    c[3] = (double)iRow + 0.5;
                    this.c2m.transform(c, 0, c, 4, 2);
                    double x0 = c[4];
                    double y0 = c[5];
                    double x1 = c[6];
                    double y1 = c[7];
                    double y = (y0 + y1) / 2.0;
                    if (y < minY || y > maxY) continue;
                    double dx = (x1 - x0) / (double)this.width;
                    for (int iCol = 0; iCol < this.width; ++iCol) {
                        double x = ((double)iCol + 0.5) * dx + x0;
                        if (minX <= x && x <= maxX) {
                            double z = tri.interpolate(x, y, null);
                            if (Double.isNaN(z)) {
                                this.zGrid[index] = Float.NaN;
                            } else {
                                this.zGrid[index] = (float)z;
                                if (hillshade) {
                                    double[] norm = tri.getSurfaceNormal();
                                    this.zGrid[index + 1] = -((float)(norm[0] / norm[2]));
                                    this.zGrid[index + 2] = -((float)(norm[1] / norm[2]));
                                }
                            }
                        }
                        index += 3;
                    }
                    if (task == null || !task.isCancelled()) continue;
                    return;
                }
            }
        }
    }

    void transferGridToRasterImage() {
        double[] range;
        double minZ = this.model.getMinZ();
        double maxZ = this.model.getMaxZ();
        if (this.view.useRangeOfValuesForPalette() && (range = this.view.getRangeForPalette()) != null && range.length == 2) {
            minZ = range[0];
            maxZ = range[1];
        }
        this.getArrayForZ();
        int[] argb = new int[this.width * this.height];
        int index = 0;
        TestPalette palette = TestPalette.getPaletteByName(this.view.getPaletteName());
        boolean hillshade = this.view.isHillshadeSelected();
        if (!hillshade) {
            for (int i = 0; i < argb.length; ++i) {
                argb[i] = Float.isNaN(this.zGrid[index]) ? -1 : palette.getARGB(this.zGrid[index], minZ, maxZ);
                index += 3;
            }
        } else {
            boolean rasterColor = this.view.isRasterSelected();
            double ambient = this.view.getHillshadeAmbient() / 100.0;
            double directLight = 1.0 - ambient;
            double sunAzimuth = Math.toRadians(this.view.getHillshadeAzimuth());
            double sunElevation = Math.toRadians(this.view.getHillshadeElevation());
            double cosA = Math.cos(sunAzimuth);
            double sinA = Math.sin(sunAzimuth);
            double cosE = Math.cos(sunElevation);
            double sinE = Math.sin(sunElevation);
            double xSun = cosA * cosE;
            double ySun = sinA * cosE;
            double zSun = sinE;
            for (int i = 0; i < argb.length; ++i) {
                if (Float.isNaN(this.zGrid[index])) {
                    argb[i] = -1;
                } else {
                    double c;
                    double nz;
                    double ny;
                    double fx = -this.zGrid[index + 1];
                    double fy = -this.zGrid[index + 2];
                    double s = Math.sqrt(fx * fx + fy * fy + 1.0);
                    double nx = fx / s;
                    double cosine = nx * xSun + (ny = fy / s) * ySun + (nz = 1.0 / s) * zSun;
                    double d = c = cosine < 0.0 ? ambient : ambient + directLight * cosine;
                    if (rasterColor) {
                        int rgb = palette.getARGB(this.zGrid[index], minZ, maxZ);
                        int r = (int)((double)(rgb >> 16 & 0xFF) * c);
                        int g = (int)((double)(rgb >> 8 & 0xFF) * c);
                        int b = (int)((double)(rgb & 0xFF) * c);
                        argb[i] = 0xFF000000 | r << 16 | g << 8 | b;
                    } else {
                        int g = (int)(c * 255.0);
                        argb[i] = ((0xFF00 | g) << 8 | g) << 8 | g;
                    }
                }
                index += 3;
            }
        }
        this.rasterImage = new BufferedImage(this.width, this.height, 2);
        this.rasterImage.setRGB(0, 0, this.width, this.height, argb, 0, this.width);
        this.updateReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopGridBuildTimer() {
        double zMin = Double.POSITIVE_INFINITY;
        double zMax = Double.NEGATIVE_INFINITY;
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            this.timeForBuildRaster1 = System.currentTimeMillis();
            this.zGridComplete = true;
            for (int i = 0; i < this.zGrid.length; i += 3) {
                double zTest = this.zGrid[i];
                if (zTest < zMin) {
                    zMin = zTest;
                    continue;
                }
                if (!(zTest > zMax)) continue;
                zMax = zTest;
            }
            this.updateReport();
        }
    }

    public boolean isModelReloadRequired(ViewOptions v) {
        if (this.model instanceof ModelFromLas) {
            return this.view.getLidarPointSelection() != v.getLidarPointSelection();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelAndRenderingReport() {
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            return this.modelAndRenderingReport;
        }
    }

    private String formatReduction(int reduction) {
        if (reduction == 0) {
            return "N/A";
        }
        if (reduction == 1) {
            return "Full Resolution";
        }
        return String.format("%8d to 1", reduction);
    }

    private synchronized void updateReport() {
        StringBuilder sb = new StringBuilder(2048);
        Formatter fmt = new Formatter(sb);
        LinearUnits linearUnits = this.model.getLinearUnits();
        if (linearUnits == null) {
            linearUnits = LinearUnits.UNKNOWN;
        }
        Object units = linearUnits.toString();
        units = ((String)units).substring(0, 1).toUpperCase() + ((String)units).substring(1, ((String)units).length()).toLowerCase();
        fmt.format("<html><strong>Model</strong><br><pre><small>", new Object[0]);
        fmt.format("  Name: %s%n", this.model.getName());
        fmt.format("  Type: %s%n", this.model.getDescription());
        fmt.format("  Vertices:         %8d%n", this.model.getVertexCount());
        fmt.format("  Load time(ms):    %8d%n", this.model.getTimeToLoadInMillis());
        fmt.format("  Sort time(ms):    %8d%n", this.model.getTimeToSortInMillis());
        fmt.format("  Linear Units:     %s%n", units);
        if (this.model.hasConstraints()) {
            List<IConstraint> conList = this.model.getConstraints();
            int nPoly = 0;
            int nLine = 0;
            for (IConstraint con : conList) {
                if (con.isPolygon()) {
                    ++nPoly;
                    continue;
                }
                ++nLine;
            }
            String conType = "";
            if (nLine > 0) {
                conType = nPoly > 0 ? "Mixed" : "Linear";
            } else if (nPoly > 0) {
                conType = "Polygon";
            }
            fmt.format("  Constraints:      %8d %s%n", conList.size(), conType);
        } else {
            fmt.format("  Constraints:      None%n", new Object[0]);
        }
        fmt.format("  Bounds%n", new Object[0]);
        fmt.format("    Min X:          %s%n", this.model.getFormattedX(this.model.getMinX()));
        fmt.format("    Max X:          %s%n", this.model.getFormattedX(this.model.getMaxX()));
        fmt.format("    Min Y:          %s%n", this.model.getFormattedY(this.model.getMinY()));
        fmt.format("    Max Y:          %s%n", this.model.getFormattedY(this.model.getMaxY()));
        fmt.format("    Min Z:          %11.2f%n", this.model.getMinZ());
        fmt.format("    Max Z:          %11.2f%n", this.model.getMaxZ());
        fmt.format("  Area:             %11.2f%n", this.model.getArea());
        fmt.format("  Est. Avg. Spacing:%11.2f%n", this.model.getNominalPointSpacing());
        fmt.format("</small></pre><strong>Rendering</strong><br><pre><small>", new Object[0]);
        fmt.format("  Wireframe%n", new Object[0]);
        if (this.timeForRenderWireframe1 > 0L) {
            long timex = this.timeForRenderWireframe1 - this.timeForRenderWireframe0;
            fmt.format("    Vertices:      %8d%n", this.nVerticesInWireframe);
            fmt.format("    Reduction:     %s%n", this.formatReduction(this.reductionForWireframe));
            fmt.format("    Time(ms):      %8d%n", timex);
        } else {
            fmt.format("    Not Available%n", new Object[0]);
        }
        fmt.format("  Raster%n", new Object[0]);
        if (this.timeForBuildRaster1 > 0L) {
            long timex = this.timeForBuildRaster1 - this.timeForBuildRaster0;
            fmt.format("    Reduction:     %s%n", this.formatReduction(this.reductionForRaster));
            fmt.format("    Time(ms):      %8d%n", timex);
        } else {
            fmt.format("    Not Available%n", new Object[0]);
        }
        double[] rng = this.getRangeOfVisibleSamples();
        if (rng.length > 0) {
            fmt.format("%nRange of visible samples%n", new Object[0]);
            fmt.format("    Min:      %11.3f%n", rng[0]);
            fmt.format("    Max:      %11.3f%n", rng[1]);
        }
        fmt.format("</small></pre></html>", new Object[0]);
        fmt.flush();
        this.modelAndRenderingReport = sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IIncrementalTin getWireframeTin() {
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            return this.wireframeTin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IIncrementalTin getRasterTin() {
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            return this.rasterTin;
        }
    }

    int getReductionForWireframe() {
        return this.reductionForWireframe;
    }

    public boolean isReady() {
        return this.model.isLoaded() && this.interpolatingTin != null;
    }

    public BufferedImage renderLegend(ViewOptions vx, IModel mx, int width, int height, int margin, Font font, boolean frame) {
        int i;
        AxisIntervals lx;
        boolean reverseOrder;
        int priSpace = 20;
        int secSpace = 5;
        int ticLength = 10;
        int ticLengthShort = 5;
        double v0 = mx.getMinZ();
        double v1 = mx.getMaxZ();
        if (vx.useRangeOfValuesForPalette()) {
            double[] d = vx.getRangeForPalette();
            v0 = d[0];
            v1 = d[1];
        }
        if (v0 == v1) {
            return null;
        }
        boolean bl = reverseOrder = v0 > v1;
        if (reverseOrder) {
            double vSwap = v0;
            v0 = v1;
            v1 = vSwap;
        }
        if ((lx = AxisIntervals.computeIntervals((double)v0, (double)v1, (int)priSpace, (int)secSpace, (int)height)) == null) {
            return null;
        }
        double wLabel = 0.0;
        FontRenderContext frc = new FontRenderContext(null, true, true);
        String[] labels = lx.getLabels();
        double[] wLab = new double[labels.length];
        for (int i2 = 0; i2 < labels.length; ++i2) {
            TextLayout layout = new TextLayout(labels[i2], font, frc);
            Rectangle2D bounds = layout.getBounds();
            wLab[i2] = bounds.getMaxX();
            if (!(wLab[i2] > wLabel)) continue;
            wLabel = wLab[i2];
        }
        TextLayout layout = new TextLayout("0", font, frc);
        Rectangle2D bounds = layout.getBounds();
        double wZero = bounds.getWidth();
        double yLabelCenter = bounds.getCenterY();
        int iWidth = (int)((double)(width + 2 * margin) + wLabel + (double)ticLength + wZero / 2.0);
        int iHeight = height + 2 * margin;
        BufferedImage bImage = new BufferedImage(iWidth, iHeight, 2);
        Graphics2D g2d = bImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(vx.getBackground());
        g2d.fillRect(0, 0, iWidth + 1, iHeight + 1);
        g2d.setFont(font);
        int x0 = margin;
        int x1 = margin + width;
        int x2 = (int)((double)(margin + width + ticLength) + wZero / 2.0 + 1.0);
        int x3 = (int)((double)x2 + wLabel);
        int y0 = margin;
        int y1 = margin + height;
        String paletteName = vx.getPaletteName();
        TestPalette palette = TestPalette.getPaletteByName(paletteName);
        Rectangle2D.Double r2d = new Rectangle2D.Double();
        for (int i3 = 0; i3 <= height; ++i3) {
            double v = (double)i3 / (double)height;
            double y = y1 - i3;
            Color c = palette.getColor(v, 0.0, 1.0);
            g2d.setColor(c);
            ((Rectangle2D)r2d).setRect(x0, y, width, 1.0);
            g2d.fill(r2d);
        }
        g2d.setColor(vx.getForeground());
        ((Rectangle2D)r2d).setRect(x0, y0, width, height);
        g2d.draw(r2d);
        double[][] cTics = lx.getTicCoordinates();
        double[] vT = cTics[0];
        Line2D.Double l2d = new Line2D.Double();
        String fmt = lx.getLabelFormat();
        for (i = 0; i < vT.length; ++i) {
            double y = reverseOrder ? (double)y0 + lx.mapValueToPixel(vT[i]) : (double)y1 - lx.mapValueToPixel(vT[i]);
            ((Line2D)l2d).setLine(x1, y, x1 + ticLength, y);
            g2d.draw(l2d);
            String s = String.format(fmt, vT[i]);
            double x = (double)x3 - wLab[i];
            g2d.drawString(s, (float)x, (float)(y - yLabelCenter));
        }
        if (cTics.length == 2) {
            vT = cTics[1];
            for (i = 0; i < vT.length; ++i) {
                double y = reverseOrder ? (double)y0 + lx.mapValueToPixel(vT[i]) : (double)y1 - lx.mapValueToPixel(vT[i]);
                ((Line2D)l2d).setLine(x1, y, x1 + ticLengthShort, y);
                g2d.draw(l2d);
            }
        }
        if (frame) {
            g2d.setColor(vx.getForeground());
            g2d.drawRect(0, 0, iWidth - 1, iHeight - 1);
        }
        return bImage;
    }

    public String toString() {
        String conType = this.model.hasConstraints() ? " CDT" : "";
        String loaded = this.model.isLoaded() ? "Loaded" : "Unloaded";
        return String.format("MvComposite %d %s%s", this.serialIndex, loaded, conType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstraintsForRender(List<IConstraint> constraintsForRender) {
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            this.constraintsForRender = constraintsForRender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IConstraint> getConstraintsForRender() {
        MvComposite mvComposite = this;
        synchronized (mvComposite) {
            return this.constraintsForRender;
        }
    }

    void prepareClipMask() {
        if (this.clipMask == null) {
            this.clipMask = this.makeClipMask();
        }
    }

    Shape getClipMask() {
        return this.clipMask;
    }

    private Shape makeClipMask() {
        if (this.constraintsForRender == null || this.constraintsForRender.isEmpty()) {
            return null;
        }
        Path2D.Double clip = new Path2D.Double();
        boolean clipHasData = false;
        for (IConstraint con : this.constraintsForRender) {
            if (!con.isValid() || !con.definesConstrainedRegion() || !(con instanceof PolygonConstraint)) continue;
            Path2D.Double path = new Path2D.Double();
            boolean foundStuff = false;
            List vList = con.getVertices();
            double[] c = new double[4];
            boolean moveFlag = true;
            for (Vertex v : vList) {
                c[0] = v.getX();
                c[1] = v.getY();
                this.m2c.transform(c, 0, c, 2, 1);
                if (moveFlag) {
                    moveFlag = false;
                    ((Path2D)path).moveTo(c[2], c[3]);
                    continue;
                }
                foundStuff = true;
                ((Path2D)path).lineTo(c[2], c[3]);
            }
            path.closePath();
            if (!foundStuff) continue;
            clip.append(path, true);
            clipHasData = true;
        }
        if (clipHasData) {
            return clip;
        }
        return null;
    }

    private class P3 {
        double x;
        double y;
        double z;

        private P3() {
        }
    }
}

