/*
 * Decompiled with CFR 0.152.
 */
package com.github.mreutegg.laszip4j.laszip;

import com.github.mreutegg.laszip4j.laszip.ByteStreamInDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class ByteStreamInFile
extends ByteStreamInDataInput {
    private final RandomAccessFile file;
    private final MMappedDataInput in;

    public ByteStreamInFile(RandomAccessFile file) {
        super(new MMappedDataInput(file));
        this.file = file;
        this.in = (MMappedDataInput)this.dataIn;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long tell() {
        return this.in.position();
    }

    @Override
    public boolean seek(long position) {
        this.in.position(position);
        return true;
    }

    @Override
    public boolean seekEnd(long distance) {
        try {
            long len = this.file.length();
            if (0L <= distance && distance <= len) {
                this.in.position(len - distance);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    private static class MMappedDataInput
    implements DataInput {
        private final MappedByteBuffer buffer;

        MMappedDataInput(RandomAccessFile file) {
            try {
                this.buffer = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.buffer.get(b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            int skip = Math.min(this.buffer.remaining(), n);
            this.buffer.position(this.buffer.position() + skip);
            return skip;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.readByte() != 0;
        }

        @Override
        public byte readByte() throws IOException {
            return this.buffer.get();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return Byte.toUnsignedInt(this.readByte());
        }

        @Override
        public short readShort() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public char readChar() throws IOException {
            int ch1 = this.readUnsignedByte();
            int ch2 = this.readUnsignedByte();
            return (char)((ch1 << 8) + ch2);
        }

        @Override
        public int readInt() throws IOException {
            int ch1 = this.readUnsignedByte();
            int ch2 = this.readUnsignedByte();
            int ch3 = this.readUnsignedByte();
            int ch4 = this.readUnsignedByte();
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }

        @Override
        public long readLong() throws IOException {
            return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
        }

        @Override
        public float readFloat() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public double readDouble() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long position() {
            return this.buffer.position();
        }

        public void position(long position) {
            if (position > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("position > 2147483647: " + position);
            }
            this.buffer.position((int)position);
        }
    }
}

