/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.development.cdt;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.LinearConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.demo.utils.TestOptions;
import org.tinfour.demo.utils.TestVertices;

class RandomConstraintTestOptions {
    final TestOptions options;
    final int testCount;
    final int vertexCount;
    final long vertexSeed;
    final long constraintSeed;
    final ConstraintType constraintType;
    final Class<?> tinClass;
    final boolean restoreConformity;
    final Random random = new Random();

    private long scanSeed(TestOptions options, String[] args, String target, boolean[] matched) {
        Long seedObj = options.scanLongOption(args, target, matched);
        if (seedObj == null) {
            return 0L;
        }
        return seedObj;
    }

    RandomConstraintTestOptions(String[] args, boolean[] argsRecognized) {
        this.options = new TestOptions();
        boolean[] matched = this.options.argumentScan(args);
        this.testCount = this.options.getTestCount(100);
        this.vertexCount = this.options.getVertexCount(20);
        this.vertexSeed = this.scanSeed(this.options, args, "-vertexSeed", matched);
        this.constraintSeed = this.scanSeed(this.options, args, "-constraintSeed", matched);
        this.restoreConformity = this.options.scanBooleanOption(args, "-restoreConformity", matched, false);
        String cTypeStr = this.options.scanStringOption(args, "-constraintType", matched);
        this.constraintType = ConstraintType.lenientValueOf(cTypeStr);
        this.tinClass = this.options.getTinClass();
        if (argsRecognized != null) {
            System.arraycopy(matched, 0, argsRecognized, 0, args.length);
        }
    }

    int getTestCount() {
        return this.testCount;
    }

    boolean isConformityRestoreSet() {
        return this.restoreConformity;
    }

    int getVertexSeed(int testIndex) {
        return (int)(this.vertexSeed + (long)testIndex);
    }

    int getConstraintSeed(int constraintTestIndex) {
        return (int)(this.vertexSeed + (long)constraintTestIndex);
    }

    ConstraintType getConstraintType() {
        return this.constraintType;
    }

    List<Vertex> makeRandomVertices(int testIndex) {
        long iSeed = this.vertexSeed + (long)testIndex;
        List<Vertex> vertexList = TestVertices.makeRandomVertices(this.vertexCount, (int)iSeed);
        return vertexList;
    }

    IIncrementalTin makeNewInstanceOfTestTin() {
        return this.options.getNewInstanceOfTestTin();
    }

    List<IConstraint> makeConstraints(int constraintTestIndex) {
        this.random.setSeed(this.constraintSeed + (long)constraintTestIndex);
        ArrayList<IConstraint> conList = new ArrayList<IConstraint>();
        LinearConstraint linCon = new LinearConstraint();
        conList.add(linCon);
        double x0 = this.random.nextDouble();
        double y0 = this.random.nextDouble();
        double x1 = this.random.nextDouble();
        double y1 = this.random.nextDouble();
        double x2 = this.random.nextDouble();
        double y2 = this.random.nextDouble();
        switch (this.constraintType) {
            case SingleSegment: {
                Vertex v0 = new Vertex(x0, y0, 1.0, 1000);
                Vertex v1 = new Vertex(x1, y1, 1.0, 1001);
                linCon.add(v0);
                linCon.add(v1);
                break;
            }
            case ColinearSegments: {
                Vertex v0 = new Vertex(x0, y0, 1.0, 1000);
                Vertex v1 = new Vertex(x1, y1, 1.0, 1002);
                double xm = (v0.getX() + v1.getX()) / 2.0;
                double ym = (v0.getY() + v1.getY()) / 2.0;
                Vertex vm = new Vertex(xm, ym, 1.0, 1001);
                linCon.add(v0);
                linCon.add(vm);
                linCon.add(v1);
                break;
            }
            case RandomSegmentPair: {
                Vertex v0 = new Vertex(x0, y0, 1.0, 1000);
                Vertex v1 = new Vertex(x1, y1, 1.0, 1001);
                Vertex v2 = new Vertex(x2, y2, 1.0, 1002);
                linCon.add(v0);
                linCon.add(v1);
                linCon.add(v2);
                break;
            }
            case RandomCross: {
                Vertex v0 = new Vertex(x0, y0, 1.0, 1000);
                Vertex v1 = new Vertex(x1, y1, 1.0, 1002);
                double xm = (v0.getX() + v1.getX()) / 2.0;
                double ym = (v0.getY() + v1.getY()) / 2.0;
                Vertex vm = new Vertex(xm, ym, 1.0, 1001);
                linCon.add(v0);
                linCon.add(vm);
                linCon.add(v1);
                double px = v0.getY() - v1.getY();
                double py = v1.getX() - v0.getX();
                LinearConstraint cross = new LinearConstraint();
                conList.add(cross);
                cross.add(new Vertex(xm - px, ym - py, 1.0, 1003));
                cross.add(new Vertex(xm, ym, 1.0, 1004));
                cross.add(new Vertex(xm + px, ym + py, 1.0, 1005));
                break;
            }
            default: {
                return null;
            }
        }
        return conList;
    }

    void printSummary(PrintStream ps) {
        ps.println("TIN class:                      " + this.tinClass.getName());
        ps.println("Constraint type:                " + (Object)((Object)this.constraintType));
        ps.println("Restore delaunay conformity:    " + this.restoreConformity);
        ps.format("Number of vertex test sets:          %8d%n", this.testCount);
        ps.format("Number of constraint tests per sets: %8d%n", this.testCount);
        ps.format("Number of vertices to process:       %8d%n", this.vertexCount);
        ps.format("Seed (for vertex generation):        %8d%n", this.vertexSeed);
        ps.format("Seed (for constraint generation):    %8d%n", this.constraintSeed);
    }

    static enum ConstraintType {
        SingleSegment,
        ColinearSegments,
        RandomSegmentPair,
        RandomCross;


        static ConstraintType lenientValueOf(String s) {
            if (s == null || s.isEmpty()) {
                return RandomSegmentPair;
            }
            String test = s.toLowerCase();
            if (test.startsWith("single")) {
                return SingleSegment;
            }
            if (test.startsWith("co")) {
                return ColinearSegments;
            }
            if (test.startsWith("randomcross") || test.startsWith("cross")) {
                return RandomCross;
            }
            return RandomSegmentPair;
        }
    }
}

