/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.tinfour.io.DelimitedReader;

public class TestPalette {
    private static final float[][] paletteB2Y = new float[][]{{0.0f, 0.0f, 255.0f}, {0.0f, 34.0f, 255.0f}, {0.0f, 50.0f, 255.0f}, {0.0f, 63.0f, 255.0f}, {0.0f, 73.0f, 255.0f}, {0.0f, 82.0f, 255.0f}, {0.0f, 90.0f, 255.0f}, {0.0f, 97.0f, 255.0f}, {0.0f, 104.0f, 255.0f}, {0.0f, 110.0f, 255.0f}, {0.0f, 116.0f, 255.0f}, {0.0f, 121.0f, 255.0f}, {0.0f, 127.0f, 255.0f}, {0.0f, 132.0f, 255.0f}, {0.0f, 136.0f, 255.0f}, {0.0f, 141.0f, 255.0f}, {0.0f, 145.0f, 255.0f}, {0.0f, 149.0f, 255.0f}, {0.0f, 153.0f, 255.0f}, {0.0f, 157.0f, 255.0f}, {0.0f, 160.0f, 255.0f}, {0.0f, 164.0f, 255.0f}, {0.0f, 167.0f, 255.0f}, {0.0f, 170.0f, 255.0f}, {0.0f, 174.0f, 255.0f}, {0.0f, 177.0f, 255.0f}, {0.0f, 180.0f, 255.0f}, {0.0f, 183.0f, 255.0f}, {0.0f, 186.0f, 255.0f}, {0.0f, 189.0f, 255.0f}, {0.0f, 192.0f, 255.0f}, {0.0f, 195.0f, 249.0f}, {0.0f, 198.0f, 241.0f}, {0.0f, 201.0f, 233.0f}, {0.0f, 203.0f, 224.0f}, {0.0f, 206.0f, 216.0f}, {0.0f, 209.0f, 207.0f}, {0.0f, 212.0f, 199.0f}, {0.0f, 214.0f, 190.0f}, {0.0f, 217.0f, 181.0f}, {0.0f, 220.0f, 173.0f}, {0.0f, 222.0f, 164.0f}, {0.0f, 225.0f, 156.0f}, {0.0f, 227.0f, 147.0f}, {0.0f, 230.0f, 139.0f}, {0.0f, 232.0f, 131.0f}, {0.0f, 234.0f, 122.0f}, {0.0f, 236.0f, 114.0f}, {0.0f, 238.0f, 106.0f}, {0.0f, 240.0f, 98.0f}, {0.0f, 242.0f, 90.0f}, {0.0f, 244.0f, 82.0f}, {0.0f, 245.0f, 74.0f}, {65.0f, 247.0f, 67.0f}, {94.0f, 248.0f, 59.0f}, {117.0f, 250.0f, 51.0f}, {136.0f, 251.0f, 42.0f}, {154.0f, 252.0f, 34.0f}, {170.0f, 253.0f, 25.0f}, {186.0f, 253.0f, 15.0f}, {200.0f, 254.0f, 4.0f}, {215.0f, 254.0f, 0.0f}, {228.0f, 255.0f, 0.0f}, {242.0f, 255.0f, 0.0f}, {255.0f, 255.0f, 0.0f}};
    private static final float[][] purpleTones = new float[][]{{78.0f, 49.0f, 95.0f}, {85.0f, 53.0f, 104.0f}, {92.0f, 58.0f, 112.0f}, {99.0f, 62.0f, 121.0f}, {106.0f, 67.0f, 130.0f}, {114.0f, 72.0f, 139.0f}, {121.0f, 76.0f, 148.0f}, {128.0f, 81.0f, 158.0f}, {136.0f, 86.0f, 167.0f}, {136.0f, 89.0f, 169.0f}, {136.0f, 92.0f, 172.0f}, {135.0f, 95.0f, 174.0f}, {135.0f, 97.0f, 176.0f}, {135.0f, 100.0f, 178.0f}, {135.0f, 103.0f, 180.0f}, {135.0f, 106.0f, 182.0f}, {135.0f, 108.0f, 184.0f}, {135.0f, 111.0f, 186.0f}, {135.0f, 114.0f, 188.0f}, {135.0f, 116.0f, 190.0f}, {135.0f, 119.0f, 191.0f}, {135.0f, 121.0f, 193.0f}, {135.0f, 124.0f, 195.0f}, {135.0f, 127.0f, 196.0f}, {136.0f, 129.0f, 198.0f}, {136.0f, 132.0f, 199.0f}, {136.0f, 134.0f, 201.0f}, {137.0f, 137.0f, 202.0f}, {137.0f, 139.0f, 204.0f}, {138.0f, 142.0f, 205.0f}, {138.0f, 144.0f, 207.0f}, {139.0f, 146.0f, 208.0f}, {140.0f, 149.0f, 209.0f}, {141.0f, 151.0f, 210.0f}, {141.0f, 154.0f, 212.0f}, {142.0f, 156.0f, 213.0f}, {143.0f, 158.0f, 214.0f}, {144.0f, 161.0f, 215.0f}, {146.0f, 163.0f, 216.0f}, {147.0f, 165.0f, 217.0f}, {148.0f, 168.0f, 218.0f}, {149.0f, 170.0f, 219.0f}, {151.0f, 172.0f, 220.0f}, {152.0f, 175.0f, 221.0f}, {154.0f, 177.0f, 222.0f}, {156.0f, 179.0f, 223.0f}, {157.0f, 181.0f, 224.0f}, {159.0f, 184.0f, 225.0f}, {161.0f, 186.0f, 226.0f}, {163.0f, 188.0f, 226.0f}, {165.0f, 190.0f, 227.0f}, {167.0f, 193.0f, 228.0f}, {169.0f, 195.0f, 229.0f}, {171.0f, 197.0f, 230.0f}, {174.0f, 199.0f, 230.0f}, {176.0f, 201.0f, 231.0f}, {178.0f, 203.0f, 232.0f}, {181.0f, 205.0f, 233.0f}, {183.0f, 208.0f, 233.0f}, {186.0f, 210.0f, 234.0f}, {189.0f, 212.0f, 235.0f}, {191.0f, 214.0f, 235.0f}, {194.0f, 216.0f, 236.0f}, {197.0f, 218.0f, 237.0f}, {200.0f, 220.0f, 238.0f}, {203.0f, 222.0f, 238.0f}, {205.0f, 224.0f, 239.0f}, {208.0f, 226.0f, 240.0f}, {211.0f, 228.0f, 241.0f}, {215.0f, 230.0f, 242.0f}, {218.0f, 232.0f, 242.0f}, {221.0f, 234.0f, 243.0f}, {224.0f, 236.0f, 244.0f}};
    private static final float[][] redToYellowToWhite = new float[][]{{255.0f, 0.0f, 0.0f}, {255.0f, 32.0f, 0.0f}, {255.0f, 64.0f, 0.0f}, {255.0f, 96.0f, 0.0f}, {255.0f, 128.0f, 0.0f}, {255.0f, 160.0f, 0.0f}, {255.0f, 192.0f, 0.0f}, {255.0f, 224.0f, 0.0f}, {255.0f, 255.0f, 255.0f}};
    private static final float[][] rainbow = new float[][]{{0.0f, 0.0f, 255.0f}, {0.0f, 255.0f, 0.0f}, {230.0f, 230.0f, 0.0f}, {255.0f, 0.0f, 0.0f}};
    private static final float[][] linearGray = new float[][]{{64.0f, 64.0f, 64.0f}, {232.0f, 232.0f, 232.0f}};
    static final float[][] topoElev = new float[][]{{0.0f, 60.0f, 16.0f}, {9.0f, 87.0f, 2.0f}, {0.0f, 142.0f, 0.0f}, {38.0f, 202.0f, 0.0f}, {173.0f, 231.0f, 45.0f}, {246.0f, 252.0f, 83.0f}, {204.0f, 150.0f, 52.0f}, {138.0f, 29.0f, 0.0f}, {239.0f, 222.0f, 222.0f}};
    static final float[][] monotonicLuminance = new float[][]{{4.0f, 4.0f, 4.0f}, {10.0f, 3.0f, 8.0f}, {13.0f, 4.0f, 11.0f}, {16.0f, 5.0f, 14.0f}, {18.0f, 5.0f, 16.0f}, {21.0f, 6.0f, 18.0f}, {22.0f, 7.0f, 19.0f}, {24.0f, 8.0f, 21.0f}, {26.0f, 8.0f, 22.0f}, {27.0f, 9.0f, 24.0f}, {28.0f, 10.0f, 25.0f}, {30.0f, 11.0f, 26.0f}, {31.0f, 12.0f, 27.0f}, {32.0f, 12.0f, 28.0f}, {33.0f, 13.0f, 29.0f}, {35.0f, 14.0f, 31.0f}, {36.0f, 14.0f, 32.0f}, {37.0f, 15.0f, 32.0f}, {38.0f, 15.0f, 33.0f}, {39.0f, 16.0f, 34.0f}, {40.0f, 17.0f, 35.0f}, {41.0f, 17.0f, 36.0f}, {42.0f, 18.0f, 38.0f}, {43.0f, 19.0f, 38.0f}, {44.0f, 19.0f, 39.0f}, {46.0f, 20.0f, 41.0f}, {46.0f, 20.0f, 45.0f}, {46.0f, 21.0f, 50.0f}, {45.0f, 21.0f, 55.0f}, {45.0f, 21.0f, 60.0f}, {45.0f, 22.0f, 64.0f}, {45.0f, 23.0f, 67.0f}, {45.0f, 23.0f, 71.0f}, {45.0f, 24.0f, 75.0f}, {45.0f, 24.0f, 77.0f}, {45.0f, 25.0f, 81.0f}, {45.0f, 25.0f, 84.0f}, {44.0f, 26.0f, 87.0f}, {44.0f, 27.0f, 90.0f}, {45.0f, 27.0f, 92.0f}, {45.0f, 28.0f, 95.0f}, {44.0f, 29.0f, 98.0f}, {44.0f, 29.0f, 100.0f}, {44.0f, 30.0f, 103.0f}, {44.0f, 31.0f, 106.0f}, {44.0f, 31.0f, 109.0f}, {44.0f, 32.0f, 110.0f}, {44.0f, 33.0f, 113.0f}, {44.0f, 34.0f, 116.0f}, {43.0f, 34.0f, 118.0f}, {42.0f, 35.0f, 121.0f}, {40.0f, 38.0f, 120.0f}, {38.0f, 40.0f, 119.0f}, {36.0f, 42.0f, 120.0f}, {34.0f, 44.0f, 120.0f}, {33.0f, 46.0f, 120.0f}, {32.0f, 47.0f, 120.0f}, {31.0f, 49.0f, 121.0f}, {30.0f, 50.0f, 122.0f}, {30.0f, 51.0f, 123.0f}, {29.0f, 52.0f, 123.0f}, {29.0f, 53.0f, 125.0f}, {28.0f, 55.0f, 125.0f}, {28.0f, 56.0f, 126.0f}, {27.0f, 57.0f, 127.0f}, {28.0f, 58.0f, 128.0f}, {28.0f, 59.0f, 129.0f}, {27.0f, 60.0f, 129.0f}, {27.0f, 61.0f, 131.0f}, {27.0f, 62.0f, 132.0f}, {27.0f, 63.0f, 133.0f}, {28.0f, 64.0f, 134.0f}, {27.0f, 65.0f, 135.0f}, {27.0f, 66.0f, 136.0f}, {27.0f, 68.0f, 137.0f}, {27.0f, 69.0f, 138.0f}, {25.0f, 71.0f, 136.0f}, {22.0f, 73.0f, 134.0f}, {21.0f, 74.0f, 133.0f}, {20.0f, 76.0f, 131.0f}, {17.0f, 78.0f, 129.0f}, {16.0f, 79.0f, 128.0f}, {15.0f, 81.0f, 126.0f}, {14.0f, 82.0f, 125.0f}, {10.0f, 84.0f, 123.0f}, {10.0f, 85.0f, 122.0f}, {9.0f, 87.0f, 120.0f}, {8.0f, 88.0f, 119.0f}, {7.0f, 89.0f, 118.0f}, {6.0f, 91.0f, 117.0f}, {4.0f, 92.0f, 115.0f}, {4.0f, 94.0f, 114.0f}, {4.0f, 95.0f, 114.0f}, {3.0f, 96.0f, 112.0f}, {1.0f, 98.0f, 111.0f}, {1.0f, 99.0f, 110.0f}, {0.0f, 100.0f, 109.0f}, {0.0f, 101.0f, 108.0f}, {0.0f, 103.0f, 107.0f}, {0.0f, 104.0f, 106.0f}, {0.0f, 105.0f, 105.0f}, {0.0f, 107.0f, 104.0f}, {0.0f, 108.0f, 101.0f}, {0.0f, 110.0f, 100.0f}, {0.0f, 111.0f, 99.0f}, {0.0f, 112.0f, 98.0f}, {0.0f, 114.0f, 96.0f}, {0.0f, 115.0f, 95.0f}, {0.0f, 116.0f, 93.0f}, {0.0f, 118.0f, 92.0f}, {0.0f, 119.0f, 90.0f}, {0.0f, 120.0f, 89.0f}, {0.0f, 121.0f, 88.0f}, {0.0f, 123.0f, 86.0f}, {0.0f, 124.0f, 85.0f}, {0.0f, 125.0f, 83.0f}, {0.0f, 127.0f, 82.0f}, {0.0f, 128.0f, 80.0f}, {0.0f, 129.0f, 79.0f}, {0.0f, 131.0f, 77.0f}, {0.0f, 132.0f, 75.0f}, {0.0f, 133.0f, 73.0f}, {0.0f, 134.0f, 72.0f}, {0.0f, 136.0f, 70.0f}, {0.0f, 137.0f, 68.0f}, {0.0f, 138.0f, 66.0f}, {0.0f, 139.0f, 65.0f}, {0.0f, 141.0f, 64.0f}, {0.0f, 142.0f, 63.0f}, {0.0f, 143.0f, 61.0f}, {0.0f, 145.0f, 60.0f}, {0.0f, 146.0f, 60.0f}, {0.0f, 147.0f, 58.0f}, {0.0f, 149.0f, 57.0f}, {0.0f, 150.0f, 56.0f}, {0.0f, 151.0f, 55.0f}, {0.0f, 153.0f, 53.0f}, {0.0f, 154.0f, 52.0f}, {0.0f, 155.0f, 51.0f}, {0.0f, 157.0f, 50.0f}, {0.0f, 158.0f, 48.0f}, {0.0f, 159.0f, 47.0f}, {0.0f, 160.0f, 45.0f}, {0.0f, 162.0f, 44.0f}, {0.0f, 163.0f, 42.0f}, {0.0f, 164.0f, 41.0f}, {0.0f, 165.0f, 39.0f}, {0.0f, 167.0f, 36.0f}, {0.0f, 168.0f, 34.0f}, {0.0f, 169.0f, 31.0f}, {0.0f, 170.0f, 23.0f}, {0.0f, 169.0f, 8.0f}, {9.0f, 170.0f, 0.0f}, {20.0f, 171.0f, 0.0f}, {29.0f, 172.0f, 0.0f}, {35.0f, 173.0f, 0.0f}, {40.0f, 174.0f, 0.0f}, {45.0f, 175.0f, 0.0f}, {48.0f, 176.0f, 0.0f}, {52.0f, 177.0f, 0.0f}, {55.0f, 178.0f, 0.0f}, {59.0f, 179.0f, 0.0f}, {61.0f, 180.0f, 0.0f}, {64.0f, 181.0f, 0.0f}, {66.0f, 182.0f, 0.0f}, {68.0f, 183.0f, 0.0f}, {71.0f, 184.0f, 0.0f}, {73.0f, 185.0f, 0.0f}, {76.0f, 186.0f, 0.0f}, {78.0f, 187.0f, 0.0f}, {79.0f, 188.0f, 0.0f}, {81.0f, 189.0f, 0.0f}, {83.0f, 190.0f, 0.0f}, {85.0f, 191.0f, 0.0f}, {87.0f, 192.0f, 0.0f}, {92.0f, 193.0f, 0.0f}, {99.0f, 193.0f, 0.0f}, {106.0f, 193.0f, 0.0f}, {114.0f, 193.0f, 0.0f}, {119.0f, 194.0f, 0.0f}, {125.0f, 194.0f, 0.0f}, {130.0f, 194.0f, 0.0f}, {135.0f, 195.0f, 0.0f}, {140.0f, 195.0f, 0.0f}, {145.0f, 195.0f, 0.0f}, {149.0f, 196.0f, 0.0f}, {153.0f, 196.0f, 0.0f}, {157.0f, 197.0f, 0.0f}, {161.0f, 197.0f, 0.0f}, {165.0f, 197.0f, 0.0f}, {169.0f, 198.0f, 0.0f}, {172.0f, 198.0f, 0.0f}, {176.0f, 199.0f, 0.0f}, {180.0f, 199.0f, 0.0f}, {184.0f, 199.0f, 0.0f}, {186.0f, 200.0f, 0.0f}, {190.0f, 201.0f, 0.0f}, {193.0f, 201.0f, 0.0f}, {197.0f, 201.0f, 0.0f}, {200.0f, 202.0f, 0.0f}, {201.0f, 201.0f, 24.0f}, {203.0f, 202.0f, 51.0f}, {206.0f, 202.0f, 65.0f}, {207.0f, 203.0f, 77.0f}, {209.0f, 203.0f, 87.0f}, {212.0f, 203.0f, 95.0f}, {213.0f, 204.0f, 103.0f}, {215.0f, 205.0f, 109.0f}, {218.0f, 205.0f, 116.0f}, {219.0f, 206.0f, 121.0f}, {221.0f, 207.0f, 127.0f}, {223.0f, 207.0f, 132.0f}, {226.0f, 207.0f, 138.0f}, {227.0f, 208.0f, 143.0f}, {229.0f, 209.0f, 147.0f}, {231.0f, 209.0f, 151.0f}, {232.0f, 210.0f, 155.0f}, {235.0f, 211.0f, 159.0f}, {237.0f, 211.0f, 164.0f}, {238.0f, 212.0f, 168.0f}, {240.0f, 212.0f, 172.0f}, {243.0f, 213.0f, 175.0f}, {243.0f, 214.0f, 179.0f}, {245.0f, 214.0f, 183.0f}, {248.0f, 215.0f, 186.0f}, {248.0f, 216.0f, 189.0f}, {248.0f, 218.0f, 193.0f}, {247.0f, 219.0f, 195.0f}, {247.0f, 220.0f, 198.0f}, {247.0f, 222.0f, 201.0f}, {248.0f, 223.0f, 204.0f}, {247.0f, 224.0f, 206.0f}, {247.0f, 226.0f, 209.0f}, {247.0f, 227.0f, 211.0f}, {247.0f, 229.0f, 214.0f}, {247.0f, 230.0f, 216.0f}, {247.0f, 231.0f, 218.0f}, {247.0f, 232.0f, 220.0f}, {248.0f, 234.0f, 224.0f}, {247.0f, 235.0f, 225.0f}, {247.0f, 236.0f, 229.0f}, {247.0f, 238.0f, 231.0f}, {247.0f, 239.0f, 232.0f}, {248.0f, 240.0f, 235.0f}, {248.0f, 242.0f, 237.0f}, {247.0f, 243.0f, 239.0f}, {248.0f, 244.0f, 241.0f}, {248.0f, 246.0f, 244.0f}, {248.0f, 247.0f, 246.0f}, {248.0f, 248.0f, 248.0f}, {249.0f, 249.0f, 249.0f}, {251.0f, 251.0f, 251.0f}, {252.0f, 252.0f, 252.0f}, {253.0f, 253.0f, 253.0f}, {254.0f, 254.0f, 254.0f}, {255.0f, 255.0f, 255.0f}};
    private static Recipe[] namedPalettes = new Recipe[]{new Recipe("BlueToYellow", paletteB2Y), new Recipe("PurpleTones", purpleTones), new Recipe("RedToYellowToWhite", redToYellowToWhite), new Recipe("Rainbow", rainbow), new Recipe("LinearGray", linearGray), new Recipe("Elevation", topoElev), new Recipe("MonotonicLuminance", monotonicLuminance)};
    private final float[][] palette;
    private final String name;

    public TestPalette(String name, float[][] rgb) {
        this.name = name == null || name.trim().isEmpty() ? "Unnamed" : name;
        this.palette = new float[rgb.length][3];
        for (int i = 0; i < rgb.length; ++i) {
            this.palette[i] = Arrays.copyOf(rgb[i], 3);
        }
    }

    public static TestPalette getBlueToYellowPalette() {
        return new TestPalette("BlueToYellow", paletteB2Y);
    }

    public static TestPalette getDefaultPalette() {
        return TestPalette.getRainbowPalette();
    }

    public static TestPalette getPurpleTonesPalette() {
        return new TestPalette("PurpleTones", purpleTones);
    }

    public static TestPalette getRedToYellowToWhitePalette() {
        return new TestPalette("RedToYellowToWhite", redToYellowToWhite);
    }

    public static TestPalette getRainbowPalette() {
        return new TestPalette("Rainbow", rainbow);
    }

    public static TestPalette getLinearGrayPalette() {
        return new TestPalette("Linear Gray", linearGray);
    }

    public TestPalette() {
        this.name = "Default";
        this.palette = paletteB2Y;
    }

    public int getARGB(double z, double zMin, double zMax) {
        int b;
        int g;
        int r;
        double t = (double)(this.palette.length - 1) * (z - zMin) / (zMax - zMin);
        if (Double.isNaN(t)) {
            return 0;
        }
        if (t <= 0.0) {
            r = (int)this.palette[0][0];
            g = (int)this.palette[0][1];
            b = (int)this.palette[0][2];
        } else if (t >= (double)(this.palette.length - 1)) {
            r = (int)this.palette[this.palette.length - 1][0];
            g = (int)this.palette[this.palette.length - 1][1];
            b = (int)this.palette[this.palette.length - 1][2];
        } else {
            int i = (int)Math.floor(t);
            double s = t - (double)i;
            r = (int)(s * (double)(this.palette[i + 1][0] - this.palette[i][0]) + (double)this.palette[i][0]);
            g = (int)(s * (double)(this.palette[i + 1][1] - this.palette[i][1]) + (double)this.palette[i][1]);
            b = (int)(s * (double)(this.palette[i + 1][2] - this.palette[i][2]) + (double)this.palette[i][2]);
        }
        return ((0xFF00 | r) << 8 | g) << 8 | b;
    }

    public Color getColor(double z, double zMin, double zMax) {
        return new Color(this.getARGB(z, zMin, zMax));
    }

    public static TestPalette getPaletteByName(String paletteName) {
        if (paletteName == null || paletteName.isEmpty()) {
            throw new NullPointerException("Null or empty specification for palette name");
        }
        String s = paletteName.trim();
        for (Recipe r : namedPalettes) {
            if (!r.name.equalsIgnoreCase(s)) continue;
            return r.palette;
        }
        return null;
    }

    public static List<String> getPaletteNames() {
        ArrayList<String> aList = new ArrayList<String>();
        for (Recipe r : namedPalettes) {
            aList.add(r.name);
        }
        return aList;
    }

    public String getName() {
        return this.name;
    }

    public static Icon getIconByName(String name, int width, int height) {
        TestPalette p = TestPalette.getPaletteByName(name);
        if (p == null) {
            return null;
        }
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics g = bImage.getGraphics();
        for (int i = 0; i < width; ++i) {
            Color c = p.getColor(i, 0.0, width - 1);
            g.setColor(c);
            g.drawRect(i, 0, 2, height + 1);
        }
        return new ImageIcon(bImage);
    }

    public static void loadRecipiesFromStream(InputStream ins, boolean flip) throws IOException, NumberFormatException {
        DelimitedReader reader = new DelimitedReader(ins, ',');
        ArrayList<Recipe> rList = new ArrayList<Recipe>();
        for (int i = 0; i < namedPalettes.length; ++i) {
            rList.add(namedPalettes[i]);
        }
        List<String> list = reader.readStrings();
        while (!(list = reader.readStrings()).isEmpty()) {
            String name = list.get(0);
            int count = Integer.parseInt(list.get(1));
            float[][] rgb = new float[count][3];
            int k = flip ? count - 1 : 0;
            rgb[k][0] = Integer.parseInt(list.get(2));
            rgb[k][1] = Integer.parseInt(list.get(3));
            rgb[k][2] = Integer.parseInt(list.get(4));
            for (int i = 1; i < count; ++i) {
                k = flip ? count - 1 - i : i;
                list = reader.readStrings();
                if (list.isEmpty()) break;
                rgb[k][0] = Integer.parseInt(list.get(2));
                rgb[k][1] = Integer.parseInt(list.get(3));
                rgb[k][2] = Integer.parseInt(list.get(4));
            }
            rList.add(new Recipe(name, rgb));
        }
        namedPalettes = rList.toArray(new Recipe[rList.size()]);
    }

    private static class Recipe {
        final String name;
        final TestPalette palette;

        Recipe(String name, float[][] rgb) {
            this.name = name;
            this.palette = new TestPalette(name, rgb);
        }
    }
}

