/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils.cdt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.tinfour.common.IConstraint;
import org.tinfour.common.LinearConstraint;
import org.tinfour.common.PolyLineConstraintAdapter;
import org.tinfour.common.PolygonConstraint;
import org.tinfour.common.Vertex;
import org.tinfour.gis.utils.ConstraintReaderShapefile;
import org.tinfour.io.DelimitedReader;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;

public class ConstraintLoader {
    private int nPointsTotal;
    double xClipMin;
    double xClipMax;
    double yClipMin;
    double yClipMax;
    boolean isSourceInGeographicCoordinates;
    ICoordinateTransform coordinateTransform;

    private String getFileExtension(File file) {
        String name;
        int i;
        if (file != null && (i = (name = file.getName()).lastIndexOf(46)) > 0 && i < name.length() - 1) {
            return name.substring(i + 1, name.length());
        }
        return null;
    }

    public List<IConstraint> readConstraintsFile(File file) throws IOException {
        String ext = this.getFileExtension(file);
        if ("shp".equalsIgnoreCase(ext)) {
            try (ConstraintReaderShapefile crs = new ConstraintReaderShapefile(file);){
                crs.setCoordinateTransform(this.coordinateTransform);
                List<IConstraint> list = crs.read();
                return list;
            }
        }
        if ("txt".equalsIgnoreCase(ext)) {
            return this.readTextFile(file);
        }
        if ("csv".equalsIgnoreCase(ext)) {
            return this.readTextFile(file);
        }
        return null;
    }

    public int getTotalPointCount() {
        return this.nPointsTotal;
    }

    private void processLine(DelimitedReader reader, int vertexID, List<String> sList, List<Vertex> vList) throws IOException {
        if (sList.size() != 3) {
            throw new IOException("Invalid entry where x,y,z coordinates expected on line " + reader.getLineNumber());
        }
        try {
            double x = Double.parseDouble(sList.get(0));
            double y = Double.parseDouble(sList.get(1));
            double z = Double.parseDouble(sList.get(2));
            if (this.coordinateTransform != null) {
                CoordinatePair cPair = new CoordinatePair();
                this.coordinateTransform.forward(x, y, cPair);
                x = cPair.x;
                y = cPair.y;
            }
            Vertex v = new Vertex(x, y, z, vertexID);
            vList.add(v);
        }
        catch (NumberFormatException nex) {
            throw new IOException("Invalid entry where x,y,z coordinates expected on line " + reader.getLineNumber(), nex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IConstraint> readTextFile(File file) throws IOException {
        ArrayList<IConstraint> conList = new ArrayList<IConstraint>();
        DelimitedReader reader = null;
        int vertexID = 0;
        ArrayList<String> sList = new ArrayList<String>();
        try {
            reader = new DelimitedReader(file, ',');
            int nCon = 0;
            ArrayList<Vertex> vList = new ArrayList<Vertex>();
            reader.readStrings(sList);
            if (sList.isEmpty()) {
                throw new IOException("Empty constraint file " + file.getAbsolutePath());
            }
            if (sList.size() == 3) {
                this.processLine(reader, vertexID++, sList, vList);
                while (true) {
                    reader.readStrings(sList);
                    if (sList.isEmpty()) break;
                    this.processLine(reader, vertexID++, sList, vList);
                }
                PolyLineConstraintAdapter con = vList.size() > 3 && ((Vertex)vList.get(0)).getDistance((Vertex)vList.get(vList.size() - 1)) < 1.0E-32 ? new PolygonConstraint() : new LinearConstraint();
                con.setApplicationData(nCon);
                for (Vertex v : vList) {
                    con.add(v);
                }
                conList.add(con);
                con.complete();
                ArrayList<IConstraint> arrayList = conList;
                return arrayList;
            }
            while (!sList.isEmpty()) {
                PolyLineConstraintAdapter con;
                int nPoints;
                boolean linearSpecified;
                boolean polygonSpecified;
                if (sList.size() < 3) {
                    polygonSpecified = false;
                    linearSpecified = false;
                    String s = (String)sList.get(0);
                    try {
                        nPoints = Integer.parseInt(s);
                    }
                    catch (NumberFormatException nex) {
                        throw new IOException("Invalid entry for point count,\"" + s + "\" on line " + reader.getLineNumber(), nex);
                    }
                    if (sList.size() > 1) {
                        s = (String)sList.get(1);
                        if ("polygon".equalsIgnoreCase(s)) {
                            polygonSpecified = true;
                        } else if ("linear".equalsIgnoreCase(s)) {
                            linearSpecified = true;
                        }
                    }
                } else {
                    throw new IOException("Invalid entry for point count; a single string is expected on line " + reader.getLineNumber());
                }
                for (int i = 0; i < nPoints; ++i) {
                    reader.readStrings(sList);
                    this.processLine(reader, vertexID++, sList, vList);
                }
                if (polygonSpecified) {
                    if (nPoints < 3) {
                        throw new IOException("Fewer than 3 distinct points specified for polygon");
                    }
                    con = new PolygonConstraint(vList);
                } else {
                    con = linearSpecified ? new LinearConstraint(vList) : (nPoints > 3 && ((Vertex)vList.get(0)).getDistance((Vertex)vList.get(1)) < 1.0E-23 ? new PolygonConstraint(vList) : new LinearConstraint(vList));
                }
                vList.clear();
                con.setApplicationData(nCon);
                ++nCon;
                con.complete();
                conList.add(con);
                reader.readStrings(sList);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException dontCare) {}
            }
        }
        return conList;
    }

    public static void writeConstraintFile(File file, List<IConstraint> list) throws IOException {
        Path path = file.toPath();
        ConstraintLoader.writeConstraintFile(path, list);
    }

    public static void writeConstraintFile(Path path, List<IConstraint> list) throws IOException {
        try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (IConstraint constraint : list) {
                List<Vertex> vertices = constraint.getVertices();
                String conType = "";
                if (constraint instanceof PolygonConstraint) {
                    conType = ", polygon";
                } else if (constraint instanceof LinearConstraint) {
                    conType = ", linear";
                }
                w.write(String.format(Locale.ENGLISH, "%d%s%n", vertices.size(), conType));
                for (Vertex vertex : vertices) {
                    w.write(String.format(Locale.ENGLISH, "%s,%s,%s%n", vertex.x, vertex.y, vertex.getZ()));
                }
            }
        }
    }

    public void setCoordinateTransform(ICoordinateTransform transform) {
        this.coordinateTransform = transform;
    }
}

