/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.tinfour.demo.viewer.backplane.MvComposite;
import org.tinfour.demo.viewer.backplane.RenderProductType;

public class RenderProduct {
    public RenderProductType layerType;
    public MvComposite composite;
    public AffineTransform compatibilityTransform;
    public BufferedImage image;

    RenderProduct(RenderProductType layerType, MvComposite composite, BufferedImage image) {
        this.layerType = layerType;
        this.composite = composite;
        Shape clipMask = composite.getClipMask();
        if (clipMask == null || layerType == RenderProductType.Constraints) {
            this.image = image;
        } else {
            BufferedImage b = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D g2d = b.createGraphics();
            g2d.setClip(clipMask);
            g2d.drawImage((Image)image, 0, 0, null);
            this.image = b;
        }
    }
}

