/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer.backplane;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.tinfour.demo.utils.TestPalette;
import org.tinfour.demo.viewer.backplane.LidarPointSelection;

public class ViewOptions {
    private int foregroundBackgroundOption;
    private Color foreground = Color.black;
    private Color background = Color.white;
    private String paletteName;
    private boolean useRangeOfValuesForPalette;
    private double[] rangeForPalette;
    private boolean isWireframeSelected;
    private boolean isEdgeRenderingSelected;
    private boolean isVertexRenderingSelected;
    private boolean isLabelRenderingSelected;
    private String fieldForLabel;
    private boolean usePaletteForWireframe;
    private boolean isConstraintRenderingSelected;
    private Color constraintColor = Color.red;
    private boolean isRasterSelected;
    private boolean isHillshadeSelected;
    private double hillshadeAzimuth;
    private double hillshadeElevation;
    private double hillshadeAmbient;
    private RasterInterpolationMethod rasterInterpolationMethod;
    private boolean isFullResolutionGridSelected;
    private SampleThinning wireframeSampleThinning = SampleThinning.Medium;
    private LidarPointSelection lidarPointSelection = LidarPointSelection.GroundPoints;
    private boolean isClipOnConstraintsSelected;

    public ViewOptions(ViewOptions v) {
        this.foregroundBackgroundOption = v.foregroundBackgroundOption;
        this.foreground = v.foreground;
        this.background = v.background;
        this.paletteName = v.paletteName;
        this.useRangeOfValuesForPalette = v.useRangeOfValuesForPalette;
        this.rangeForPalette = Arrays.copyOf(v.rangeForPalette, 2);
        this.isWireframeSelected = v.isWireframeSelected;
        this.wireframeSampleThinning = v.wireframeSampleThinning;
        this.isEdgeRenderingSelected = v.isEdgeRenderingSelected;
        this.isVertexRenderingSelected = v.isVertexRenderingSelected;
        this.isLabelRenderingSelected = v.isLabelRenderingSelected;
        this.fieldForLabel = v.fieldForLabel;
        this.usePaletteForWireframe = v.usePaletteForWireframe;
        this.isConstraintRenderingSelected = v.isConstraintRenderingSelected;
        this.constraintColor = v.constraintColor;
        this.isRasterSelected = v.isRasterSelected;
        this.isHillshadeSelected = v.isHillshadeSelected;
        this.hillshadeAzimuth = v.hillshadeAzimuth;
        this.hillshadeElevation = v.hillshadeElevation;
        this.hillshadeAmbient = v.hillshadeAmbient;
        this.isFullResolutionGridSelected = v.isFullResolutionGridSelected;
        this.isClipOnConstraintsSelected = v.isClipOnConstraintsSelected;
        this.lidarPointSelection = v.lidarPointSelection;
        this.rasterInterpolationMethod = v.rasterInterpolationMethod;
    }

    public ViewOptions() {
        List<String> paletteNames = TestPalette.getPaletteNames();
        this.paletteName = paletteNames.get(0);
        this.foregroundBackgroundOption = 0;
        this.foreground = Color.black;
        this.background = Color.white;
        this.useRangeOfValuesForPalette = false;
        this.rangeForPalette = new double[2];
        this.rangeForPalette[0] = 0.0;
        this.rangeForPalette[1] = 8000.0;
        this.isWireframeSelected = true;
        this.isEdgeRenderingSelected = true;
        this.isVertexRenderingSelected = true;
        this.isLabelRenderingSelected = true;
        this.fieldForLabel = "Z";
        this.usePaletteForWireframe = false;
        this.isRasterSelected = true;
        this.isHillshadeSelected = false;
        this.hillshadeAzimuth = 135.0;
        this.hillshadeElevation = 45.0;
        this.hillshadeAmbient = 25.0;
        this.lidarPointSelection = LidarPointSelection.GroundPoints;
        this.rasterInterpolationMethod = RasterInterpolationMethod.NaturalNeighbor;
    }

    public int getForegroundBackgroundOption() {
        return this.foregroundBackgroundOption;
    }

    public void setForegroundBackgroundOption(int foregroundBackgroundOption) {
        this.foregroundBackgroundOption = foregroundBackgroundOption;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public String getPaletteName() {
        return this.paletteName;
    }

    public void setPaletteName(String paletteName) {
        this.paletteName = paletteName;
    }

    public boolean useRangeOfValuesForPalette() {
        return this.useRangeOfValuesForPalette;
    }

    public void setUseRangeOfValuesForPalette(boolean useRangeOfValuesForPalette) {
        this.useRangeOfValuesForPalette = useRangeOfValuesForPalette;
    }

    public double[] getRangeForPalette() {
        return Arrays.copyOf(this.rangeForPalette, this.rangeForPalette.length);
    }

    public void setRangeForPalette(double[] rangeForPalette) {
        this.rangeForPalette = Arrays.copyOf(rangeForPalette, rangeForPalette.length);
    }

    public boolean isWireframeSelected() {
        return this.isWireframeSelected;
    }

    public void setWireframeSelected(boolean isWireframeSelected) {
        this.isWireframeSelected = isWireframeSelected;
    }

    public boolean isEdgeRenderingSelected() {
        return this.isEdgeRenderingSelected;
    }

    public void setEdgeRenderingSelected(boolean isEdgeRenderingSelected) {
        this.isEdgeRenderingSelected = isEdgeRenderingSelected;
    }

    public boolean isVertexRenderingSelected() {
        return this.isVertexRenderingSelected;
    }

    public void setVertexRenderingSelected(boolean isVertexRenderingSelected) {
        this.isVertexRenderingSelected = isVertexRenderingSelected;
    }

    public boolean isLabelRenderingSelected() {
        return this.isLabelRenderingSelected;
    }

    public void setLabelRenderingSelected(boolean isLabelRenderingSelected) {
        this.isLabelRenderingSelected = isLabelRenderingSelected;
    }

    public String getFieldForLabel() {
        return this.fieldForLabel;
    }

    public void setFieldForLabel(String fieldForLabel) {
        this.fieldForLabel = fieldForLabel;
    }

    public boolean usePaletteForWireframe() {
        return this.usePaletteForWireframe;
    }

    public void setUsePaletteForWireframe(boolean usePaletteForWireframe) {
        this.usePaletteForWireframe = usePaletteForWireframe;
    }

    public boolean isRasterSelected() {
        return this.isRasterSelected;
    }

    public void setRasterSelected(boolean isRasterSelected) {
        this.isRasterSelected = isRasterSelected;
    }

    public boolean isHillshadeSelected() {
        return this.isHillshadeSelected;
    }

    public void setHillshadeSelected(boolean isHillshadeSelected) {
        this.isHillshadeSelected = isHillshadeSelected;
    }

    public double getHillshadeAzimuth() {
        return this.hillshadeAzimuth;
    }

    public void setHillshadeAzimuth(double hillshadeAzimuth) {
        this.hillshadeAzimuth = hillshadeAzimuth;
    }

    public double getHillshadeElevation() {
        return this.hillshadeElevation;
    }

    public void setHillshadeElevation(double hillshadeElevation) {
        this.hillshadeElevation = hillshadeElevation;
    }

    public double getHillshadeAmbient() {
        return this.hillshadeAmbient;
    }

    public void setHillshadeAmbient(double hillshadeAmbient) {
        this.hillshadeAmbient = hillshadeAmbient;
    }

    public boolean isFullResolutionGridSelected() {
        return this.isFullResolutionGridSelected;
    }

    public void setFullResolutionGridSelected(boolean status) {
        this.isFullResolutionGridSelected = status;
    }

    public boolean isClipOnConstraintsSelected() {
        return this.isClipOnConstraintsSelected;
    }

    public void setClipOnConstraintsSelected(boolean status) {
        this.isClipOnConstraintsSelected = status;
    }

    public LidarPointSelection getLidarPointSelection() {
        return this.lidarPointSelection;
    }

    public void setLidarPointSelection(LidarPointSelection selection) {
        this.lidarPointSelection = selection;
    }

    public boolean isGridBasedRenderingSelected() {
        return this.isRasterSelected || this.isHillshadeSelected;
    }

    public int getPadding() {
        return 150;
    }

    public void setWireframeSampleThinning(SampleThinning sampleThinning) {
        this.wireframeSampleThinning = sampleThinning;
    }

    public SampleThinning getWireframeSampleThinning() {
        return this.wireframeSampleThinning;
    }

    public int getWireframeSampleSpacing() {
        switch (this.wireframeSampleThinning) {
            case Medium: {
                return 50;
            }
            case Fine: {
                return 35;
            }
            case ExtraFine: {
                return 24;
            }
        }
        return 50;
    }

    public RasterInterpolationMethod getRasterInterpolationMethod() {
        return this.rasterInterpolationMethod;
    }

    public void setRasterInterpolationMethod(RasterInterpolationMethod method) {
        this.rasterInterpolationMethod = method;
    }

    public boolean isConstraintRenderingSelected() {
        return this.isConstraintRenderingSelected;
    }

    public void setConstraintRenderingSelected(boolean isConstraintRenderingSelected) {
        this.isConstraintRenderingSelected = isConstraintRenderingSelected;
    }

    public Color getConstraintColor() {
        return this.constraintColor;
    }

    public void setConstraintColor(Color constraintColor) {
        this.constraintColor = constraintColor;
    }

    public static enum RasterInterpolationMethod {
        NaturalNeighbor,
        GeographicallyWeightedRegression,
        TriangularFacet;

    }

    public static enum SampleThinning {
        Medium,
        Fine,
        ExtraFine;

    }
}

