/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.standard;

import java.io.PrintStream;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.Thresholds;
import org.tinfour.common.Vertex;
import org.tinfour.edge.QuadEdge;

public class StochasticLawsonsWalk {
    private final double halfPlaneThreshold;
    private final double halfPlaneThresholdNeg;
    private int nSLWSteps;
    private int nSLW;
    private int nSLWTests;
    private int nSLWGhost;
    private final GeometricOperations geoOp;
    private long seed = 1L;

    public StochasticLawsonsWalk(double nominalPointSpacing) {
        Thresholds thresholds = new Thresholds(nominalPointSpacing);
        this.geoOp = new GeometricOperations(thresholds);
        this.halfPlaneThreshold = thresholds.getHalfPlaneThreshold();
        this.halfPlaneThresholdNeg = -thresholds.getHalfPlaneThreshold();
    }

    public StochasticLawsonsWalk() {
        Thresholds thresholds = new Thresholds(1.0);
        this.geoOp = new GeometricOperations(thresholds);
        this.halfPlaneThreshold = thresholds.getHalfPlaneThreshold();
        this.halfPlaneThresholdNeg = -thresholds.getHalfPlaneThreshold();
    }

    StochasticLawsonsWalk(Thresholds thresholds) {
        this.geoOp = new GeometricOperations(thresholds);
        this.halfPlaneThreshold = thresholds.getHalfPlaneThreshold();
        this.halfPlaneThresholdNeg = -thresholds.getHalfPlaneThreshold();
    }

    public QuadEdge findAnEdgeFromEnclosingTriangle(QuadEdge startingEdge, double x, double y) {
        QuadEdge edge = startingEdge;
        if (edge.getForward().getB() == null) {
            edge = edge.getDual();
        }
        ++this.nSLW;
        Vertex v0 = edge.getA();
        Vertex v1 = edge.getB();
        double vX0 = x - v0.x;
        double vY0 = y - v0.y;
        double pX0 = v0.y - v1.y;
        double pY0 = v1.x - v0.x;
        double h0 = vX0 * pX0 + vY0 * pY0;
        ++this.nSLWTests;
        if (h0 < this.halfPlaneThresholdNeg) {
            edge = edge.getDual();
            v0 = edge.getA();
        } else if (h0 < this.halfPlaneThreshold && (h0 = this.geoOp.halfPlane(v0.x, v0.y, v1.x, v1.y, x, y)) < 0.0) {
            edge = edge.getDual();
            v0 = edge.getA();
        }
        while (true) {
            double h2;
            double pY2;
            double vY2;
            double pX2;
            double vX2;
            double h1;
            double pY1;
            double vY1;
            double pX1;
            double vX1;
            ++this.nSLWSteps;
            v1 = edge.getB();
            Vertex v2 = edge.getForward().getB();
            if (v2 == null) {
                return this.findAssociatedPerimeterEdge(edge, x, y);
            }
            long edgeSelectionForNextTest = this.randomNext();
            if ((edgeSelectionForNextTest & 1L) == 0L) {
                ++this.nSLWTests;
                vX1 = x - v1.x;
                pX1 = v1.y - v2.y;
                vY1 = y - v1.y;
                pY1 = v2.x - v1.x;
                h1 = vX1 * pX1 + vY1 * pY1;
                if (h1 < this.halfPlaneThresholdNeg) {
                    edge = edge.getForward().getDual();
                    v0 = edge.getA();
                    continue;
                }
                if (h1 < this.halfPlaneThreshold && (h1 = this.geoOp.halfPlane(v1.x, v1.y, v2.x, v2.y, x, y)) < 0.0) {
                    edge = edge.getForward().getDual();
                    v0 = edge.getA();
                    continue;
                }
                ++this.nSLWTests;
                vX2 = x - v2.x;
                pX2 = v2.y - v0.y;
                vY2 = y - v2.y;
                pY2 = v0.x - v2.x;
                h2 = vX2 * pX2 + vY2 * pY2;
                if (h2 < this.halfPlaneThresholdNeg) {
                    edge = edge.getReverse().getDual();
                    v0 = edge.getA();
                    continue;
                }
                if (!(h2 < this.halfPlaneThreshold) || !((h2 = this.geoOp.halfPlane(v2.x, v2.y, v0.x, v0.y, x, y)) < 0.0)) break;
                edge = edge.getReverse().getDual();
                v0 = edge.getA();
                continue;
            }
            ++this.nSLWTests;
            vX2 = x - v2.x;
            pX2 = v2.y - v0.y;
            vY2 = y - v2.y;
            pY2 = v0.x - v2.x;
            h2 = vX2 * pX2 + vY2 * pY2;
            if (h2 < this.halfPlaneThresholdNeg) {
                edge = edge.getReverse().getDual();
                v0 = edge.getA();
                continue;
            }
            if (h2 < this.halfPlaneThreshold && (h2 = this.geoOp.halfPlane(v2.x, v2.y, v0.x, v0.y, x, y)) < 0.0) {
                edge = edge.getReverse().getDual();
                v0 = edge.getA();
                continue;
            }
            ++this.nSLWTests;
            vX1 = x - v1.x;
            pX1 = v1.y - v2.y;
            vY1 = y - v1.y;
            pY1 = v2.x - v1.x;
            h1 = vX1 * pX1 + vY1 * pY1;
            if (h1 < this.halfPlaneThresholdNeg) {
                edge = edge.getForward().getDual();
                v0 = edge.getA();
                continue;
            }
            if (!(h1 < this.halfPlaneThreshold) || !((h1 = this.geoOp.halfPlane(v1.x, v1.y, v2.x, v2.y, x, y)) < 0.0)) break;
            edge = edge.getForward().getDual();
            v0 = edge.getA();
        }
        return edge;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QuadEdge findAssociatedPerimeterEdge(QuadEdge startingEdge, double x, double y) {
        QuadEdge edge = startingEdge;
        ++this.nSLWGhost;
        Vertex v0 = edge.getA();
        Vertex v1 = edge.getB();
        double tX = v1.x - v0.x;
        double vX0 = x - v0.x;
        double tY = v1.y - v0.y;
        double vY0 = y - v0.y;
        double tC = tX * vX0 + tY * vY0;
        if (this.halfPlaneThresholdNeg < tC && tC < this.halfPlaneThreshold) {
            tC = this.geoOp.direction(v0.x, v0.y, v1.x, v1.y, x, y);
        }
        if (tC < 0.0) {
            do {
                ++this.nSLWSteps;
                QuadEdge nEdge = edge.getReverse().getReverseFromDual();
                v0 = nEdge.getA();
                v1 = nEdge.getB();
                tY = v1.y - v0.y;
                double pX = -tY;
                vX0 = x - v0.x;
                tX = v1.x - v0.x;
                double pY = tX;
                vY0 = y - v0.y;
                double h = pX * vX0 + pY * vY0;
                if (h < this.halfPlaneThresholdNeg || h < this.halfPlaneThreshold && (h = this.geoOp.halfPlane(v0.x, v0.y, v1.x, v1.y, x, y)) <= 0.0) return edge;
                edge = nEdge;
            } while (!((tC = tX * vX0 + tY * vY0) > this.halfPlaneThreshold) && (!(tC > this.halfPlaneThresholdNeg) || !((tC = this.geoOp.direction(v0.x, v0.y, v1.x, v1.y, x, y)) >= 0.0)));
            return edge;
        } else {
            while (true) {
                ++this.nSLWSteps;
                QuadEdge nEdge = edge.getForward().getForwardFromDual();
                v0 = nEdge.getA();
                v1 = nEdge.getB();
                tY = v1.y - v0.y;
                double pX = -tY;
                vX0 = x - v0.x;
                tX = v1.x - v0.x;
                double pY = tX;
                vY0 = y - v0.y;
                double h = pX * vX0 + pY * vY0;
                if (h < this.halfPlaneThresholdNeg || h < this.halfPlaneThreshold && (h = this.geoOp.halfPlane(v0.x, v0.y, v1.x, v1.y, x, y)) <= 0.0 || (tC = tX * vX0 + tY * vY0) < this.halfPlaneThresholdNeg || tC < this.halfPlaneThreshold && (tC = this.geoOp.direction(v0.x, v0.y, v1.x, v1.y, x, y)) <= 0.0) return edge;
                edge = nEdge;
            }
        }
    }

    void clearDiagnostics() {
        this.geoOp.clearDiagnostics();
        this.nSLWSteps = 0;
        this.nSLW = 0;
        this.nSLWTests = 0;
        this.nSLWGhost = 0;
        this.seed = 1L;
    }

    public void printDiagnostics(PrintStream ps) {
        int nHalfPlaneCalls = this.geoOp.getHalfPlaneCount();
        double avgSLW = 0.0;
        if (this.nSLW > 0) {
            avgSLW = (double)this.nSLWSteps / (double)this.nSLW;
        }
        ps.format("Number of SLW walks:          %8d%n", this.nSLW);
        ps.format("   exterior phase:            %8d%n", this.nSLWGhost);
        ps.format("   tests:                     %8d%n", this.nSLWTests);
        ps.format("   extended:                  %8d%n", nHalfPlaneCalls);
        ps.format("   avg steps to completion:   %11.2f%n", avgSLW);
        ps.flush();
    }

    public void reset() {
        this.seed = 1L;
    }

    private long randomNext() {
        this.seed ^= this.seed << 21;
        this.seed ^= this.seed >>> 35;
        this.seed ^= this.seed << 4;
        return this.seed;
    }
}

