/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.utils;

import java.io.PrintStream;

public class TabulatorDelta {
    double sumD;
    double sumD2;
    double sumSignedD;
    double maxD = Double.NEGATIVE_INFINITY;
    double minD = Double.POSITIVE_INFINITY;
    double cD;
    double cD2;
    int nD;
    int nNaN;

    public void tabulate(double delta) {
        double d2 = delta * delta;
        double dAbs = Math.abs(delta);
        if (Double.isNaN(delta)) {
            ++this.nNaN;
        } else {
            ++this.nD;
            this.sumSignedD += delta;
            double y = dAbs - this.cD;
            double t = this.sumD + y;
            this.cD = t - this.sumD - y;
            this.sumD = t;
            y = d2 - this.cD2;
            t = this.sumD2 + y;
            this.cD2 = t - this.sumD2 - y;
            this.sumD2 = t;
            if (delta > this.maxD) {
                this.maxD = delta;
            }
            if (delta < this.minD) {
                this.minD = delta;
            }
        }
    }

    public void summarize(PrintStream ps, String label) {
        double meanE = 0.0;
        double sigma = 0.0;
        if (this.nD > 1) {
            meanE = this.sumD / (double)this.nD;
            sigma = Math.sqrt((this.sumD2 - this.sumD / (double)this.nD * this.sumD) / (double)(this.nD - 1));
        }
        ps.format("%s %13.6f %13.6f %10.3f %8.3f %9.3f%n", label, meanE, sigma, this.minD, this.maxD, this.sumSignedD);
    }

    public double getMeanAbsValue() {
        if (this.nD == 0) {
            return 0.0;
        }
        return this.sumD / (double)this.nD;
    }

    public double getStdDevAbsValue() {
        if (this.nD < 1) {
            return 0.0;
        }
        return Math.sqrt((this.sumD2 - this.sumD / (double)this.nD * this.sumD) / (double)(this.nD - 1));
    }

    public double getMinValue() {
        return this.minD;
    }

    public double getMaxValue() {
        return this.maxD;
    }

    public double getSumSignedValues() {
        return this.sumSignedD;
    }

    public int getNumberSamples() {
        return this.nD;
    }
}

