/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.demo.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultCaret;
import org.tinfour.demo.utils.TestPalette;
import org.tinfour.demo.viewer.DataViewingPanel;
import org.tinfour.demo.viewer.ExportControl;
import org.tinfour.demo.viewer.StatusPanel;
import org.tinfour.demo.viewer.ViewOptionsPanel;
import org.tinfour.demo.viewer.ZoomToFeaturePanel;
import org.tinfour.demo.viewer.backplane.IModel;
import org.tinfour.demo.viewer.backplane.UnitSquareModel;
import org.tinfour.demo.viewer.backplane.ViewOptions;

class DataViewerUI {
    private JFrame frame;
    private DataViewingPanel dvPanel;
    private JDialog viewOptionsDialog;
    private JDialog zoomToFeatureDialog;
    private ZoomToFeaturePanel zoomToFeaturePanel;
    private BufferedImage appIconImage;
    private ViewOptions viewOptions;
    private JFileChooser fileChooser;
    private JFileChooser constraintChooser;
    private File currentDirectory;
    private JDialog helpDialog;

    DataViewerUI() {
    }

    static String getFileExtension(File file) {
        String name;
        int i;
        if (file != null && (i = (name = file.getName()).lastIndexOf(46)) > 0 && i < name.length() - 1) {
            return name.substring(i + 1, name.length());
        }
        return null;
    }

    void createAndShowGUI() {
        this.viewOptions = new ViewOptions();
        this.frame = new JFrame("Tinfour Viewer");
        this.frame.setDefaultCloseOperation(3);
        InputStream ins = DataViewerUI.class.getResourceAsStream("resources/piece_of_cake_32_by_32.png");
        if (ins != null) {
            try {
                this.appIconImage = ImageIO.read(ins);
                this.frame.setIconImage(this.appIconImage);
                ins.close();
                ins = null;
            }
            catch (IOException dontCare) {
                // empty catch block
            }
        }
        if ((ins = DataViewerUI.class.getResourceAsStream("resources/SequentialPalettes.csv")) != null) {
            try {
                TestPalette.loadRecipiesFromStream(ins, true);
                ins.close();
                ins = null;
            }
            catch (IOException dontCare) {
                // empty catch block
            }
        }
        this.dvPanel = new DataViewingPanel();
        this.dvPanel.setBackground(Color.white);
        this.dvPanel.setPreferredSize(new Dimension(650, 500));
        this.dvPanel.setBorder(BorderFactory.createBevelBorder(0));
        JPanel dataPanel = new JPanel();
        dataPanel.setPreferredSize(new Dimension(250, 500));
        dataPanel.setLayout(new BorderLayout());
        JEditorPane reportPane = new JEditorPane();
        reportPane.setEditable(false);
        reportPane.setContentType("text/html");
        DefaultCaret dc = (DefaultCaret)reportPane.getCaret();
        dc.setUpdatePolicy(1);
        JScrollPane reportScrollPane = new JScrollPane(reportPane);
        reportScrollPane.setPreferredSize(new Dimension(250, 250));
        JEditorPane queryPane = new JEditorPane();
        queryPane.setEditable(false);
        queryPane.setContentType("text/html");
        dc = (DefaultCaret)queryPane.getCaret();
        dc.setUpdatePolicy(1);
        JScrollPane queryScrollPane = new JScrollPane(queryPane);
        JSplitPane infoSplit = new JSplitPane(0, reportScrollPane, queryScrollPane);
        dataPanel.add((Component)infoSplit, "Center");
        JSplitPane mainSplit = new JSplitPane(1, this.dvPanel, dataPanel);
        mainSplit.setResizeWeight(0.95);
        this.frame.add((Component)mainSplit, "Center");
        JPanel informationPanel = new JPanel();
        informationPanel.setLayout(new GridBagLayout());
        informationPanel.setBorder(BorderFactory.createBevelBorder(0));
        StatusPanel statusPanel = new StatusPanel();
        statusPanel.setPreferredSize(new Dimension(800, 25));
        this.dvPanel.setStatusPanel(statusPanel);
        this.dvPanel.setReportPane(reportPane);
        this.dvPanel.setQueryPane(queryPane);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.6;
        c.anchor = 13;
        c.ipadx = 5;
        informationPanel.add((Component)statusPanel, c);
        this.frame.add((Component)informationPanel, "South");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.ipadx = 5;
        JSeparator js1 = new JSeparator(1);
        js1.setPreferredSize(new Dimension(2, 15));
        informationPanel.add((Component)js1, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.05;
        c.fill = 2;
        c.anchor = 13;
        JLabel readoutLabel = new JLabel("  ");
        readoutLabel.setPreferredSize(new Dimension(250, 25));
        readoutLabel.setToolTipText("Displays data at mouse position");
        informationPanel.add((Component)readoutLabel, c);
        this.dvPanel.setReadoutLabel(readoutLabel);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = this.makeFileMenu();
        JMenu viewMenu = this.makeViewMenu();
        JMenu modelMenu = this.makeModelMenu();
        JMenu helpMenu = this.makeHelpMenu();
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        menuBar.add(modelMenu);
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(helpMenu);
        this.frame.setJMenuBar(menuBar);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    JMenu makeFileMenu() {
        JMenu fileMenu = new JMenu("File");
        JMenuItem newItem = new JMenuItem("New");
        newItem.setToolTipText("Clears data model and view area");
        newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataViewerUI.this.dvPanel.clear();
                DataViewerUI.this.frame.setTitle("Tinfour Viewer");
            }
        });
        ExportControl exportControl = new ExportControl(fileMenu, this.dvPanel);
        JMenuItem openItem = this.makeLoadModelFromFile(fileMenu);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setToolTipText("Exit application");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        fileMenu.add(newItem);
        fileMenu.add(openItem);
        fileMenu.add(new JSeparator(0));
        fileMenu.add(exportControl);
        fileMenu.add(new JSeparator(0));
        fileMenu.add(exitItem);
        return fileMenu;
    }

    JMenuItem makeLoadModelFromFile(final JMenu fileMenu) {
        JMenuItem openItem = new JMenuItem("Load Model from File...");
        openItem.setToolTipText("Raise a dialog to select a new model (data product)");
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataViewerUI.this.fileChooser == null) {
                    DataViewerUI.this.fileChooser = new JFileChooser();
                    FileNameExtensionFilter supported = new FileNameExtensionFilter("Supported files", "csv", "txt", "las", "laz", "shp");
                    DataViewerUI.this.fileChooser.addChoosableFileFilter(supported);
                    LasFileFilter lasFileFilter = new LasFileFilter();
                    DataViewerUI.this.fileChooser.addChoosableFileFilter(lasFileFilter);
                    TextFileFilter textFileFilter = new TextFileFilter();
                    DataViewerUI.this.fileChooser.addChoosableFileFilter(textFileFilter);
                    ShapeFileFilter shapeFilter = new ShapeFileFilter();
                    DataViewerUI.this.fileChooser.addChoosableFileFilter(shapeFilter);
                    DataViewerUI.this.fileChooser.setFileFilter(supported);
                    DataViewerUI.this.fileChooser.setDialogTitle("Select a data source for the model");
                }
                if (DataViewerUI.this.currentDirectory != null) {
                    DataViewerUI.this.fileChooser.setCurrentDirectory(DataViewerUI.this.currentDirectory);
                }
                int returnVal = DataViewerUI.this.fileChooser.showOpenDialog(fileMenu);
                DataViewerUI.this.currentDirectory = DataViewerUI.this.fileChooser.getCurrentDirectory();
                if (returnVal == 0) {
                    File file = DataViewerUI.this.fileChooser.getSelectedFile();
                    if (file != null) {
                        DataViewerUI.this.dvPanel.loadModel(file);
                    }
                } else {
                    System.err.println("Open command cancelled by user.");
                }
            }
        });
        return openItem;
    }

    JMenu makeViewMenu() {
        JMenu viewMenu = new JMenu("View");
        JMenuItem optionsMenu = new JMenuItem("Styling and Presentation...");
        optionsMenu.setToolTipText("Raise the view-options menu");
        optionsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataViewerUI.this.viewOptionsDialog == null) {
                    ViewOptionsPanel viewOptionsPanel = new ViewOptionsPanel();
                    DataViewerUI.this.viewOptionsDialog = new JDialog(DataViewerUI.this.frame, "Options for Viewing Data", false);
                    DataViewerUI.this.viewOptionsDialog.setIconImage(DataViewerUI.this.appIconImage);
                    DataViewerUI.this.viewOptionsDialog.setContentPane(viewOptionsPanel);
                    DataViewerUI.this.viewOptionsDialog.setDefaultCloseOperation(1);
                    viewOptionsPanel.setDataViewingPanel(DataViewerUI.this.dvPanel);
                    viewOptionsPanel.setViewOptions(DataViewerUI.this.viewOptions);
                    DataViewerUI.this.viewOptionsDialog.pack();
                    DataViewerUI.this.viewOptionsDialog.setLocationRelativeTo(DataViewerUI.this.frame);
                    DataViewerUI.this.viewOptionsDialog.setVisible(true);
                } else {
                    DataViewerUI.this.viewOptionsDialog.setVisible(true);
                    DataViewerUI.this.viewOptionsDialog.setLocationRelativeTo(DataViewerUI.this.frame);
                }
            }
        });
        final JCheckBoxMenuItem scaleEnabled = new JCheckBoxMenuItem("Show Scale");
        scaleEnabled.setToolTipText("Select scale for inclusion in view");
        scaleEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showScale = scaleEnabled.isSelected();
                DataViewerUI.this.dvPanel.setShowScale(showScale);
            }
        });
        final JCheckBoxMenuItem legendEnabled = new JCheckBoxMenuItem("Show Legend");
        legendEnabled.setToolTipText("Select legend for inclusion in view");
        legendEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showLegend = legendEnabled.isSelected();
                DataViewerUI.this.dvPanel.setShowLegend(showLegend);
            }
        });
        JMenuItem zoomToSource = new JMenuItem("Zoom to source");
        zoomToSource.setToolTipText("Zoom to show entire coverage area of model");
        zoomToSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataViewerUI.this.dvPanel.zoomToSource();
            }
        });
        JMenuItem zoomToFeature = new JMenuItem("Zoom to feature/position...");
        zoomToFeature.setToolTipText("Raise a dialog for selecting feature or coordinates for zoom");
        zoomToFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (DataViewerUI.this.zoomToFeatureDialog == null) {
                    DataViewerUI.this.zoomToFeaturePanel = new ZoomToFeaturePanel();
                    DataViewerUI.this.zoomToFeaturePanel.registerDataViewingPanel(DataViewerUI.this.dvPanel);
                    DataViewerUI.this.zoomToFeatureDialog = new JDialog(DataViewerUI.this.frame, "Zoom to Feature or Position", false);
                    DataViewerUI.this.zoomToFeatureDialog.setIconImage(DataViewerUI.this.appIconImage);
                    DataViewerUI.this.zoomToFeatureDialog.setContentPane(DataViewerUI.this.zoomToFeaturePanel);
                    DataViewerUI.this.zoomToFeatureDialog.setDefaultCloseOperation(1);
                    DataViewerUI.this.zoomToFeatureDialog.pack();
                    DataViewerUI.this.zoomToFeatureDialog.setLocationRelativeTo(DataViewerUI.this.frame);
                    DataViewerUI.this.zoomToFeatureDialog.setVisible(true);
                } else {
                    if (!DataViewerUI.this.zoomToFeatureDialog.isVisible()) {
                        DataViewerUI.this.zoomToFeaturePanel.transferValuesFromPanel();
                    }
                    DataViewerUI.this.zoomToFeatureDialog.setLocationRelativeTo(DataViewerUI.this.frame);
                    DataViewerUI.this.zoomToFeatureDialog.setVisible(true);
                }
            }
        });
        viewMenu.add(optionsMenu);
        viewMenu.add(new JSeparator());
        viewMenu.add(scaleEnabled);
        viewMenu.add(legendEnabled);
        viewMenu.add(new JSeparator());
        viewMenu.add(zoomToSource);
        viewMenu.add(zoomToFeature);
        return viewMenu;
    }

    JMenu makeModelMenu() {
        final JMenu modelMenu = new JMenu("Model");
        JMenuItem testModel = new JMenuItem("Load test model");
        testModel.setToolTipText("Loads simple model with one-by-one coordinate set");
        testModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataViewerUI.this.dvPanel.loadModel(new UnitSquareModel(150));
            }
        });
        JMenuItem openItem = this.makeLoadModelFromFile(modelMenu);
        JMenuItem constraintsItem = new JMenuItem("Load Constraints from File...");
        constraintsItem.setToolTipText("Raise a dialog to add constraints from file");
        constraintsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataViewerUI.this.constraintChooser == null) {
                    File p;
                    IModel m;
                    File f;
                    File curDir;
                    DataViewerUI.this.constraintChooser = new JFileChooser();
                    if (DataViewerUI.this.fileChooser != null && (curDir = DataViewerUI.this.fileChooser.getCurrentDirectory()) != null) {
                        DataViewerUI.this.constraintChooser.setCurrentDirectory(curDir);
                    }
                    if (DataViewerUI.this.currentDirectory == null && (f = (m = DataViewerUI.this.dvPanel.getModel()).getFile()) != null && (p = f.getParentFile()) != null) {
                        DataViewerUI.this.currentDirectory = p;
                    }
                    if (DataViewerUI.this.currentDirectory != null) {
                        DataViewerUI.this.constraintChooser.setCurrentDirectory(DataViewerUI.this.currentDirectory);
                    }
                    ShapeFileFilter shapeFileFilter = new ShapeFileFilter();
                    DataViewerUI.this.constraintChooser.addChoosableFileFilter(shapeFileFilter);
                    TextFileFilter textFileFilter = new TextFileFilter();
                    DataViewerUI.this.constraintChooser.addChoosableFileFilter(textFileFilter);
                    DataViewerUI.this.constraintChooser.setFileFilter(shapeFileFilter);
                    DataViewerUI.this.constraintChooser.setDialogTitle("Select source for model constraints");
                }
                int returnVal = DataViewerUI.this.constraintChooser.showOpenDialog(modelMenu);
                DataViewerUI.this.currentDirectory = DataViewerUI.this.constraintChooser.getCurrentDirectory();
                if (returnVal == 0) {
                    IModel model = DataViewerUI.this.dvPanel.getModel();
                    if (model == null) {
                        JOptionPane.showMessageDialog(DataViewerUI.this.dvPanel, "Cannot add constraints when no model is loaded", "Error adding constraints", 0);
                        return;
                    }
                    File file = DataViewerUI.this.constraintChooser.getSelectedFile();
                    if (file != null) {
                        System.err.println("load constraints from " + file.getPath());
                        DataViewerUI.this.dvPanel.loadConstraintsAndAddToModel(file);
                    }
                } else {
                    System.err.println("Open command cancelled by user.");
                }
            }
        });
        modelMenu.add(openItem);
        modelMenu.add(constraintsItem);
        modelMenu.add(new JSeparator(0));
        modelMenu.add(testModel);
        return modelMenu;
    }

    void raiseHelpDialog() {
        if (this.helpDialog == null) {
            URL url = this.getClass().getResource("resources/chinese_noodles_32_by_32.png");
            String text = "<html><img src=" + url + "></img>";
            StringBuilder sb = new StringBuilder(2048);
            sb.append(text);
            try {
                int c;
                InputStream ins = this.getClass().getResourceAsStream("resources/HelpInformation.txt");
                BufferedInputStream bins = new BufferedInputStream(ins);
                while ((c = bins.read()) > 0) {
                    sb.append((char)c);
                }
            }
            catch (IOException dontCare) {
                // empty catch block
            }
            sb.append("</html>");
            text = sb.toString();
            JEditorPane pane = new JEditorPane();
            pane.setEditable(false);
            pane.setContentType("text/html");
            pane.setText(text);
            pane.setPreferredSize(new Dimension(700, 600));
            JScrollPane scrollPane = new JScrollPane(pane);
            scrollPane.setPreferredSize(new Dimension(700, 600));
            this.helpDialog = new JDialog(this.frame, "Using Tinfour Viewer", false);
            this.helpDialog.setIconImage(this.appIconImage);
            this.helpDialog.setContentPane(scrollPane);
            this.helpDialog.setDefaultCloseOperation(1);
            this.helpDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                }
            });
            this.helpDialog.pack();
            this.helpDialog.setLocationRelativeTo(this.frame);
            this.helpDialog.setVisible(true);
        } else {
            this.helpDialog.setVisible(true);
            this.helpDialog.setLocationRelativeTo(this.frame);
        }
    }

    JMenu makeHelpMenu() {
        JMenu helpModel = new JMenu("Help");
        JMenuItem showHelp = new JMenuItem("Show Help");
        showHelp.setToolTipText("Show brief information about using this application");
        showHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataViewerUI.this.raiseHelpDialog();
            }
        });
        helpModel.add(showHelp);
        return helpModel;
    }

    private class TextFileFilter
    extends FileFilter {
        private TextFileFilter() {
        }

        @Override
        public String getDescription() {
            return "Space or comma-delimited files (.txt or .csv)";
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = DataViewerUI.getFileExtension(f);
            return "TXT".equalsIgnoreCase(ext) || "CSV".equalsIgnoreCase(ext);
        }
    }

    private class ShapeFileFilter
    extends FileFilter {
        private ShapeFileFilter() {
        }

        @Override
        public String getDescription() {
            return "Shape Files (Polyline and Polygon format only)";
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = DataViewerUI.getFileExtension(f);
            return "shp".equalsIgnoreCase(ext);
        }
    }

    private class LasFileFilter
    extends FileFilter {
        private LasFileFilter() {
        }

        @Override
        public String getDescription() {
            return "Lidar Files (LAS and LAZ format)";
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = DataViewerUI.getFileExtension(f);
            return "LAS".equalsIgnoreCase(ext) || "LAZ".equalsIgnoreCase(ext);
        }
    }
}

